/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.db2.common.LevelDB;
import org.tron.core.db2.common.RocksDB;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.common.WrappedByteArray;
import org.tron.core.db2.core.Snapshot;
import org.tron.core.db2.core.SnapshotImpl;
import org.tron.core.db2.core.SnapshotRoot;
import org.tron.core.exception.ItemNotFoundException;

public class Chainbase
implements IRevokingDB {
    private ThreadLocal<Cursor> cursor = new ThreadLocal();
    private ThreadLocal<Long> offset = new ThreadLocal();
    private Snapshot head;

    public Chainbase(Snapshot head) {
        this.head = head;
        this.cursor.set(Cursor.HEAD);
        this.offset.set(0L);
    }

    public String getDbName() {
        return this.head.getDbName();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.cursor.set(cursor);
    }

    @Override
    public void setCursor(Cursor cursor, long offset) {
        this.cursor.set(cursor);
        this.offset.set(offset);
    }

    @Override
    public Cursor getCursor() {
        if (this.cursor.get() == null) {
            return Cursor.HEAD;
        }
        return this.cursor.get();
    }

    private Snapshot head() {
        if (this.cursor.get() == null) {
            return this.head;
        }
        switch (this.cursor.get()) {
            case HEAD: {
                return this.head;
            }
            case SOLIDITY: {
                return this.head.getSolidity();
            }
            case PBFT: {
                if (this.offset.get() == null) {
                    return this.head.getSolidity();
                }
                if (this.offset.get() >= 0L) {
                    Snapshot tmp = this.head;
                    int i = 0;
                    while ((long)i < this.offset.get() && tmp != tmp.getRoot()) {
                        tmp = tmp.getPrevious();
                        ++i;
                    }
                    return tmp;
                }
                return this.head.getSolidity();
            }
        }
        return this.head;
    }

    public Snapshot getHead() {
        return this.head();
    }

    public synchronized void setHead(Snapshot head) {
        this.head = head;
    }

    @Override
    public synchronized void close() {
        this.head().close();
    }

    @Override
    public synchronized void reset() {
        this.head().reset();
        this.head().close();
        this.head = (Snapshot)this.head.getRoot().newInstance();
    }

    @Override
    public synchronized void put(byte[] key, byte[] value) {
        this.head().put(key, value);
    }

    @Override
    public synchronized void delete(byte[] key) {
        this.head().remove(key);
    }

    @Override
    public byte[] get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.getUnchecked(key);
        if (value == null) {
            throw new ItemNotFoundException();
        }
        return value;
    }

    @Override
    public byte[] getFromRoot(byte[] key) throws ItemNotFoundException {
        byte[] value = this.head().getRoot().get(key);
        if (value == null) {
            throw new ItemNotFoundException();
        }
        return value;
    }

    @Override
    public byte[] getUnchecked(byte[] key) {
        return this.head().get(key);
    }

    @Override
    public boolean has(byte[] key) {
        return this.getUnchecked(key) != null;
    }

    @Override
    public synchronized Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return this.head().iterator();
    }

    @Override
    public Set<byte[]> getValuesNext(byte[] key, long limit) {
        return this.getValuesNext(this.head(), key, limit);
    }

    private Set<byte[]> getValuesNext(Snapshot head, byte[] key, long limit) {
        if (limit <= 0L) {
            return Collections.emptySet();
        }
        HashMap<WrappedByteArray, WrappedByteArray> collection = new HashMap<WrappedByteArray, WrappedByteArray>();
        if (head.getPrevious() != null) {
            ((SnapshotImpl)head).collect(collection);
        }
        HashMap<WrappedByteArray, WrappedByteArray> levelDBMap = new HashMap<WrappedByteArray, WrappedByteArray>();
        if (((SnapshotRoot)head.getRoot()).db.getClass() == LevelDB.class) {
            ((LevelDB)((SnapshotRoot)head.getRoot()).db).getDb().getNext(key, limit).entrySet().stream().map(e -> Maps.immutableEntry((Object)WrappedByteArray.of((byte[])e.getKey()), (Object)WrappedByteArray.of((byte[])e.getValue()))).forEach(e -> {
                WrappedByteArray cfr_ignored_0 = (WrappedByteArray)levelDBMap.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
            });
        } else if (((SnapshotRoot)head.getRoot()).db.getClass() == RocksDB.class) {
            ((RocksDB)((SnapshotRoot)head.getRoot()).db).getDb().getNext(key, limit).entrySet().stream().map(e -> Maps.immutableEntry((Object)WrappedByteArray.of((byte[])e.getKey()), (Object)WrappedByteArray.of((byte[])e.getValue()))).forEach(e -> {
                WrappedByteArray cfr_ignored_0 = (WrappedByteArray)levelDBMap.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
            });
        }
        levelDBMap.putAll(collection);
        return levelDBMap.entrySet().stream().sorted((e1, e2) -> ByteUtil.compare((byte[])((WrappedByteArray)e1.getKey()).getBytes(), (byte[])((WrappedByteArray)e2.getKey()).getBytes())).filter(e -> ByteUtil.greaterOrEquals((byte[])((WrappedByteArray)e.getKey()).getBytes(), (byte[])key)).limit(limit).map(Map.Entry::getValue).map(WrappedByteArray::getBytes).collect(Collectors.toSet());
    }

    @Override
    public List<byte[]> getKeysNext(byte[] key, long limit) {
        return this.getKeysNext(this.head(), key, limit);
    }

    private List<byte[]> getKeysNext(Snapshot head, byte[] key, long limit) {
        if (limit <= 0L) {
            return Collections.emptyList();
        }
        HashMap<WrappedByteArray, Value.Operator> collectionList = new HashMap<WrappedByteArray, Value.Operator>();
        if (head.getPrevious() != null) {
            ((SnapshotImpl)head).collectUnique(collectionList);
        }
        List<Object> snapshotList = new ArrayList();
        if (!collectionList.isEmpty()) {
            snapshotList = collectionList.keySet().stream().filter(e -> MarketUtils.pairKeyIsEqual(e.getBytes(), key)).collect(Collectors.toList());
        }
        long limitLevelDB = limit + (long)collectionList.size();
        ArrayList levelDBList = new ArrayList();
        if (((SnapshotRoot)head.getRoot()).db.getClass() == LevelDB.class) {
            ((LevelDB)((SnapshotRoot)head.getRoot()).db).getDb().getKeysNext(key, limitLevelDB).forEach(e -> levelDBList.add(WrappedByteArray.of(e)));
        } else if (((SnapshotRoot)head.getRoot()).db.getClass() == RocksDB.class) {
            ((RocksDB)((SnapshotRoot)head.getRoot()).db).getDb().getKeysNext(key, limitLevelDB).forEach(e -> levelDBList.add(WrappedByteArray.of(e)));
        }
        List levelDBListFiltered = levelDBList.stream().filter(e -> MarketUtils.pairKeyIsEqual(e.getBytes(), key)).collect(Collectors.toList());
        ArrayList keyList = new ArrayList();
        keyList.addAll(levelDBListFiltered);
        snapshotList.forEach(ssKey -> {
            if (!keyList.contains(ssKey)) {
                keyList.add(ssKey);
            }
            if (collectionList.get(ssKey) == Value.Operator.DELETE) {
                keyList.remove(ssKey);
            }
        });
        return keyList.stream().filter(e -> MarketUtils.greaterOrEquals(e.getBytes(), key)).sorted((e1, e2) -> MarketUtils.comparePriceKey(e1.getBytes(), e2.getBytes())).limit(limit).map(WrappedByteArray::getBytes).collect(Collectors.toList());
    }

    @Override
    public Set<byte[]> getlatestValues(long limit) {
        return this.getlatestValues(this.head(), limit);
    }

    private synchronized Set<byte[]> getlatestValues(Snapshot head, long limit) {
        if (limit <= 0L) {
            return Collections.emptySet();
        }
        HashSet<byte[]> result = new HashSet<byte[]>();
        Snapshot snapshot = head;
        long tmp = limit;
        while (tmp > 0L && snapshot.getPrevious() != null) {
            if (!((SnapshotImpl)snapshot).db.isEmpty()) {
                --tmp;
                Streams.stream((Iterable)((SnapshotImpl)snapshot).db).map(Map.Entry::getValue).map(Value::getBytes).forEach(result::add);
            }
            snapshot = snapshot.getPrevious();
        }
        if (snapshot.getPrevious() == null && tmp != 0L) {
            if (((SnapshotRoot)head.getRoot()).db.getClass() == LevelDB.class) {
                result.addAll(((LevelDB)((SnapshotRoot)snapshot).db).getDb().getlatestValues(tmp));
            } else if (((SnapshotRoot)head.getRoot()).db.getClass() == RocksDB.class) {
                result.addAll(((RocksDB)((SnapshotRoot)snapshot).db).getDb().getlatestValues(tmp));
            }
        }
        return result;
    }

    @Override
    public Map<byte[], byte[]> getNext(byte[] key, long limit) {
        return this.getNext(this.head(), key, limit);
    }

    private Map<byte[], byte[]> getNext(Snapshot head, byte[] key, long limit) {
        if (limit <= 0L) {
            return Collections.emptyMap();
        }
        HashMap<WrappedByteArray, WrappedByteArray> collection = new HashMap<WrappedByteArray, WrappedByteArray>();
        if (head.getPrevious() != null) {
            ((SnapshotImpl)head).collect(collection);
        }
        HashMap<WrappedByteArray, WrappedByteArray> levelDBMap = new HashMap<WrappedByteArray, WrappedByteArray>();
        if (((SnapshotRoot)head.getRoot()).db.getClass() == LevelDB.class) {
            ((LevelDB)((SnapshotRoot)head.getRoot()).db).getDb().getNext(key, limit).entrySet().stream().map(e -> Maps.immutableEntry((Object)WrappedByteArray.of((byte[])e.getKey()), (Object)WrappedByteArray.of((byte[])e.getValue()))).forEach(e -> {
                WrappedByteArray cfr_ignored_0 = (WrappedByteArray)levelDBMap.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
            });
        } else if (((SnapshotRoot)head.getRoot()).db.getClass() == RocksDB.class) {
            ((RocksDB)((SnapshotRoot)head.getRoot()).db).getDb().getNext(key, limit).entrySet().stream().map(e -> Maps.immutableEntry((Object)WrappedByteArray.of((byte[])e.getKey()), (Object)WrappedByteArray.of((byte[])e.getValue()))).forEach(e -> {
                WrappedByteArray cfr_ignored_0 = (WrappedByteArray)levelDBMap.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
            });
        }
        levelDBMap.putAll(collection);
        return levelDBMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)((WrappedByteArray)e.getKey()).getBytes(), (Object)((WrappedByteArray)e.getValue()).getBytes())).sorted((e1, e2) -> ByteUtil.compare((byte[])((byte[])e1.getKey()), (byte[])((byte[])e2.getKey()))).filter(e -> ByteUtil.greaterOrEquals((byte[])((byte[])e.getKey()), (byte[])key)).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<WrappedByteArray, byte[]> prefixQuery(byte[] key) {
        Map<WrappedByteArray, byte[]> result = this.prefixQueryRoot(key);
        Map<WrappedByteArray, byte[]> snapshot = this.prefixQuerySnapshot(key);
        result.putAll(snapshot);
        result.entrySet().removeIf(e -> e.getValue() == null);
        return result;
    }

    private Map<WrappedByteArray, byte[]> prefixQueryRoot(byte[] key) {
        Map<WrappedByteArray, byte[]> result = new HashMap<WrappedByteArray, byte[]>();
        if (((SnapshotRoot)this.head.getRoot()).db.getClass() == LevelDB.class) {
            result = ((LevelDB)((SnapshotRoot)this.head.getRoot()).db).getDb().prefixQuery(key);
        } else if (((SnapshotRoot)this.head.getRoot()).db.getClass() == RocksDB.class) {
            result = ((RocksDB)((SnapshotRoot)this.head.getRoot()).db).getDb().prefixQuery(key);
        }
        return result;
    }

    private Map<WrappedByteArray, byte[]> prefixQuerySnapshot(byte[] key) {
        HashMap<WrappedByteArray, byte[]> result = new HashMap<WrappedByteArray, byte[]>();
        Snapshot snapshot = this.head();
        if (!snapshot.equals(this.head.getRoot())) {
            HashMap<WrappedByteArray, WrappedByteArray> all = new HashMap<WrappedByteArray, WrappedByteArray>();
            ((SnapshotImpl)snapshot).collect(all, key);
            all.forEach((? super K k, ? super V v) -> result.put((WrappedByteArray)k, v.getBytes()));
        }
        return result;
    }

    public static enum Cursor {
        HEAD,
        SOLIDITY,
        PBFT;

    }
}

