/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.storage.WriteOptionsWrapper;
import org.tron.common.storage.rocksdb.RocksDbDataSourceImpl;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db2.common.DB;
import org.tron.core.db2.common.Flusher;
import org.tron.core.db2.common.WrappedByteArray;

public class RocksDB
implements DB<byte[], byte[]>,
Flusher {
    private RocksDbDataSourceImpl db;
    private WriteOptionsWrapper optionsWrapper = WriteOptionsWrapper.getInstance().sync(CommonParameter.getInstance().getStorage().isDbSync());

    public RocksDB(RocksDbDataSourceImpl db) {
        this.db = db;
    }

    @Override
    public byte[] get(byte[] key) {
        return this.db.getData(key);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.db.putData(key, value);
    }

    @Override
    public long size() {
        return this.db.getTotal();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public void remove(byte[] key) {
        this.db.deleteData(key);
    }

    @Override
    public String getDbName() {
        return this.db.getDBName();
    }

    public DBIterator iterator() {
        return this.db.iterator();
    }

    @Override
    public void flush(Map<WrappedByteArray, WrappedByteArray> batch) {
        Map rows = batch.entrySet().stream().map(e -> Maps.immutableEntry((Object)((WrappedByteArray)e.getKey()).getBytes(), (Object)((WrappedByteArray)e.getValue()).getBytes())).collect(HashMap::new, (m, k) -> {
            byte[] cfr_ignored_0 = (byte[])m.put(k.getKey(), k.getValue());
        }, HashMap::putAll);
        this.db.updateByBatch(rows, this.optionsWrapper);
    }

    @Override
    public void close() {
        this.db.closeDB();
    }

    @Override
    public void reset() {
        this.db.resetDb();
    }

    @Override
    public DB<byte[], byte[]> newInstance() {
        return new RocksDB(this.db.newInstance());
    }

    @Override
    public void stat() {
        this.db.stat();
    }

    public RocksDbDataSourceImpl getDb() {
        return this.db;
    }
}

