/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;

public class StorageMarket {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final String LOG_MSG = "NewTotalPool: {}, newTotalReserved: {}.";
    private static final long MS_PER_YEAR = 31536000000L;
    private AccountStore accountStore;
    private DynamicPropertiesStore dynamicPropertiesStore;
    private long supply = 1000000000000000L;

    public StorageMarket(AccountStore accountStore, DynamicPropertiesStore dynamicPropertiesStore) {
        this.accountStore = accountStore;
        this.dynamicPropertiesStore = dynamicPropertiesStore;
    }

    private long exchangeToSupply(boolean isTRX, long quant) {
        logger.info("IsTRX: {}.", (Object)isTRX);
        long balance = isTRX ? this.dynamicPropertiesStore.getTotalStoragePool() : this.dynamicPropertiesStore.getTotalStorageReserved();
        logger.info("Balance: {}.", (Object)balance);
        long newBalance = balance + quant;
        logger.info("Balance + quant: {}.", (Object)(balance + quant));
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.info("IssuedSupply: {}.", (Object)issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchangeToSupply2(boolean isTRX, long quant) {
        logger.info("IsTRX: {}.", (Object)isTRX);
        long balance = isTRX ? this.dynamicPropertiesStore.getTotalStoragePool() : this.dynamicPropertiesStore.getTotalStorageReserved();
        logger.info("Balance: {}.", (Object)balance);
        long newBalance = balance - quant;
        logger.info("Balance - quant: {}.", (Object)(balance - quant));
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.info("IssuedSupply: {}.", (Object)issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchange_from_supply(boolean isTRX, long supplyQuant) {
        long balance = isTRX ? this.dynamicPropertiesStore.getTotalStoragePool() : this.dynamicPropertiesStore.getTotalStorageReserved();
        this.supply -= supplyQuant;
        double exchangeBalance = (double)balance * (Math.pow(1.0 + (double)supplyQuant / (double)this.supply, 2000.0) - 1.0);
        logger.info("ExchangeBalance: {}.", (Object)exchangeBalance);
        long out = (long)exchangeBalance;
        if (isTRX) {
            out = Math.round(exchangeBalance / 100000.0) * 100000L;
            logger.info("Out: {}.", (Object)out);
        }
        return out;
    }

    public long exchange(long from, boolean isTRX) {
        long relay = this.exchangeToSupply(isTRX, from);
        return this.exchange_from_supply(!isTRX, relay);
    }

    public long calculateTax(long duration, long limit) {
        double ratePerYear = (double)this.dynamicPropertiesStore.getStorageExchangeTaxRate() / 100.0;
        double millisecondPerYear = 3.1536E10;
        double feeRate = (double)duration / millisecondPerYear * ratePerYear;
        long storageTax = (long)((double)limit * feeRate);
        logger.info("StorageTax: {}.", (Object)storageTax);
        return storageTax;
    }

    public long tryPayTax(long duration, long limit) {
        long storageTax = this.calculateTax(duration, limit);
        long tax = this.exchange(storageTax, false);
        logger.info("Tax: {}.", (Object)tax);
        long newTotalTax = this.dynamicPropertiesStore.getTotalStorageTax() + tax;
        long newTotalPool = this.dynamicPropertiesStore.getTotalStoragePool() - tax;
        long newTotalReserved = this.dynamicPropertiesStore.getTotalStorageReserved() + storageTax;
        logger.info("Reserved: {}.", (Object)this.dynamicPropertiesStore.getTotalStorageReserved());
        boolean eq = this.dynamicPropertiesStore.getTotalStorageReserved() == 0x2000000000L;
        logger.info("Reserved == 128GB: {}.", (Object)eq);
        logger.info("NewTotalTax: {}, newTotalPool: {}, newTotalReserved: {}.", new Object[]{newTotalTax, newTotalPool, newTotalReserved});
        return storageTax;
    }

    public long payTax(long duration, long limit) {
        long storageTax = this.calculateTax(duration, limit);
        long tax = this.exchange(storageTax, false);
        logger.info("Tax: {}.", (Object)tax);
        long newTotalTax = this.dynamicPropertiesStore.getTotalStorageTax() + tax;
        long newTotalPool = this.dynamicPropertiesStore.getTotalStoragePool() - tax;
        long newTotalReserved = this.dynamicPropertiesStore.getTotalStorageReserved() + storageTax;
        logger.info("Reserved: {}.", (Object)this.dynamicPropertiesStore.getTotalStorageReserved());
        boolean eq = this.dynamicPropertiesStore.getTotalStorageReserved() == 0x2000000000L;
        logger.info("Reserved == 128GB: {}.", (Object)eq);
        logger.info("NewTotalTax: {}, newTotalPool: {}, newTotalReserved: {}.", new Object[]{newTotalTax, newTotalPool, newTotalReserved});
        this.dynamicPropertiesStore.saveTotalStorageTax(newTotalTax);
        this.dynamicPropertiesStore.saveTotalStoragePool(newTotalPool);
        this.dynamicPropertiesStore.saveTotalStorageReserved(newTotalReserved);
        return storageTax;
    }

    public long tryBuyStorageBytes(long storageBought) {
        long relay = this.exchangeToSupply2(false, storageBought);
        return this.exchange_from_supply(true, relay);
    }

    public long tryBuyStorage(long quant) {
        return this.exchange(quant, true);
    }

    public long trySellStorage(long bytes) {
        return this.exchange(bytes, false);
    }

    public AccountCapsule buyStorageBytes(AccountCapsule accountCapsule, long storageBought) {
        long now = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long relay = this.exchangeToSupply2(false, storageBought);
        long quant = this.exchange_from_supply(true, relay);
        long newBalance = accountCapsule.getBalance() - quant;
        logger.info("New balance: {}.", (Object)newBalance);
        long newStorageLimit = currentStorageLimit + storageBought;
        logger.info("StorageBought: {}, newStorageLimit: {}.", (Object)storageBought, (Object)newStorageLimit);
        accountCapsule.setLatestExchangeStorageTime(now);
        accountCapsule.setStorageLimit(newStorageLimit);
        accountCapsule.setBalance(newBalance);
        this.accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        long newTotalPool = this.dynamicPropertiesStore.getTotalStoragePool() + quant;
        long newTotalReserved = this.dynamicPropertiesStore.getTotalStorageReserved() - storageBought;
        logger.info(LOG_MSG, (Object)newTotalPool, (Object)newTotalReserved);
        this.dynamicPropertiesStore.saveTotalStoragePool(newTotalPool);
        this.dynamicPropertiesStore.saveTotalStorageReserved(newTotalReserved);
        return accountCapsule;
    }

    public void buyStorage(AccountCapsule accountCapsule, long quant) {
        long now = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long newBalance = accountCapsule.getBalance() - quant;
        logger.info("New balance: {}.", (Object)newBalance);
        long storageBought = this.exchange(quant, true);
        long newStorageLimit = currentStorageLimit + storageBought;
        logger.info("StorageBought: {}, newStorageLimit: {}.", (Object)storageBought, (Object)newStorageLimit);
        accountCapsule.setLatestExchangeStorageTime(now);
        accountCapsule.setStorageLimit(newStorageLimit);
        accountCapsule.setBalance(newBalance);
        this.accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        long newTotalPool = this.dynamicPropertiesStore.getTotalStoragePool() + quant;
        long newTotalReserved = this.dynamicPropertiesStore.getTotalStorageReserved() - storageBought;
        logger.info(LOG_MSG, (Object)newTotalPool, (Object)newTotalReserved);
        this.dynamicPropertiesStore.saveTotalStoragePool(newTotalPool);
        this.dynamicPropertiesStore.saveTotalStorageReserved(newTotalReserved);
    }

    public void sellStorage(AccountCapsule accountCapsule, long bytes) {
        long now = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long quant = this.exchange(bytes, false);
        long newBalance = accountCapsule.getBalance() + quant;
        long newStorageLimit = currentStorageLimit - bytes;
        logger.info("Quant: {}, newStorageLimit: {}.", (Object)quant, (Object)newStorageLimit);
        accountCapsule.setLatestExchangeStorageTime(now);
        accountCapsule.setStorageLimit(newStorageLimit);
        accountCapsule.setBalance(newBalance);
        this.accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        long newTotalPool = this.dynamicPropertiesStore.getTotalStoragePool() - quant;
        long newTotalReserved = this.dynamicPropertiesStore.getTotalStorageReserved() + bytes;
        logger.info(LOG_MSG, (Object)newTotalPool, (Object)newTotalReserved);
        this.dynamicPropertiesStore.saveTotalStoragePool(newTotalPool);
        this.dynamicPropertiesStore.saveTotalStorageReserved(newTotalReserved);
    }

    public long getAccountLeftStorageInByteFromBought(AccountCapsule accountCapsule) {
        return accountCapsule.getStorageLimit() - accountCapsule.getStorageUsage();
    }
}

