/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.db.TransactionTrace;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;

public class TransactionUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");

    public static Protocol.Transaction newGenesisTransaction(byte[] key, long value) throws IllegalArgumentException {
        if (!DecodeUtil.addressValid((byte[])key)) {
            throw new IllegalArgumentException("Invalid address");
        }
        BalanceContract.TransferContract transferContract = BalanceContract.TransferContract.newBuilder().setAmount(value).setOwnerAddress(ByteString.copyFrom((byte[])"0x000000000000000000000".getBytes())).setToAddress(ByteString.copyFrom((byte[])key)).build();
        return new TransactionCapsule((Message)transferContract, Protocol.Transaction.Contract.ContractType.TransferContract).getInstance();
    }

    public static TransactionInfoCapsule buildTransactionInfoInstance(TransactionCapsule trxCap, BlockCapsule block, TransactionTrace trace) {
        Protocol.TransactionInfo.Builder builder = Protocol.TransactionInfo.newBuilder();
        ReceiptCapsule traceReceipt = trace.getReceipt();
        builder.setResult(Protocol.TransactionInfo.code.SUCESS);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{trace.getRuntimeError()}) || Objects.nonNull(trace.getRuntimeResult().getException())) {
            builder.setResult(Protocol.TransactionInfo.code.FAILED);
            builder.setResMessage(ByteString.copyFromUtf8((String)trace.getRuntimeError()));
        }
        builder.setId(ByteString.copyFrom((byte[])trxCap.getTransactionId().getBytes()));
        ProgramResult programResult = trace.getRuntimeResult();
        long fee = programResult.getRet().getFee() + traceReceipt.getEnergyFee() + traceReceipt.getNetFee() + traceReceipt.getMultiSignFee() + traceReceipt.getMemoFee();
        boolean supportTransactionFeePool = trace.getTransactionContext().getStoreFactory().getChainBaseManager().getDynamicPropertiesStore().supportTransactionFeePool();
        if (supportTransactionFeePool) {
            long packingFee = 0L;
            if (trace.isNetFeeForBandwidth()) {
                packingFee += traceReceipt.getNetFee();
            }
            if (!traceReceipt.getResult().equals((Object)Protocol.Transaction.Result.contractResult.OUT_OF_TIME)) {
                packingFee += traceReceipt.getEnergyFee();
            }
            builder.setPackingFee(packingFee);
        }
        ByteString contractResult2 = ByteString.copyFrom((byte[])programResult.getHReturn());
        ByteString contractAddress = ByteString.copyFrom((byte[])programResult.getContractAddress());
        builder.setFee(fee);
        builder.addContractResult(contractResult2);
        builder.setContractAddress(contractAddress);
        builder.setUnfreezeAmount(programResult.getRet().getUnfreezeAmount());
        builder.setAssetIssueID(programResult.getRet().getAssetIssueID());
        builder.setExchangeId(programResult.getRet().getExchangeId());
        builder.setWithdrawAmount(programResult.getRet().getWithdrawAmount());
        builder.setWithdrawExpireAmount(programResult.getRet().getWithdrawExpireAmount());
        builder.putAllCancelUnfreezeV2Amount(programResult.getRet().getCancelUnfreezeV2AmountMap());
        builder.setExchangeReceivedAmount(programResult.getRet().getExchangeReceivedAmount());
        builder.setExchangeInjectAnotherAmount(programResult.getRet().getExchangeInjectAnotherAmount());
        builder.setExchangeWithdrawAnotherAmount(programResult.getRet().getExchangeWithdrawAnotherAmount());
        builder.setShieldedTransactionFee(programResult.getRet().getShieldedTransactionFee());
        builder.setOrderId(programResult.getRet().getOrderId());
        builder.addAllOrderDetails(programResult.getRet().getOrderDetailsList());
        ArrayList logList = new ArrayList();
        programResult.getLogInfoList().forEach(logInfo -> logList.add(LogInfo.buildLog((LogInfo)logInfo)));
        builder.addAllLog(logList);
        if (Objects.nonNull(block)) {
            builder.setBlockNumber(block.getInstance().getBlockHeader().getRawData().getNumber());
            builder.setBlockTimeStamp(block.getInstance().getBlockHeader().getRawData().getTimestamp());
        }
        builder.setReceipt(traceReceipt.getReceipt());
        if (CommonParameter.getInstance().isSaveInternalTx()) {
            if (CommonParameter.getInstance().isSaveFeaturedInternalTx()) {
                programResult.getInternalTransactions().forEach(it -> builder.addInternalTransactions(TransactionUtil.buildInternalTransaction(it)));
            } else {
                programResult.getInternalTransactions().stream().filter(it -> "call".equals(it.getNote()) || "create".equals(it.getNote()) || "suicide".equals(it.getNote())).forEach(it -> builder.addInternalTransactions(TransactionUtil.buildInternalTransaction(it)));
            }
        }
        return new TransactionInfoCapsule(builder.build());
    }

    public static Protocol.InternalTransaction buildInternalTransaction(InternalTransaction it) {
        Protocol.InternalTransaction.Builder itBuilder = Protocol.InternalTransaction.newBuilder();
        itBuilder.setHash(ByteString.copyFrom((byte[])it.getHash()));
        itBuilder.setCallerAddress(ByteString.copyFrom((byte[])it.getSender()));
        itBuilder.setTransferToAddress(ByteString.copyFrom((byte[])it.getTransferToAddress()));
        Protocol.InternalTransaction.CallValueInfo.Builder callValueInfoBuilder = Protocol.InternalTransaction.CallValueInfo.newBuilder();
        callValueInfoBuilder.setCallValue(it.getValue());
        itBuilder.addCallValueInfo(callValueInfoBuilder);
        it.getTokenInfo().forEach((tokenId, amount) -> itBuilder.addCallValueInfo(Protocol.InternalTransaction.CallValueInfo.newBuilder().setTokenId(tokenId).setCallValue(amount.longValue())));
        itBuilder.setNote(ByteString.copyFrom((byte[])it.getNote().getBytes()));
        itBuilder.setRejected(it.isRejected());
        itBuilder.setExtra(it.getExtra());
        return itBuilder.build();
    }

    public static boolean isNumber(byte[] id) {
        if (ArrayUtils.isEmpty((byte[])id)) {
            return false;
        }
        for (byte b : id) {
            if (b >= 48 && b <= 57) continue;
            return false;
        }
        return id.length <= 1 || id[0] != 48;
    }
}

