/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule.utils;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import org.bouncycastle.util.Arrays;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.MarketAccountOrderCapsule;
import org.tron.core.capsule.MarketOrderCapsule;
import org.tron.core.capsule.MarketPriceCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.MarketAccountStore;
import org.tron.protos.Protocol;

public class MarketUtils {
    public static final int TOKEN_ID_LENGTH = ByteArray.fromString((String)Long.toString(Long.MAX_VALUE)).length;

    public static byte[] calculateOrderId(ByteString address, byte[] sellTokenId, byte[] buyTokenId, long count) {
        byte[] addressByteArray = address.toByteArray();
        byte[] countByteArray = ByteArray.fromLong((long)count);
        byte[] result = new byte[addressByteArray.length + TOKEN_ID_LENGTH + TOKEN_ID_LENGTH + countByteArray.length];
        System.arraycopy(addressByteArray, 0, result, 0, addressByteArray.length);
        System.arraycopy(sellTokenId, 0, result, addressByteArray.length, sellTokenId.length);
        System.arraycopy(buyTokenId, 0, result, addressByteArray.length + TOKEN_ID_LENGTH, buyTokenId.length);
        System.arraycopy(countByteArray, 0, result, addressByteArray.length + TOKEN_ID_LENGTH + TOKEN_ID_LENGTH, countByteArray.length);
        return Hash.sha3((byte[])result);
    }

    public static long findGCD(long number1, long number2) {
        if (number1 == 0L || number2 == 0L) {
            return 0L;
        }
        return MarketUtils.calGCD(number1, number2);
    }

    private static long calGCD(long number1, long number2) {
        if (number2 == 0L) {
            return number1;
        }
        return MarketUtils.calGCD(number2, number1 % number2);
    }

    public static byte[] createPairPriceKey(byte[] sellTokenId, byte[] buyTokenId, long sellTokenQuantity, long buyTokenQuantity) {
        byte[] buyTokenQuantityBytes;
        byte[] sellTokenQuantityBytes;
        long gcd = MarketUtils.findGCD(sellTokenQuantity, buyTokenQuantity);
        if (gcd == 0L) {
            sellTokenQuantityBytes = ByteArray.fromLong((long)sellTokenQuantity);
            buyTokenQuantityBytes = ByteArray.fromLong((long)buyTokenQuantity);
        } else {
            sellTokenQuantityBytes = ByteArray.fromLong((long)(sellTokenQuantity / gcd));
            buyTokenQuantityBytes = ByteArray.fromLong((long)(buyTokenQuantity / gcd));
        }
        return MarketUtils.doCreatePairPriceKey(sellTokenId, buyTokenId, sellTokenQuantityBytes, buyTokenQuantityBytes);
    }

    public static byte[] createPairPriceKeyNoGCD(byte[] sellTokenId, byte[] buyTokenId, long sellTokenQuantity, long buyTokenQuantity) {
        byte[] sellTokenQuantityBytes = ByteArray.fromLong((long)sellTokenQuantity);
        byte[] buyTokenQuantityBytes = ByteArray.fromLong((long)buyTokenQuantity);
        return MarketUtils.doCreatePairPriceKey(sellTokenId, buyTokenId, sellTokenQuantityBytes, buyTokenQuantityBytes);
    }

    private static byte[] doCreatePairPriceKey(byte[] sellTokenId, byte[] buyTokenId, byte[] sellTokenQuantity, byte[] buyTokenQuantity) {
        byte[] result = new byte[TOKEN_ID_LENGTH + TOKEN_ID_LENGTH + sellTokenQuantity.length + buyTokenQuantity.length];
        System.arraycopy(sellTokenId, 0, result, 0, sellTokenId.length);
        System.arraycopy(buyTokenId, 0, result, TOKEN_ID_LENGTH, buyTokenId.length);
        System.arraycopy(sellTokenQuantity, 0, result, TOKEN_ID_LENGTH + TOKEN_ID_LENGTH, sellTokenQuantity.length);
        System.arraycopy(buyTokenQuantity, 0, result, TOKEN_ID_LENGTH + TOKEN_ID_LENGTH + buyTokenQuantity.length, buyTokenQuantity.length);
        return result;
    }

    public static byte[] getPairPriceHeadKey(byte[] sellTokenId, byte[] buyTokenId) {
        return MarketUtils.createPairPriceKey(sellTokenId, buyTokenId, 0L, 0L);
    }

    public static byte[] expandTokenIdToPriceArray(byte[] tokenId) {
        byte[] result = new byte[TOKEN_ID_LENGTH];
        System.arraycopy(tokenId, 0, result, 0, tokenId.length);
        return result;
    }

    public static Protocol.MarketPrice decodeKeyToMarketPrice(byte[] key) {
        byte[] sellTokenQuantity = new byte[8];
        byte[] buyTokenQuantity = new byte[8];
        System.arraycopy(key, 38, sellTokenQuantity, 0, 8);
        System.arraycopy(key, 46, buyTokenQuantity, 0, 8);
        return new MarketPriceCapsule(ByteArray.toLong((byte[])sellTokenQuantity), ByteArray.toLong((byte[])buyTokenQuantity)).getInstance();
    }

    public static Protocol.MarketOrderPair decodeKeyToMarketPair(byte[] key) {
        byte[] sellTokenId = new byte[TOKEN_ID_LENGTH];
        byte[] buyTokenId = new byte[TOKEN_ID_LENGTH];
        System.arraycopy(key, 0, sellTokenId, 0, TOKEN_ID_LENGTH);
        System.arraycopy(key, TOKEN_ID_LENGTH, buyTokenId, 0, TOKEN_ID_LENGTH);
        Protocol.MarketOrderPair.Builder builder = Protocol.MarketOrderPair.newBuilder();
        builder.setSellTokenId(ByteString.copyFrom((byte[])sellTokenId)).setBuyTokenId(ByteString.copyFrom((byte[])buyTokenId));
        return builder.build();
    }

    public static byte[] trim(byte[] bytes) {
        int i;
        for (i = bytes.length - 1; i >= 0 && bytes[i] == 0; --i) {
        }
        return java.util.Arrays.copyOf(bytes, i + 1);
    }

    public static Protocol.MarketOrderPair decodeKeyToMarketPairHuman(byte[] key) {
        byte[] sellTokenId = new byte[TOKEN_ID_LENGTH];
        byte[] buyTokenId = new byte[TOKEN_ID_LENGTH];
        System.arraycopy(key, 0, sellTokenId, 0, TOKEN_ID_LENGTH);
        System.arraycopy(key, TOKEN_ID_LENGTH, buyTokenId, 0, TOKEN_ID_LENGTH);
        sellTokenId = MarketUtils.trim(sellTokenId);
        buyTokenId = MarketUtils.trim(buyTokenId);
        Protocol.MarketOrderPair.Builder builder = Protocol.MarketOrderPair.newBuilder();
        builder.setSellTokenId(ByteString.copyFrom((byte[])sellTokenId)).setBuyTokenId(ByteString.copyFrom((byte[])buyTokenId));
        return builder.build();
    }

    public static boolean pairKeyIsEqual(byte[] key1, byte[] key2) {
        byte[] bytes1 = MarketUtils.decodeKeyToMarketPairKey(key1);
        byte[] bytes2 = MarketUtils.decodeKeyToMarketPairKey(key2);
        return ByteUtil.equals((byte[])bytes1, (byte[])bytes2);
    }

    public static byte[] decodeKeyToMarketPairKey(byte[] key) {
        byte[] pairKey = new byte[TOKEN_ID_LENGTH * 2];
        System.arraycopy(key, 0, pairKey, 0, TOKEN_ID_LENGTH * 2);
        return pairKey;
    }

    public static byte[] createPairKey(byte[] sellTokenId, byte[] buyTokenId) {
        byte[] result = new byte[TOKEN_ID_LENGTH * 2];
        System.arraycopy(sellTokenId, 0, result, 0, sellTokenId.length);
        System.arraycopy(buyTokenId, 0, result, TOKEN_ID_LENGTH, buyTokenId.length);
        return result;
    }

    public static int comparePrice(long price1SellQuantity, long price1BuyQuantity, long price2SellQuantity, long price2BuyQuantity) {
        try {
            return Long.compare(Math.multiplyExact(price1BuyQuantity, price2SellQuantity), Math.multiplyExact(price2BuyQuantity, price1SellQuantity));
        }
        catch (ArithmeticException arithmeticException) {
            BigInteger price1BuyQuantityBI = BigInteger.valueOf(price1BuyQuantity);
            BigInteger price1SellQuantityBI = BigInteger.valueOf(price1SellQuantity);
            BigInteger price2BuyQuantityBI = BigInteger.valueOf(price2BuyQuantity);
            BigInteger price2SellQuantityBI = BigInteger.valueOf(price2SellQuantity);
            return price1BuyQuantityBI.multiply(price2SellQuantityBI).compareTo(price2BuyQuantityBI.multiply(price1SellQuantityBI));
        }
    }

    public static int comparePrice(Protocol.MarketPrice price1, Protocol.MarketPrice price2) {
        return MarketUtils.comparePrice(price1.getSellTokenQuantity(), price1.getBuyTokenQuantity(), price2.getSellTokenQuantity(), price2.getBuyTokenQuantity());
    }

    public static boolean isLowerPrice(Protocol.MarketPrice price1, Protocol.MarketPrice price2) {
        return MarketUtils.comparePrice(price1, price2) == -1;
    }

    public static boolean priceMatch(Protocol.MarketPrice takerPrice, Protocol.MarketPrice makerPrice) {
        return MarketUtils.comparePrice(takerPrice.getBuyTokenQuantity(), takerPrice.getSellTokenQuantity(), makerPrice.getSellTokenQuantity(), makerPrice.getBuyTokenQuantity()) >= 0;
    }

    public static void updateOrderState(MarketOrderCapsule orderCapsule, Protocol.MarketOrder.State state, MarketAccountStore marketAccountStore) throws ItemNotFoundException {
        orderCapsule.setState(state);
        if (state == Protocol.MarketOrder.State.INACTIVE || state == Protocol.MarketOrder.State.CANCELED) {
            MarketAccountOrderCapsule accountOrderCapsule = marketAccountStore.get(orderCapsule.getOwnerAddress().toByteArray());
            accountOrderCapsule.removeOrder(orderCapsule.getID());
            marketAccountStore.put(accountOrderCapsule.createDbKey(), accountOrderCapsule);
        }
    }

    public static long multiplyAndDivide(long a, long b, long c) {
        try {
            long tmp = Math.multiplyExact(a, b);
            return Math.floorDiv(tmp, c);
        }
        catch (ArithmeticException tmp) {
            BigInteger aBig = BigInteger.valueOf(a);
            BigInteger bBig = BigInteger.valueOf(b);
            BigInteger cBig = BigInteger.valueOf(c);
            return aBig.multiply(bBig).divide(cBig).longValue();
        }
    }

    public static void returnSellTokenRemain(MarketOrderCapsule orderCapsule, AccountCapsule accountCapsule, DynamicPropertiesStore dynamicStore, AssetIssueStore assetIssueStore) {
        byte[] sellTokenId = orderCapsule.getSellTokenId();
        long sellTokenQuantityRemain = orderCapsule.getSellTokenQuantityRemain();
        if (java.util.Arrays.equals(sellTokenId, "_".getBytes())) {
            accountCapsule.setBalance(Math.addExact(accountCapsule.getBalance(), sellTokenQuantityRemain));
        } else {
            accountCapsule.addAssetAmountV2(sellTokenId, sellTokenQuantityRemain, dynamicStore, assetIssueStore);
        }
        orderCapsule.setSellTokenQuantityRemain(0L);
    }

    public static int comparePriceKey(byte[] o1, byte[] o2) {
        byte[] pair1 = new byte[TOKEN_ID_LENGTH * 2];
        byte[] pair2 = new byte[TOKEN_ID_LENGTH * 2];
        System.arraycopy(o1, 0, pair1, 0, TOKEN_ID_LENGTH * 2);
        System.arraycopy(o2, 0, pair2, 0, TOKEN_ID_LENGTH * 2);
        int pairResult = Arrays.compareUnsigned((byte[])pair1, (byte[])pair2);
        if (pairResult != 0) {
            return pairResult;
        }
        byte[] getSellTokenQuantity1 = new byte[8];
        byte[] getBuyTokenQuantity1 = new byte[8];
        byte[] getSellTokenQuantity2 = new byte[8];
        byte[] getBuyTokenQuantity2 = new byte[8];
        int longByteNum = 8;
        System.arraycopy(o1, TOKEN_ID_LENGTH + TOKEN_ID_LENGTH, getSellTokenQuantity1, 0, longByteNum);
        System.arraycopy(o1, TOKEN_ID_LENGTH + TOKEN_ID_LENGTH + longByteNum, getBuyTokenQuantity1, 0, longByteNum);
        System.arraycopy(o2, TOKEN_ID_LENGTH + TOKEN_ID_LENGTH, getSellTokenQuantity2, 0, longByteNum);
        System.arraycopy(o2, TOKEN_ID_LENGTH + TOKEN_ID_LENGTH + longByteNum, getBuyTokenQuantity2, 0, longByteNum);
        long sellTokenQuantity1 = ByteArray.toLong((byte[])getSellTokenQuantity1);
        long buyTokenQuantity1 = ByteArray.toLong((byte[])getBuyTokenQuantity1);
        long sellTokenQuantity2 = ByteArray.toLong((byte[])getSellTokenQuantity2);
        long buyTokenQuantity2 = ByteArray.toLong((byte[])getBuyTokenQuantity2);
        if (!(sellTokenQuantity1 != 0L && buyTokenQuantity1 != 0L || sellTokenQuantity2 != 0L && buyTokenQuantity2 != 0L)) {
            return 0;
        }
        if (sellTokenQuantity1 == 0L || buyTokenQuantity1 == 0L) {
            return -1;
        }
        if (sellTokenQuantity2 == 0L || buyTokenQuantity2 == 0L) {
            return 1;
        }
        return MarketUtils.comparePrice(sellTokenQuantity1, buyTokenQuantity1, sellTokenQuantity2, buyTokenQuantity2);
    }

    public static boolean greaterOrEquals(byte[] bytes1, byte[] bytes2) {
        return MarketUtils.comparePriceKey(bytes1, bytes2) >= 0;
    }

    public static boolean checkTokenValid(byte[] tokenId) {
        return java.util.Arrays.equals("_".getBytes(), tokenId) || TransactionUtil.isNumber(tokenId);
    }

    public static void checkPairValid(byte[] sellTokenId, byte[] buyTokenId) throws BadItemException {
        if (!MarketUtils.checkTokenValid(sellTokenId)) {
            throw new BadItemException("sellTokenId is not a valid number");
        }
        if (!MarketUtils.checkTokenValid(buyTokenId)) {
            throw new BadItemException("buyTokenId is not a valid number");
        }
    }
}

