/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;

public class DelegatedResourceCapsule
implements ProtoCapsule<Protocol.DelegatedResource> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    protected static final byte[] V2_PREFIX = new byte[]{1};
    protected static final byte[] V2_LOCK_PREFIX = new byte[]{2};
    private Protocol.DelegatedResource delegatedResource;

    public DelegatedResourceCapsule(Protocol.DelegatedResource delegatedResource) {
        this.delegatedResource = delegatedResource;
    }

    public DelegatedResourceCapsule(byte[] data) {
        try {
            this.delegatedResource = Protocol.DelegatedResource.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public DelegatedResourceCapsule(ByteString from, ByteString to) {
        this.delegatedResource = Protocol.DelegatedResource.newBuilder().setFrom(from).setTo(to).build();
    }

    public static byte[] createDbKey(byte[] from, byte[] to) {
        byte[] key = new byte[from.length + to.length];
        System.arraycopy(from, 0, key, 0, from.length);
        System.arraycopy(to, 0, key, from.length, to.length);
        return key;
    }

    public static byte[] createDbKeyV2(byte[] from, byte[] to, boolean lock) {
        if (lock) {
            return Bytes.concat((byte[][])new byte[][]{V2_LOCK_PREFIX, from, to});
        }
        return Bytes.concat((byte[][])new byte[][]{V2_PREFIX, from, to});
    }

    public ByteString getFrom() {
        return this.delegatedResource.getFrom();
    }

    public ByteString getTo() {
        return this.delegatedResource.getTo();
    }

    public long getFrozenBalanceForEnergy() {
        return this.delegatedResource.getFrozenBalanceForEnergy();
    }

    public void setFrozenBalanceForEnergy(long energy, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForEnergy(energy).setExpireTimeForEnergy(expireTime).build();
    }

    public void addFrozenBalanceForEnergy(long energy, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForEnergy(this.delegatedResource.getFrozenBalanceForEnergy() + energy).setExpireTimeForEnergy(expireTime).build();
    }

    public long getFrozenBalanceForBandwidth() {
        return this.delegatedResource.getFrozenBalanceForBandwidth();
    }

    public long getFrozenBalance(boolean isBandwidth) {
        if (isBandwidth) {
            return this.getFrozenBalanceForBandwidth();
        }
        return this.getFrozenBalanceForEnergy();
    }

    public void setFrozenBalanceForBandwidth(long bandwidth, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForBandwidth(bandwidth).setExpireTimeForBandwidth(expireTime).build();
    }

    public void addFrozenBalanceForBandwidth(long bandwidth, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForBandwidth(this.delegatedResource.getFrozenBalanceForBandwidth() + bandwidth).setExpireTimeForBandwidth(expireTime).build();
    }

    public long getExpireTimeForBandwidth() {
        return this.delegatedResource.getExpireTimeForBandwidth();
    }

    public long getExpireTimeForEnergy() {
        return this.delegatedResource.getExpireTimeForEnergy();
    }

    public void setExpireTimeForBandwidth(long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setExpireTimeForBandwidth(expireTime).build();
    }

    public long getExpireTimeForEnergy(DynamicPropertiesStore dynamicPropertiesStore) {
        if (dynamicPropertiesStore.getAllowMultiSign() == 0L) {
            return this.delegatedResource.getExpireTimeForBandwidth();
        }
        return this.delegatedResource.getExpireTimeForEnergy();
    }

    public void setExpireTimeForEnergy(long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setExpireTimeForEnergy(expireTime).build();
    }

    public byte[] createDbKey() {
        return DelegatedResourceCapsule.createDbKey(this.delegatedResource.getFrom().toByteArray(), this.delegatedResource.getTo().toByteArray());
    }

    @Override
    public byte[] getData() {
        return this.delegatedResource.toByteArray();
    }

    @Override
    public Protocol.DelegatedResource getInstance() {
        return this.delegatedResource;
    }
}

