/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.contract.SmartContractOuterClass;

public class ContractStateCapsule
implements ProtoCapsule<SmartContractOuterClass.ContractState> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private SmartContractOuterClass.ContractState contractState;

    public ContractStateCapsule(SmartContractOuterClass.ContractState contractState) {
        this.contractState = contractState;
    }

    public ContractStateCapsule(byte[] data) {
        try {
            this.contractState = SmartContractOuterClass.ContractState.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
    }

    public ContractStateCapsule(long currentCycle) {
        this.reset(currentCycle);
    }

    @Override
    public byte[] getData() {
        return this.contractState.toByteArray();
    }

    @Override
    public SmartContractOuterClass.ContractState getInstance() {
        return this.contractState;
    }

    public long getEnergyUsage() {
        return this.contractState.getEnergyUsage();
    }

    public void setEnergyUsage(long value) {
        this.contractState = this.contractState.toBuilder().setEnergyUsage(value).build();
    }

    public void addEnergyUsage(long toAdd) {
        this.setEnergyUsage(this.getEnergyUsage() + toAdd);
    }

    public long getEnergyFactor() {
        return this.contractState.getEnergyFactor();
    }

    public void setEnergyFactor(long value) {
        this.contractState = this.contractState.toBuilder().setEnergyFactor(value).build();
    }

    public long getUpdateCycle() {
        return this.contractState.getUpdateCycle();
    }

    public void setUpdateCycle(long value) {
        this.contractState = this.contractState.toBuilder().setUpdateCycle(value).build();
    }

    public void addUpdateCycle(long toAdd) {
        this.setUpdateCycle(this.getUpdateCycle() + toAdd);
    }

    public boolean catchUpToCycle(DynamicPropertiesStore dps) {
        return this.catchUpToCycle(dps.getCurrentCycleNumber(), dps.getDynamicEnergyThreshold(), dps.getDynamicEnergyIncreaseFactor(), dps.getDynamicEnergyMaxFactor());
    }

    public boolean catchUpToCycle(long newCycle, long threshold, long increaseFactor, long maxFactor) {
        long cycleCount;
        long lastCycle = this.getUpdateCycle();
        if (lastCycle == newCycle) {
            return false;
        }
        if (lastCycle > newCycle || lastCycle == 0L) {
            this.reset(newCycle);
            return true;
        }
        long precisionFactor = 10000L;
        if (this.getEnergyUsage() > threshold) {
            double increasePercent = 1.0 + (double)increaseFactor / 10000.0;
            this.contractState = SmartContractOuterClass.ContractState.newBuilder().setUpdateCycle(++lastCycle).setEnergyFactor(Math.min(maxFactor, (long)((double)(this.getEnergyFactor() + 10000L) * increasePercent) - 10000L)).build();
        }
        if ((cycleCount = newCycle - lastCycle) <= 0L) {
            return true;
        }
        double decreasePercent = Math.pow(1.0 - (double)increaseFactor / 4.0 / 10000.0, cycleCount);
        this.contractState = SmartContractOuterClass.ContractState.newBuilder().setUpdateCycle(newCycle).setEnergyFactor(Math.max(0L, (long)((double)(this.getEnergyFactor() + 10000L) * decreasePercent) - 10000L)).build();
        return true;
    }

    public void reset(long latestCycle) {
        this.contractState = SmartContractOuterClass.ContractState.newBuilder().setUpdateCycle(latestCycle).build();
    }
}

