/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class ContractCapsule
implements ProtoCapsule<SmartContractOuterClass.SmartContract> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private SmartContractOuterClass.SmartContract smartContract;
    private byte[] runtimecode;

    public ContractCapsule(SmartContractOuterClass.SmartContract smartContract) {
        this.smartContract = smartContract;
    }

    public ContractCapsule(byte[] data) {
        try {
            this.smartContract = SmartContractOuterClass.SmartContract.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
    }

    public static SmartContractOuterClass.CreateSmartContract getSmartContractFromTransaction(Protocol.Transaction trx) {
        try {
            Any any = trx.getRawData().getContract(0).getParameter();
            SmartContractOuterClass.CreateSmartContract createSmartContract = (SmartContractOuterClass.CreateSmartContract)any.unpack(SmartContractOuterClass.CreateSmartContract.class);
            return createSmartContract;
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public static SmartContractOuterClass.TriggerSmartContract getTriggerContractFromTransaction(Protocol.Transaction trx) {
        try {
            Any any = trx.getRawData().getContract(0).getParameter();
            SmartContractOuterClass.TriggerSmartContract contractTriggerContract = (SmartContractOuterClass.TriggerSmartContract)any.unpack(SmartContractOuterClass.TriggerSmartContract.class);
            return contractTriggerContract;
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public byte[] getCodeHash() {
        return this.smartContract.getCodeHash().toByteArray();
    }

    public void setCodeHash(byte[] codeHash) {
        this.smartContract = this.smartContract.toBuilder().setCodeHash(ByteString.copyFrom((byte[])codeHash)).build();
    }

    public void setRuntimecode(byte[] bytecode) {
        this.runtimecode = bytecode;
    }

    public SmartContractOuterClass.SmartContractDataWrapper generateWrapper() {
        return SmartContractOuterClass.SmartContractDataWrapper.newBuilder().setSmartContract(this.smartContract).setRuntimecode(ByteString.copyFrom((byte[])this.runtimecode)).build();
    }

    @Override
    public byte[] getData() {
        return this.smartContract.toByteArray();
    }

    @Override
    public SmartContractOuterClass.SmartContract getInstance() {
        return this.smartContract;
    }

    public String toString() {
        return this.smartContract.toString();
    }

    public byte[] getOriginAddress() {
        return this.smartContract.getOriginAddress().toByteArray();
    }

    public long getConsumeUserResourcePercent() {
        long percent = this.smartContract.getConsumeUserResourcePercent();
        return Math.max(0L, Math.min(percent, 100L));
    }

    public long getOriginEnergyLimit() {
        long originEnergyLimit = this.smartContract.getOriginEnergyLimit();
        if (originEnergyLimit == 0L) {
            originEnergyLimit = 10000000L;
        }
        return originEnergyLimit;
    }

    public void clearABI() {
        this.smartContract = this.smartContract.toBuilder().setAbi(SmartContractOuterClass.SmartContract.ABI.getDefaultInstance()).build();
    }

    public byte[] getTrxHash() {
        return this.smartContract.getTrxHash().toByteArray();
    }

    public int getContractVersion() {
        return this.smartContract.getVersion();
    }
}

