/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.protos.contract.BalanceContract;

public class BlockBalanceTraceCapsule
implements ProtoCapsule<BalanceContract.BlockBalanceTrace> {
    private BalanceContract.BlockBalanceTrace balanceTrace;

    public BlockBalanceTraceCapsule() {
        this.balanceTrace = BalanceContract.BlockBalanceTrace.newBuilder().build();
    }

    public BlockBalanceTraceCapsule(BlockCapsule blockCapsule) {
        this();
        BalanceContract.BlockBalanceTrace.BlockIdentifier blockIdentifier = BalanceContract.BlockBalanceTrace.BlockIdentifier.newBuilder().setHash(blockCapsule.getBlockId().getByteString()).setNumber(blockCapsule.getNum()).build();
        this.balanceTrace = this.balanceTrace.toBuilder().setBlockIdentifier(blockIdentifier).setTimestamp(blockCapsule.getTimeStamp()).build();
    }

    public BlockBalanceTraceCapsule(byte[] data) throws BadItemException {
        try {
            this.balanceTrace = BalanceContract.BlockBalanceTrace.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("TransactionInfoCapsule proto data parse exception");
        }
    }

    public BlockBalanceTraceCapsule(BalanceContract.BlockBalanceTrace blockBalanceTrace) {
        this.balanceTrace = blockBalanceTrace;
    }

    public void addTransactionBalanceTrace(BalanceContract.TransactionBalanceTrace transactionBalanceTrace) {
        this.balanceTrace = this.balanceTrace.toBuilder().addTransactionBalanceTrace(transactionBalanceTrace).build();
    }

    public void setTransactionBalanceTrace(int index, BalanceContract.TransactionBalanceTrace transactionBalanceTrace) {
        this.balanceTrace = this.balanceTrace.toBuilder().setTransactionBalanceTrace(index, transactionBalanceTrace).build();
    }

    @Override
    public byte[] getData() {
        if (Objects.isNull(this.balanceTrace)) {
            return null;
        }
        return this.balanceTrace.toByteArray();
    }

    @Override
    public BalanceContract.BlockBalanceTrace getInstance() {
        return this.balanceTrace;
    }

    public BalanceContract.BlockBalanceTrace.BlockIdentifier getBlockIdentifier() {
        return this.balanceTrace.getBlockIdentifier();
    }

    public long getTimestamp() {
        return this.balanceTrace.getTimestamp();
    }

    public List<BalanceContract.TransactionBalanceTrace> getTransactions() {
        return this.balanceTrace.getTransactionBalanceTraceList();
    }
}

