/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.contract.SmartContractOuterClass;

public class AbiCapsule
implements ProtoCapsule<SmartContractOuterClass.SmartContract.ABI> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private SmartContractOuterClass.SmartContract.ABI abi;

    public AbiCapsule(byte[] data) {
        try {
            this.abi = SmartContractOuterClass.SmartContract.ABI.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage());
        }
    }

    public AbiCapsule(ContractCapsule contract) {
        this.abi = contract.getInstance().getAbi().toBuilder().build();
    }

    public AbiCapsule(SmartContractOuterClass.SmartContract.ABI abi) {
        this.abi = abi.toBuilder().build();
    }

    @Override
    public byte[] getData() {
        return this.abi.toByteArray();
    }

    @Override
    public SmartContractOuterClass.SmartContract.ABI getInstance() {
        return this.abi;
    }

    public String toString() {
        return this.abi.toString();
    }
}

