/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core;

import com.google.protobuf.ByteString;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.storage.metric.DbStatService;
import org.tron.common.utils.ForkController;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.zksnark.MerkleContainer;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.utils.AssetUtil;
import org.tron.core.capsule.utils.BlockUtil;
import org.tron.core.db.BlockIndexStore;
import org.tron.core.db.BlockStore;
import org.tron.core.db.CommonDataBase;
import org.tron.core.db.CommonStore;
import org.tron.core.db.KhaosDatabase;
import org.tron.core.db.PbftSignDataStore;
import org.tron.core.db.RecentBlockStore;
import org.tron.core.db.RecentTransactionStore;
import org.tron.core.db.TransactionStore;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.HeaderNotFound;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.service.MortgageService;
import org.tron.core.store.AbiStore;
import org.tron.core.store.AccountAssetStore;
import org.tron.core.store.AccountIdIndexStore;
import org.tron.core.store.AccountIndexStore;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AccountTraceStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.BalanceTraceStore;
import org.tron.core.store.CodeStore;
import org.tron.core.store.ContractStateStore;
import org.tron.core.store.ContractStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;
import org.tron.core.store.IncrementalMerkleTreeStore;
import org.tron.core.store.MarketAccountStore;
import org.tron.core.store.MarketOrderStore;
import org.tron.core.store.MarketPairPriceToOrderStore;
import org.tron.core.store.MarketPairToPriceStore;
import org.tron.core.store.NullifierStore;
import org.tron.core.store.ProposalStore;
import org.tron.core.store.SectionBloomStore;
import org.tron.core.store.StorageRowStore;
import org.tron.core.store.TransactionHistoryStore;
import org.tron.core.store.TransactionRetStore;
import org.tron.core.store.TreeBlockIndexStore;
import org.tron.core.store.VotesStore;
import org.tron.core.store.WitnessScheduleStore;
import org.tron.core.store.WitnessStore;
import org.tron.core.store.ZKProofStore;

@Component
public class ChainBaseManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static volatile ChainBaseManager chainBaseManager;
    @Autowired
    private AccountStore accountStore;
    @Autowired
    private AccountAssetStore accountAssetStore;
    @Autowired
    private BlockStore blockStore;
    @Autowired
    private WitnessStore witnessStore;
    @Autowired
    private AssetIssueStore assetIssueStore;
    @Autowired
    private AssetIssueV2Store assetIssueV2Store;
    @Autowired
    private DynamicPropertiesStore dynamicPropertiesStore;
    @Autowired
    private BlockIndexStore blockIndexStore;
    @Autowired
    private AccountIdIndexStore accountIdIndexStore;
    @Autowired
    private AccountIndexStore accountIndexStore;
    @Autowired
    private WitnessScheduleStore witnessScheduleStore;
    @Autowired
    private VotesStore votesStore;
    @Autowired
    private ProposalStore proposalStore;
    @Autowired
    private ExchangeStore exchangeStore;
    @Autowired
    private ExchangeV2Store exchangeV2Store;
    @Autowired
    private MarketAccountStore marketAccountStore;
    @Autowired
    private MarketOrderStore marketOrderStore;
    @Autowired
    private MarketPairPriceToOrderStore marketPairPriceToOrderStore;
    @Autowired
    private MarketPairToPriceStore marketPairToPriceStore;
    @Autowired
    private AbiStore abiStore;
    @Autowired
    private CodeStore codeStore;
    @Autowired
    private ContractStore contractStore;
    @Autowired
    private ContractStateStore contractStateStore;
    @Autowired
    private DelegatedResourceStore delegatedResourceStore;
    @Autowired
    private DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore;
    @Autowired
    private StorageRowStore storageRowStore;
    @Autowired
    private NullifierStore nullifierStore;
    @Autowired
    private ZKProofStore proofStore;
    @Autowired
    private IncrementalMerkleTreeStore merkleTreeStore;
    private MerkleContainer merkleContainer;
    private MortgageService mortgageService;
    @Autowired
    private DelegationStore delegationStore;
    @Autowired
    private KhaosDatabase khaosDb;
    @Autowired
    private CommonStore commonStore;
    @Autowired
    private TransactionStore transactionStore;
    @Autowired
    private TransactionRetStore transactionRetStore;
    @Autowired
    private RecentBlockStore recentBlockStore;
    @Autowired
    private RecentTransactionStore recentTransactionStore;
    @Autowired
    private TransactionHistoryStore transactionHistoryStore;
    private BlockCapsule genesisBlock;
    @Autowired
    private CommonDataBase commonDataBase;
    @Autowired
    private PbftSignDataStore pbftSignDataStore;
    @Autowired
    private BalanceTraceStore balanceTraceStore;
    @Autowired
    private AccountTraceStore accountTraceStore;
    private ForkController forkController = ForkController.instance();
    @Autowired
    private TreeBlockIndexStore merkleTreeIndexStore;
    @Autowired
    private SectionBloomStore sectionBloomStore;
    @Autowired
    private DbStatService dbStatService;
    private NodeType nodeType;
    private long lowestBlockNum = -1L;

    public void closeOneStore(ITronChainBase database) {
        logger.info("******** Begin to close {}. ********", (Object)database.getName());
        try {
            database.close();
        }
        catch (Exception e) {
            logger.info("Failed to close {}.", (Object)database.getName(), (Object)e);
        }
        finally {
            logger.info("******** End to close {}. ********", (Object)database.getName());
        }
    }

    public void closeAllStore() {
        this.dbStatService.shutdown();
        this.closeOneStore(this.transactionRetStore);
        this.closeOneStore(this.recentBlockStore);
        this.closeOneStore(this.transactionHistoryStore);
        this.closeOneStore(this.transactionStore);
        this.closeOneStore(this.accountStore);
        this.closeOneStore(this.blockStore);
        this.closeOneStore(this.blockIndexStore);
        this.closeOneStore(this.accountIdIndexStore);
        this.closeOneStore(this.accountIndexStore);
        this.closeOneStore(this.witnessScheduleStore);
        this.closeOneStore(this.assetIssueStore);
        this.closeOneStore(this.dynamicPropertiesStore);
        this.closeOneStore(this.abiStore);
        this.closeOneStore(this.codeStore);
        this.closeOneStore(this.contractStore);
        this.closeOneStore(this.contractStateStore);
        this.closeOneStore(this.storageRowStore);
        this.closeOneStore(this.exchangeStore);
        this.closeOneStore(this.proposalStore);
        this.closeOneStore(this.votesStore);
        this.closeOneStore(this.delegatedResourceStore);
        this.closeOneStore(this.delegatedResourceAccountIndexStore);
        this.closeOneStore(this.assetIssueV2Store);
        this.closeOneStore(this.exchangeV2Store);
        this.closeOneStore(this.nullifierStore);
        this.closeOneStore(this.merkleTreeStore);
        this.closeOneStore(this.delegationStore);
        this.closeOneStore(this.proofStore);
        this.closeOneStore(this.commonStore);
        this.closeOneStore(this.commonDataBase);
        this.closeOneStore(this.pbftSignDataStore);
        this.closeOneStore(this.sectionBloomStore);
        this.closeOneStore(this.accountAssetStore);
    }

    public List<ByteString> getWitnesses() {
        return this.witnessScheduleStore.getActiveWitnesses();
    }

    public void addWitness(ByteString address) {
        List<ByteString> witnessAddresses = this.witnessScheduleStore.getActiveWitnesses();
        witnessAddresses.add(address);
        this.getWitnessScheduleStore().saveActiveWitnesses(witnessAddresses);
    }

    public BlockCapsule getHead() throws HeaderNotFound {
        List<BlockCapsule> blocks = this.getBlockStore().getBlockByLatestNum(1L);
        if (CollectionUtils.isNotEmpty(blocks)) {
            return blocks.get(0);
        }
        throw new HeaderNotFound("header block not found");
    }

    public synchronized BlockCapsule.BlockId getHeadBlockId() {
        return new BlockCapsule.BlockId(this.dynamicPropertiesStore.getLatestBlockHeaderHash(), this.dynamicPropertiesStore.getLatestBlockHeaderNumber());
    }

    public long getHeadBlockNum() {
        return this.dynamicPropertiesStore.getLatestBlockHeaderNumber();
    }

    public long getHeadBlockTimeStamp() {
        return this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
    }

    public void initGenesis() {
        this.genesisBlock = BlockUtil.newGenesisBlockCapsule();
    }

    public long getHeadSlot() {
        return (this.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp() - this.getGenesisBlock().getTimeStamp()) / 3000L;
    }

    public boolean containBlock(Sha256Hash blockHash) {
        try {
            return this.khaosDb.containBlockInMiniStore(blockHash) != false || this.getBlockStore().get(blockHash.getBytes()) != null;
        }
        catch (BadItemException | ItemNotFoundException e) {
            return false;
        }
    }

    public boolean containBlockInMainChain(BlockCapsule.BlockId blockId) {
        try {
            return this.getBlockStore().get(blockId.getBytes()) != null;
        }
        catch (BadItemException | ItemNotFoundException e) {
            return false;
        }
    }

    public BlockCapsule getKhaosDbHead() {
        return this.khaosDb.getHead();
    }

    public BlockCapsule getBlockById(Sha256Hash hash) throws BadItemException, ItemNotFoundException {
        BlockCapsule block = this.khaosDb.getBlock(hash);
        if (block == null) {
            block = (BlockCapsule)this.getBlockStore().get(hash.getBytes());
        }
        return block;
    }

    public boolean hasBlocks() {
        return this.getBlockStore().isNotEmpty() || this.khaosDb.hasData();
    }

    public void setBlockReference(TransactionCapsule trans) {
        byte[] headHash = this.getDynamicPropertiesStore().getLatestBlockHeaderHash().getBytes();
        long headNum = this.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        trans.setReference(headNum, headHash);
    }

    public BlockCapsule.BlockId getSolidBlockId() {
        try {
            long num = this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
            return this.getBlockIdByNum(num);
        }
        catch (Exception e) {
            return this.getGenesisBlockId();
        }
    }

    public BlockCapsule.BlockId getGenesisBlockId() {
        return this.getGenesisBlock().getBlockId();
    }

    public BlockCapsule.BlockId getBlockIdByNum(long num) throws ItemNotFoundException {
        return this.getBlockIndexStore().get(num);
    }

    public BlockCapsule getBlockByNum(long num) throws ItemNotFoundException, BadItemException {
        return this.getBlockById(this.getBlockIdByNum(num));
    }

    public static ChainBaseManager getInstance() {
        return chainBaseManager;
    }

    public static synchronized void init(ChainBaseManager manager) {
        chainBaseManager = manager;
        AssetUtil.setAccountAssetStore(manager.getAccountAssetStore());
        AssetUtil.setDynamicPropertiesStore(manager.getDynamicPropertiesStore());
    }

    @PostConstruct
    private void init() {
        this.lowestBlockNum = this.blockIndexStore.getLimitNumber(1L, 1L).stream().map(BlockCapsule.BlockId::getNum).findFirst().orElse(0L);
        this.nodeType = this.getLowestBlockNum() > 1L ? NodeType.LITE : NodeType.FULL;
    }

    public boolean isLiteNode() {
        return this.getNodeType() == NodeType.LITE;
    }

    public static ChainBaseManager getChainBaseManager() {
        return chainBaseManager;
    }

    public AccountStore getAccountStore() {
        return this.accountStore;
    }

    public AccountAssetStore getAccountAssetStore() {
        return this.accountAssetStore;
    }

    public BlockStore getBlockStore() {
        return this.blockStore;
    }

    public WitnessStore getWitnessStore() {
        return this.witnessStore;
    }

    public AssetIssueStore getAssetIssueStore() {
        return this.assetIssueStore;
    }

    public AssetIssueV2Store getAssetIssueV2Store() {
        return this.assetIssueV2Store;
    }

    public DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.dynamicPropertiesStore;
    }

    public BlockIndexStore getBlockIndexStore() {
        return this.blockIndexStore;
    }

    public AccountIdIndexStore getAccountIdIndexStore() {
        return this.accountIdIndexStore;
    }

    public AccountIndexStore getAccountIndexStore() {
        return this.accountIndexStore;
    }

    public WitnessScheduleStore getWitnessScheduleStore() {
        return this.witnessScheduleStore;
    }

    public VotesStore getVotesStore() {
        return this.votesStore;
    }

    public ProposalStore getProposalStore() {
        return this.proposalStore;
    }

    public ExchangeStore getExchangeStore() {
        return this.exchangeStore;
    }

    public ExchangeV2Store getExchangeV2Store() {
        return this.exchangeV2Store;
    }

    public MarketAccountStore getMarketAccountStore() {
        return this.marketAccountStore;
    }

    public MarketOrderStore getMarketOrderStore() {
        return this.marketOrderStore;
    }

    public MarketPairPriceToOrderStore getMarketPairPriceToOrderStore() {
        return this.marketPairPriceToOrderStore;
    }

    public MarketPairToPriceStore getMarketPairToPriceStore() {
        return this.marketPairToPriceStore;
    }

    public AbiStore getAbiStore() {
        return this.abiStore;
    }

    public CodeStore getCodeStore() {
        return this.codeStore;
    }

    public ContractStore getContractStore() {
        return this.contractStore;
    }

    public ContractStateStore getContractStateStore() {
        return this.contractStateStore;
    }

    public DelegatedResourceStore getDelegatedResourceStore() {
        return this.delegatedResourceStore;
    }

    public DelegatedResourceAccountIndexStore getDelegatedResourceAccountIndexStore() {
        return this.delegatedResourceAccountIndexStore;
    }

    public StorageRowStore getStorageRowStore() {
        return this.storageRowStore;
    }

    public NullifierStore getNullifierStore() {
        return this.nullifierStore;
    }

    public ZKProofStore getProofStore() {
        return this.proofStore;
    }

    public IncrementalMerkleTreeStore getMerkleTreeStore() {
        return this.merkleTreeStore;
    }

    public MerkleContainer getMerkleContainer() {
        return this.merkleContainer;
    }

    public void setMerkleContainer(MerkleContainer merkleContainer) {
        this.merkleContainer = merkleContainer;
    }

    public MortgageService getMortgageService() {
        return this.mortgageService;
    }

    public void setMortgageService(MortgageService mortgageService) {
        this.mortgageService = mortgageService;
    }

    public DelegationStore getDelegationStore() {
        return this.delegationStore;
    }

    public KhaosDatabase getKhaosDb() {
        return this.khaosDb;
    }

    public CommonStore getCommonStore() {
        return this.commonStore;
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public TransactionRetStore getTransactionRetStore() {
        return this.transactionRetStore;
    }

    public RecentBlockStore getRecentBlockStore() {
        return this.recentBlockStore;
    }

    public RecentTransactionStore getRecentTransactionStore() {
        return this.recentTransactionStore;
    }

    public TransactionHistoryStore getTransactionHistoryStore() {
        return this.transactionHistoryStore;
    }

    public BlockCapsule getGenesisBlock() {
        return this.genesisBlock;
    }

    public void setGenesisBlock(BlockCapsule genesisBlock) {
        this.genesisBlock = genesisBlock;
    }

    public CommonDataBase getCommonDataBase() {
        return this.commonDataBase;
    }

    public PbftSignDataStore getPbftSignDataStore() {
        return this.pbftSignDataStore;
    }

    public BalanceTraceStore getBalanceTraceStore() {
        return this.balanceTraceStore;
    }

    public AccountTraceStore getAccountTraceStore() {
        return this.accountTraceStore;
    }

    public ForkController getForkController() {
        return this.forkController;
    }

    public TreeBlockIndexStore getMerkleTreeIndexStore() {
        return this.merkleTreeIndexStore;
    }

    public void setMerkleTreeIndexStore(TreeBlockIndexStore merkleTreeIndexStore) {
        this.merkleTreeIndexStore = merkleTreeIndexStore;
    }

    public SectionBloomStore getSectionBloomStore() {
        return this.sectionBloomStore;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public long getLowestBlockNum() {
        return this.lowestBlockNum;
    }

    public void setLowestBlockNum(long lowestBlockNum) {
        this.lowestBlockNum = lowestBlockNum;
    }

    public static enum NodeType {
        FULL(0),
        LITE(1);

        private final int type;

        private NodeType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

