/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage.metric;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.prometheus.Metrics;

public abstract class DbStat {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");

    protected void statProperty() {
        try {
            this.getStats().forEach(stat -> {
                String[] tmp = stat.trim().replaceAll(" +", ",").split(",");
                String level = tmp[0];
                double files = Double.parseDouble(tmp[1]);
                double size = Double.parseDouble(tmp[2]) * 1048576.0;
                Metrics.gaugeSet((String)"tron:db_sst_level", (double)files, (String[])new String[]{this.getEngine(), this.getName(), level});
                Metrics.gaugeSet((String)"tron:db_size_bytes", (double)size, (String[])new String[]{this.getEngine(), this.getName(), level});
                logger.info("DB {}, level:{},files:{},size:{} M", new Object[]{this.getName(), level, files, size / 1048576.0});
            });
        }
        catch (Exception e) {
            logger.warn("DB {} stats error", (Object)this.getName(), (Object)e);
        }
    }

    public abstract List<String> getStats() throws Exception;

    public abstract String getEngine();

    public abstract String getName();
}

