/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class WitnessStore
extends TronStoreWithRevoking<WitnessCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    protected WitnessStore(@Value(value="witness") String dbName) {
        super(dbName);
    }

    public List<WitnessCapsule> getAllWitnesses() {
        return Streams.stream(this.iterator()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public WitnessCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new WitnessCapsule(value);
    }

    public List<WitnessCapsule> getWitnessStandby() {
        List<WitnessCapsule> all = this.getAllWitnesses();
        all.sort(Comparator.comparingLong(WitnessCapsule::getVoteCount).reversed().thenComparing(Comparator.comparingInt(w -> w.getAddress().hashCode()).reversed()));
        ArrayList<WitnessCapsule> ret = all.size() > 127 ? new ArrayList<WitnessCapsule>(all.subList(0, 127)) : new ArrayList<WitnessCapsule>(all);
        ret.removeIf(w -> w.getVoteCount() < 1L);
        return ret;
    }
}

