/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.common.iterator;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.db.common.iterator.DBIterator;

public final class RockStoreIterator
implements DBIterator {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private final RocksIterator dbIterator;
    private boolean first = true;
    private final AtomicBoolean close = new AtomicBoolean(false);

    public RockStoreIterator(RocksIterator dbIterator) {
        this.dbIterator = dbIterator;
    }

    @Override
    public void close() throws IOException {
        if (this.close.compareAndSet(false, true)) {
            this.dbIterator.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.close.get()) {
            return false;
        }
        boolean hasNext = false;
        try {
            if (this.first) {
                this.dbIterator.seekToFirst();
                this.first = false;
            }
            if (!(hasNext = this.dbIterator.isValid())) {
                this.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            try {
                this.close();
            }
            catch (Exception e1) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return hasNext;
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        if (this.close.get()) {
            throw new NoSuchElementException();
        }
        final byte[] key = this.dbIterator.key();
        final byte[] value = this.dbIterator.value();
        this.dbIterator.next();
        return new Map.Entry<byte[], byte[]>(){

            @Override
            public byte[] getKey() {
                return key;
            }

            @Override
            public byte[] getValue() {
                return value;
            }

            @Override
            public byte[] setValue(byte[] value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void seek(byte[] key) {
        this.checkState();
        this.dbIterator.seek(key);
        this.first = false;
    }

    @Override
    public void seekToFirst() {
        this.checkState();
        this.dbIterator.seekToFirst();
        this.first = false;
    }

    @Override
    public void seekToLast() {
        this.checkState();
        this.dbIterator.seekToLast();
        this.first = false;
    }

    @Override
    public boolean valid() {
        this.checkState();
        return this.dbIterator.isValid();
    }

    @Override
    public byte[] getKey() {
        this.checkValid();
        return this.dbIterator.key();
    }

    @Override
    public byte[] getValue() {
        this.checkValid();
        return this.dbIterator.value();
    }

    @Override
    public void checkState() {
        if (this.close.get()) {
            throw new IllegalStateException("iterator has been closed");
        }
    }
}

