/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import org.tron.common.utils.Commons;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.contract.Common;

abstract class ResourceProcessor {
    protected DynamicPropertiesStore dynamicPropertiesStore;
    protected AccountStore accountStore;
    protected long precision;
    protected long windowSize;
    protected long averageWindowSize;

    protected ResourceProcessor(DynamicPropertiesStore dynamicPropertiesStore, AccountStore accountStore) {
        this.dynamicPropertiesStore = dynamicPropertiesStore;
        this.accountStore = accountStore;
        this.precision = 1000000L;
        this.windowSize = 28800L;
        this.averageWindowSize = 20L;
    }

    abstract void consume(TransactionCapsule var1, TransactionTrace var2) throws ContractValidateException, AccountResourceInsufficientException, TooBigTransactionResultException, TooBigTransactionException;

    protected long increase(long lastUsage, long usage, long lastTime, long now) {
        return this.increase(lastUsage, usage, lastTime, now, this.windowSize);
    }

    protected long increase(long lastUsage, long usage, long lastTime, long now, long windowSize) {
        long averageLastUsage = this.divideCeil(lastUsage * this.precision, windowSize);
        long averageUsage = this.divideCeil(usage * this.precision, windowSize);
        if (lastTime != now) {
            assert (now > lastTime);
            if (lastTime + windowSize > now) {
                long delta = now - lastTime;
                double decay = (double)(windowSize - delta) / (double)windowSize;
                averageLastUsage = Math.round((double)averageLastUsage * decay);
            } else {
                averageLastUsage = 0L;
            }
        }
        return this.getUsage(averageLastUsage += averageUsage, windowSize);
    }

    public long recovery(AccountCapsule accountCapsule, Common.ResourceCode resourceCode, long lastUsage, long lastTime, long now) {
        long oldWindowSize = accountCapsule.getWindowSize(resourceCode);
        return this.increase(lastUsage, 0L, lastTime, now, oldWindowSize);
    }

    public long increase(AccountCapsule accountCapsule, Common.ResourceCode resourceCode, long lastUsage, long usage, long lastTime, long now) {
        if (this.dynamicPropertiesStore.supportAllowCancelAllUnfreezeV2()) {
            return this.increaseV2(accountCapsule, resourceCode, lastUsage, usage, lastTime, now);
        }
        long oldWindowSize = accountCapsule.getWindowSize(resourceCode);
        long averageLastUsage = this.divideCeil(lastUsage * this.precision, oldWindowSize);
        long averageUsage = this.divideCeil(usage * this.precision, this.windowSize);
        if (lastTime != now) {
            if (lastTime + oldWindowSize > now) {
                long delta = now - lastTime;
                double decay = (double)(oldWindowSize - delta) / (double)oldWindowSize;
                averageLastUsage = Math.round((double)averageLastUsage * decay);
            } else {
                averageLastUsage = 0L;
            }
        }
        long newUsage = this.getUsage(averageLastUsage, oldWindowSize, averageUsage, this.windowSize);
        if (this.dynamicPropertiesStore.supportUnfreezeDelay()) {
            long remainUsage = this.getUsage(averageLastUsage, oldWindowSize);
            if (remainUsage == 0L) {
                accountCapsule.setNewWindowSize(resourceCode, this.windowSize);
                return newUsage;
            }
            long remainWindowSize = oldWindowSize - (now - lastTime);
            long newWindowSize = this.getNewWindowSize(remainUsage, remainWindowSize, usage, this.windowSize, newUsage);
            accountCapsule.setNewWindowSize(resourceCode, newWindowSize);
        }
        return newUsage;
    }

    public long increaseV2(AccountCapsule accountCapsule, Common.ResourceCode resourceCode, long lastUsage, long usage, long lastTime, long now) {
        long oldWindowSizeV2 = accountCapsule.getWindowSizeV2(resourceCode);
        long oldWindowSize = accountCapsule.getWindowSize(resourceCode);
        long averageLastUsage = this.divideCeil(lastUsage * this.precision, oldWindowSize);
        long averageUsage = this.divideCeil(usage * this.precision, this.windowSize);
        if (lastTime != now) {
            if (lastTime + oldWindowSize > now) {
                long delta = now - lastTime;
                double decay = (double)(oldWindowSize - delta) / (double)oldWindowSize;
                averageLastUsage = Math.round((double)averageLastUsage * decay);
            } else {
                averageLastUsage = 0L;
            }
        }
        long newUsage = this.getUsage(averageLastUsage, oldWindowSize, averageUsage, this.windowSize);
        long remainUsage = this.getUsage(averageLastUsage, oldWindowSize);
        if (remainUsage == 0L) {
            accountCapsule.setNewWindowSizeV2(resourceCode, this.windowSize * 1000L);
            return newUsage;
        }
        long remainWindowSize = oldWindowSizeV2 - (now - lastTime) * 1000L;
        long newWindowSize = this.divideCeil(remainUsage * remainWindowSize + usage * this.windowSize * 1000L, newUsage);
        newWindowSize = Math.min(newWindowSize, this.windowSize * 1000L);
        accountCapsule.setNewWindowSizeV2(resourceCode, newWindowSize);
        return newUsage;
    }

    public void unDelegateIncrease(AccountCapsule owner, AccountCapsule receiver, long transferUsage, Common.ResourceCode resourceCode, long now) {
        if (this.dynamicPropertiesStore.supportAllowCancelAllUnfreezeV2()) {
            this.unDelegateIncreaseV2(owner, receiver, transferUsage, resourceCode, now);
            return;
        }
        long lastOwnerTime = owner.getLastConsumeTime(resourceCode);
        long ownerUsage = owner.getUsage(resourceCode);
        ownerUsage = this.increase(owner, resourceCode, ownerUsage, 0L, lastOwnerTime, now);
        long remainOwnerWindowSize = owner.getWindowSize(resourceCode);
        long remainReceiverWindowSize = receiver.getWindowSize(resourceCode);
        remainOwnerWindowSize = remainOwnerWindowSize < 0L ? 0L : remainOwnerWindowSize;
        remainReceiverWindowSize = remainReceiverWindowSize < 0L ? 0L : remainReceiverWindowSize;
        long newOwnerUsage = ownerUsage + transferUsage;
        if (newOwnerUsage == 0L) {
            owner.setNewWindowSize(resourceCode, this.windowSize);
            owner.setUsage(resourceCode, 0L);
            owner.setLatestTime(resourceCode, now);
            return;
        }
        long newOwnerWindowSize = this.getNewWindowSize(ownerUsage, remainOwnerWindowSize, transferUsage, remainReceiverWindowSize, newOwnerUsage);
        owner.setNewWindowSize(resourceCode, newOwnerWindowSize);
        owner.setUsage(resourceCode, newOwnerUsage);
        owner.setLatestTime(resourceCode, now);
    }

    public void unDelegateIncreaseV2(AccountCapsule owner, AccountCapsule receiver, long transferUsage, Common.ResourceCode resourceCode, long now) {
        long lastOwnerTime = owner.getLastConsumeTime(resourceCode);
        long ownerUsage = owner.getUsage(resourceCode);
        long newOwnerUsage = (ownerUsage = this.increase(owner, resourceCode, ownerUsage, 0L, lastOwnerTime, now)) + transferUsage;
        if (newOwnerUsage == 0L) {
            owner.setNewWindowSizeV2(resourceCode, this.windowSize * 1000L);
            owner.setUsage(resourceCode, 0L);
            owner.setLatestTime(resourceCode, now);
            return;
        }
        long remainOwnerWindowSizeV2 = owner.getWindowSizeV2(resourceCode);
        long remainReceiverWindowSizeV2 = receiver.getWindowSizeV2(resourceCode);
        remainOwnerWindowSizeV2 = remainOwnerWindowSizeV2 < 0L ? 0L : remainOwnerWindowSizeV2;
        remainReceiverWindowSizeV2 = remainReceiverWindowSizeV2 < 0L ? 0L : remainReceiverWindowSizeV2;
        long newOwnerWindowSize = this.divideCeil(ownerUsage * remainOwnerWindowSizeV2 + transferUsage * remainReceiverWindowSizeV2, newOwnerUsage);
        newOwnerWindowSize = Math.min(newOwnerWindowSize, this.windowSize * 1000L);
        owner.setNewWindowSizeV2(resourceCode, newOwnerWindowSize);
        owner.setUsage(resourceCode, newOwnerUsage);
        owner.setLatestTime(resourceCode, now);
    }

    private long getNewWindowSize(long lastUsage, long lastWindowSize, long usage, long windowSize, long newUsage) {
        return (lastUsage * lastWindowSize + usage * windowSize) / newUsage;
    }

    private long divideCeil(long numerator, long denominator) {
        return numerator / denominator + (long)(numerator % denominator > 0L ? 1 : 0);
    }

    private long getUsage(long usage, long windowSize) {
        return usage * windowSize / this.precision;
    }

    private long getUsage(long oldUsage, long oldWindowSize, long newUsage, long newWindowSize) {
        return (oldUsage * oldWindowSize + newUsage * newWindowSize) / this.precision;
    }

    protected boolean consumeFeeForBandwidth(AccountCapsule accountCapsule, long fee) {
        try {
            long latestOperationTime = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
            accountCapsule.setLatestOperationTime(latestOperationTime);
            Commons.adjustBalance(this.accountStore, accountCapsule, -fee);
            if (this.dynamicPropertiesStore.supportTransactionFeePool()) {
                this.dynamicPropertiesStore.addTransactionFeePool(fee);
            } else if (this.dynamicPropertiesStore.supportBlackHoleOptimization()) {
                this.dynamicPropertiesStore.burnTrx(fee);
            } else {
                Commons.adjustBalance(this.accountStore, this.accountStore.getBlackhole().createDbKey(), fee);
            }
            return true;
        }
        catch (BalanceInsufficientException e) {
            return false;
        }
    }

    protected boolean consumeFeeForNewAccount(AccountCapsule accountCapsule, long fee) {
        try {
            long latestOperationTime = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
            accountCapsule.setLatestOperationTime(latestOperationTime);
            Commons.adjustBalance(this.accountStore, accountCapsule, -fee);
            if (this.dynamicPropertiesStore.supportBlackHoleOptimization()) {
                this.dynamicPropertiesStore.burnTrx(fee);
            } else {
                Commons.adjustBalance(this.accountStore, this.accountStore.getBlackhole().createDbKey(), fee);
            }
            return true;
        }
        catch (BalanceInsufficientException e) {
            return false;
        }
    }
}

