/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.protos.Protocol;

public class TransactionResultCapsule
implements ProtoCapsule<Protocol.Transaction.Result> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.Transaction.Result transactionResult;

    public TransactionResultCapsule(Protocol.Transaction.Result trxRet) {
        this.transactionResult = trxRet;
    }

    public TransactionResultCapsule(byte[] data) throws BadItemException {
        try {
            this.transactionResult = Protocol.Transaction.Result.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("TransactionResult proto data parse exception");
        }
    }

    public TransactionResultCapsule() {
        this.transactionResult = Protocol.Transaction.Result.newBuilder().build();
    }

    public TransactionResultCapsule(Protocol.Transaction.Result.contractResult code2) {
        this.transactionResult = Protocol.Transaction.Result.newBuilder().setContractRet(code2).build();
    }

    public TransactionResultCapsule(Protocol.Transaction.Result.code code2, long fee) {
        this.transactionResult = Protocol.Transaction.Result.newBuilder().setRet(code2).setFee(fee).build();
    }

    public void setStatus(long fee, Protocol.Transaction.Result.code code2) {
        long oldValue = this.transactionResult.getFee();
        this.transactionResult = this.transactionResult.toBuilder().setFee(oldValue + fee).setRet(code2).build();
    }

    public long getFee() {
        return this.transactionResult.getFee();
    }

    public void setFee(long fee) {
        this.transactionResult = this.transactionResult.toBuilder().setFee(fee).build();
    }

    public long getUnfreezeAmount() {
        return this.transactionResult.getUnfreezeAmount();
    }

    public void setUnfreezeAmount(long amount) {
        this.transactionResult = this.transactionResult.toBuilder().setUnfreezeAmount(amount).build();
    }

    public String getAssetIssueID() {
        return this.transactionResult.getAssetIssueID();
    }

    public void setAssetIssueID(String id) {
        this.transactionResult = this.transactionResult.toBuilder().setAssetIssueID(id).build();
    }

    public long getWithdrawAmount() {
        return this.transactionResult.getWithdrawAmount();
    }

    public void setWithdrawAmount(long amount) {
        this.transactionResult = this.transactionResult.toBuilder().setWithdrawAmount(amount).build();
    }

    public long getWithdrawExpireAmount() {
        return this.transactionResult.getWithdrawExpireAmount();
    }

    public void setWithdrawExpireAmount(long amount) {
        this.transactionResult = this.transactionResult.toBuilder().setWithdrawExpireAmount(amount).build();
    }

    public Map<String, Long> getCancelUnfreezeV2AmountMap() {
        return this.transactionResult.getCancelUnfreezeV2AmountMap();
    }

    public void putAllCancelUnfreezeV2AmountMap(Map<String, Long> map) {
        this.transactionResult = this.transactionResult.toBuilder().putAllCancelUnfreezeV2Amount(map).build();
    }

    public long getExchangeReceivedAmount() {
        return this.transactionResult.getExchangeReceivedAmount();
    }

    public void setExchangeReceivedAmount(long amount) {
        this.transactionResult = this.transactionResult.toBuilder().setExchangeReceivedAmount(amount).build();
    }

    public long getExchangeWithdrawAnotherAmount() {
        return this.transactionResult.getExchangeWithdrawAnotherAmount();
    }

    public void setExchangeWithdrawAnotherAmount(long amount) {
        this.transactionResult = this.transactionResult.toBuilder().setExchangeWithdrawAnotherAmount(amount).build();
    }

    public long getExchangeId() {
        return this.transactionResult.getExchangeId();
    }

    public void setExchangeId(long id) {
        this.transactionResult = this.transactionResult.toBuilder().setExchangeId(id).build();
    }

    public long getExchangeInjectAnotherAmount() {
        return this.transactionResult.getExchangeInjectAnotherAmount();
    }

    public void setExchangeInjectAnotherAmount(long amount) {
        this.transactionResult = this.transactionResult.toBuilder().setExchangeInjectAnotherAmount(amount).build();
    }

    public void addFee(long fee) {
        this.transactionResult = this.transactionResult.toBuilder().setFee(this.transactionResult.getFee() + fee).build();
    }

    public void setErrorCode(Protocol.Transaction.Result.code code2) {
        this.transactionResult = this.transactionResult.toBuilder().setRet(code2).build();
    }

    public long getShieldedTransactionFee() {
        return this.transactionResult.getShieldedTransactionFee();
    }

    public void setShieldedTransactionFee(long fee) {
        this.transactionResult = this.transactionResult.toBuilder().setShieldedTransactionFee(fee).build();
    }

    public ByteString getOrderId() {
        return this.transactionResult.getOrderId();
    }

    public void setOrderId(ByteString orderId) {
        this.transactionResult = this.transactionResult.toBuilder().setOrderId(orderId).build();
    }

    public List<Protocol.MarketOrderDetail> getOrderDetailsList() {
        return this.transactionResult.getOrderDetailsList();
    }

    public void addOrderDetails(Protocol.MarketOrderDetail orderDetail) {
        this.transactionResult = this.transactionResult.toBuilder().addOrderDetails(orderDetail).build();
    }

    @Override
    public byte[] getData() {
        return this.transactionResult.toByteArray();
    }

    @Override
    public Protocol.Transaction.Result getInstance() {
        return this.transactionResult;
    }
}

