/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.protos.Protocol;

public class MarketPriceCapsule
implements ProtoCapsule<Protocol.MarketPrice> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.MarketPrice price;

    public MarketPriceCapsule() {
        this.price = Protocol.MarketPrice.newBuilder().setSellTokenQuantity(0L).setBuyTokenQuantity(0L).build();
    }

    public MarketPriceCapsule(Protocol.MarketPrice price) {
        this.price = price;
    }

    public MarketPriceCapsule(byte[] data) {
        try {
            this.price = Protocol.MarketPrice.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public MarketPriceCapsule(long sellTokenQuantity, long buyTokenQuantity) {
        this.price = Protocol.MarketPrice.newBuilder().setSellTokenQuantity(sellTokenQuantity).setBuyTokenQuantity(buyTokenQuantity).build();
    }

    public long getSellTokenQuantity() {
        return this.price.getSellTokenQuantity();
    }

    public void setSellTokenQuantity(long sellTokenQuantity) {
        this.price = this.price.toBuilder().setSellTokenQuantity(sellTokenQuantity).build();
    }

    public long getBuyTokenQuantity() {
        return this.price.getBuyTokenQuantity();
    }

    public void setBuyTokenQuantity(long value) {
        this.price = this.price.toBuilder().setBuyTokenQuantity(value).build();
    }

    public byte[] getKey(byte[] sellTokenId, byte[] buyTokenId) {
        if (this.isNull()) {
            return new byte[0];
        }
        return MarketUtils.createPairPriceKey(sellTokenId, buyTokenId, this.getSellTokenQuantity(), this.getBuyTokenQuantity());
    }

    public boolean isNull() {
        return this.getSellTokenQuantity() == 0L && this.getBuyTokenQuantity() == 0L;
    }

    @Override
    public byte[] getData() {
        return this.price.toByteArray();
    }

    @Override
    public Protocol.MarketPrice getInstance() {
        return this.price;
    }
}

