/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.zksnark.IncrementalMerkleVoucherContainer;
import org.tron.core.capsule.IncrementalMerkleTreeCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.protos.contract.ShieldContract;

public class IncrementalMerkleVoucherCapsule
implements ProtoCapsule<ShieldContract.IncrementalMerkleVoucher> {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalMerkleVoucherCapsule.class);
    private ShieldContract.IncrementalMerkleVoucher voucher;

    public IncrementalMerkleVoucherCapsule() {
        this.voucher = ShieldContract.IncrementalMerkleVoucher.getDefaultInstance();
    }

    public IncrementalMerkleVoucherCapsule(ShieldContract.IncrementalMerkleVoucher voucher) {
        this.voucher = voucher;
    }

    public IncrementalMerkleVoucherCapsule(byte[] data) {
        try {
            this.voucher = ShieldContract.IncrementalMerkleVoucher.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public IncrementalMerkleTreeCapsule getTree() {
        return new IncrementalMerkleTreeCapsule(this.voucher.getTree());
    }

    public void setTree(IncrementalMerkleTreeCapsule merkleTreeCapsule) {
        this.voucher = this.voucher.toBuilder().setTree(merkleTreeCapsule.getInstance()).build();
    }

    public List<ShieldContract.PedersenHash> getFilled() {
        return this.voucher.getFilledList();
    }

    public void addFilled(ShieldContract.PedersenHash value) {
        this.voucher = this.voucher.toBuilder().addFilled(value).build();
    }

    public IncrementalMerkleTreeCapsule getCursor() {
        return new IncrementalMerkleTreeCapsule(this.voucher.getCursor());
    }

    public void setCursor(IncrementalMerkleTreeCapsule cursor) {
        this.voucher = this.voucher.toBuilder().setCursor(cursor.getInstance()).build();
    }

    public void clearCursor() {
        this.voucher = this.voucher.toBuilder().clearCursor().build();
    }

    public long getCursorDepth() {
        return this.voucher.getCursorDepth();
    }

    public void setCursorDepth(long cursorDepth) {
        this.voucher = this.voucher.toBuilder().setCursorDepth(cursorDepth).build();
    }

    public void resetRt() throws ZksnarkException {
        this.voucher = this.voucher.toBuilder().setRt(this.toMerkleVoucherContainer().root().getContent()).build();
    }

    public ShieldContract.OutputPoint getOutputPoint() {
        return this.voucher.getOutputPoint();
    }

    public void setOutputPoint(ByteString hash, int index) {
        this.voucher = this.voucher.toBuilder().setOutputPoint(ShieldContract.OutputPoint.newBuilder().setHash(hash).setIndex(index).build()).build();
    }

    @Override
    public byte[] getData() {
        return this.voucher.toByteArray();
    }

    @Override
    public ShieldContract.IncrementalMerkleVoucher getInstance() {
        return this.voucher;
    }

    public IncrementalMerkleVoucherContainer toMerkleVoucherContainer() {
        return new IncrementalMerkleVoucherContainer(this);
    }
}

