/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.zksnark.IncrementalMerkleTreeContainer;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.contract.ShieldContract;

public class IncrementalMerkleTreeCapsule
implements ProtoCapsule<ShieldContract.IncrementalMerkleTree> {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalMerkleTreeCapsule.class);
    private ShieldContract.IncrementalMerkleTree merkleTree;

    public IncrementalMerkleTreeCapsule() {
        this.merkleTree = ShieldContract.IncrementalMerkleTree.getDefaultInstance();
    }

    public IncrementalMerkleTreeCapsule(ShieldContract.IncrementalMerkleTree merkleTree) {
        this.merkleTree = merkleTree;
    }

    public IncrementalMerkleTreeCapsule(byte[] data) {
        try {
            this.merkleTree = ShieldContract.IncrementalMerkleTree.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public ShieldContract.PedersenHash getLeft() {
        return this.merkleTree.getLeft();
    }

    public void setLeft(ShieldContract.PedersenHash left) {
        this.merkleTree = this.merkleTree.toBuilder().setLeft(left).build();
    }

    public Boolean leftIsEmpty() {
        return this.merkleTree.getLeft().getContent().isEmpty();
    }

    public void clearLeft() {
        this.merkleTree = this.merkleTree.toBuilder().clearLeft().build();
    }

    public ShieldContract.PedersenHash getRight() {
        return this.merkleTree.getRight();
    }

    public void setRight(ShieldContract.PedersenHash right) {
        this.merkleTree = this.merkleTree.toBuilder().setRight(right).build();
    }

    public Boolean rightIsEmpty() {
        return this.merkleTree.getRight().getContent().isEmpty();
    }

    public void clearRight() {
        this.merkleTree = this.merkleTree.toBuilder().clearRight().build();
    }

    public List<ShieldContract.PedersenHash> getParents() {
        return this.merkleTree.getParentsList();
    }

    public Boolean parentsIsEmpty() {
        return this.merkleTree.getParentsList().isEmpty();
    }

    public void setParents(int index, ShieldContract.PedersenHash parents) {
        this.merkleTree = this.merkleTree.toBuilder().setParents(index, parents).build();
    }

    public void addParents(ShieldContract.PedersenHash parents) {
        this.merkleTree = this.merkleTree.toBuilder().addParents(parents).build();
    }

    public void clearParents(int index) {
        this.merkleTree = this.merkleTree.toBuilder().setParents(index, ShieldContract.PedersenHash.newBuilder().build()).build();
    }

    public boolean isEmptyTree() {
        return this.parentsIsEmpty() != false && this.leftIsEmpty() != false && this.rightIsEmpty() != false;
    }

    public boolean notEmptyTree() {
        return !this.isEmptyTree();
    }

    @Override
    public byte[] getData() {
        return this.merkleTree.toByteArray();
    }

    @Override
    public ShieldContract.IncrementalMerkleTree getInstance() {
        return this.merkleTree;
    }

    public IncrementalMerkleTreeContainer toMerkleTreeContainer() {
        return new IncrementalMerkleTreeContainer(this);
    }

    public IncrementalMerkleTreeCapsule deepCopy() {
        byte[] data = Arrays.copyOf(this.getData(), this.getData().length);
        return new IncrementalMerkleTreeCapsule(data);
    }
}

