/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.iq80.leveldb.Options;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Property;

public class StorageUtils {
    public static boolean getEnergyLimitHardFork() {
        return CommonParameter.ENERGY_LIMIT_HARD_FORK;
    }

    public static String getOutputDirectoryByDbName(String dbName) {
        String path = StorageUtils.getPathByDbName(dbName);
        if (!StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        return StorageUtils.getOutputDirectory();
    }

    public static String getPathByDbName(String dbName) {
        if (StorageUtils.hasProperty(dbName)) {
            return StorageUtils.getProperty(dbName).getPath();
        }
        return null;
    }

    private static boolean hasProperty(String dbName) {
        if (CommonParameter.getInstance().getStorage().getPropertyMap() != null) {
            return CommonParameter.getInstance().getStorage().getPropertyMap().containsKey(dbName);
        }
        return false;
    }

    private static Property getProperty(String dbName) {
        return (Property)CommonParameter.getInstance().getStorage().getPropertyMap().get(dbName);
    }

    public static String getOutputDirectory() {
        if (!"".equals(CommonParameter.getInstance().getOutputDirectory()) && !CommonParameter.getInstance().getOutputDirectory().endsWith(File.separator)) {
            return CommonParameter.getInstance().getOutputDirectory() + File.separator;
        }
        return CommonParameter.getInstance().getOutputDirectory();
    }

    public static Options getOptionsByDbName(String dbName) {
        if (StorageUtils.hasProperty(dbName)) {
            return StorageUtils.getProperty(dbName).getDbOptions();
        }
        return CommonParameter.getInstance().getStorage().newDefaultDbOptions(dbName);
    }
}

