/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.store.DynamicPropertiesStore;

public class ForkController {
    private static final Logger logger = LoggerFactory.getLogger((String)"utils");
    private static final byte VERSION_DOWNGRADE = 0;
    private static final byte VERSION_UPGRADE = 1;
    private static final byte[] check = new byte[1024];
    private ChainBaseManager manager;

    public void init(ChainBaseManager manager) {
        this.manager = manager;
        DynamicPropertiesStore store = manager.getDynamicPropertiesStore();
        int latestVersion = store.getLatestVersion();
        if (latestVersion == 0) {
            for (Parameter.ForkBlockVersionEnum version : Parameter.ForkBlockVersionEnum.values()) {
                int v = version.getValue();
                if (!this.pass(v) || latestVersion >= v) continue;
                latestVersion = v;
            }
            store.saveLatestVersion(latestVersion);
        }
    }

    public boolean pass(Parameter.ForkBlockVersionEnum forkBlockVersionEnum) {
        return this.pass(forkBlockVersionEnum.getValue());
    }

    public synchronized boolean pass(int version) {
        if (this.manager == null) {
            throw new IllegalStateException("not inited");
        }
        if (version > Parameter.ForkBlockVersionEnum.VERSION_4_0.getValue()) {
            return this.passNew(version);
        }
        return this.passOld(version);
    }

    private boolean passOld(int version) {
        if (version == 5) {
            return this.checkForEnergyLimit();
        }
        byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(version);
        return this.check(stats);
    }

    private boolean passNew(int version) {
        Parameter.ForkBlockVersionEnum versionEnum = Parameter.ForkBlockVersionEnum.getForkBlockVersionEnum((int)version);
        if (versionEnum == null) {
            logger.warn("Not exist block version: {}.", (Object)version);
            return false;
        }
        long latestBlockTime = this.manager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        long maintenanceTimeInterval = this.manager.getDynamicPropertiesStore().getMaintenanceTimeInterval();
        long hardForkTime = ((versionEnum.getHardForkTime() - 1L) / maintenanceTimeInterval + 1L) * maintenanceTimeInterval;
        if (latestBlockTime < hardForkTime) {
            return false;
        }
        byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(version);
        if (stats == null || stats.length == 0) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < stats.length; ++i) {
            if (check[i] != stats[i]) continue;
            ++count;
        }
        return (double)count >= Math.ceil((double)versionEnum.getHardForkRate() * (double)stats.length / 100.0);
    }

    private boolean checkForEnergyLimit() {
        long blockNum = this.manager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        return blockNum >= CommonParameter.getInstance().getBlockNumForEnergyLimit();
    }

    private boolean check(byte[] stats) {
        if (stats == null || stats.length == 0) {
            return false;
        }
        for (int i = 0; i < stats.length; ++i) {
            if (check[i] == stats[i]) continue;
            return false;
        }
        return true;
    }

    private void downgrade(int version, int slot) {
        for (Parameter.ForkBlockVersionEnum versionEnum : Parameter.ForkBlockVersionEnum.values()) {
            byte[] stats;
            int versionValue = versionEnum.getValue();
            if (versionValue <= version || this.pass(versionValue) || !Objects.nonNull(stats = this.manager.getDynamicPropertiesStore().statsByVersion(versionValue))) continue;
            stats[slot] = 0;
            this.manager.getDynamicPropertiesStore().statsByVersion(versionValue, stats);
        }
    }

    private void upgrade(int version, int slotSize) {
        for (Parameter.ForkBlockVersionEnum versionEnum : Parameter.ForkBlockVersionEnum.values()) {
            int versionValue = versionEnum.getValue();
            if (versionValue >= version || this.pass(versionValue)) continue;
            byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(versionValue);
            if (stats == null || stats.length == 0) {
                stats = new byte[slotSize];
            }
            Arrays.fill(stats, (byte)1);
            this.manager.getDynamicPropertiesStore().statsByVersion(versionValue, stats);
        }
    }

    public synchronized void update(BlockCapsule blockCapsule) {
        ByteString witness;
        List<ByteString> witnesses = this.manager.getWitnessScheduleStore().getActiveWitnesses();
        int slot = witnesses.indexOf(witness = blockCapsule.getWitnessAddress());
        if (slot < 0) {
            return;
        }
        int version = blockCapsule.getInstance().getBlockHeader().getRawData().getVersion();
        if (version < 5) {
            return;
        }
        if (this.manager.getDynamicPropertiesStore().getLatestVersion() >= version) {
            return;
        }
        this.downgrade(version, slot);
        byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(version);
        if (Objects.isNull(stats) || stats.length != witnesses.size()) {
            stats = new byte[witnesses.size()];
        }
        if (this.pass(version)) {
            this.upgrade(version, stats.length);
            this.manager.getDynamicPropertiesStore().saveLatestVersion(version);
            return;
        }
        stats[slot] = 1;
        this.manager.getDynamicPropertiesStore().statsByVersion(version, stats);
        logger.info("Update hard fork: {}, witness size: {}, solt: {}, witness: {}, version: {}.", new Object[]{Streams.zip(witnesses.stream(), Stream.of(ArrayUtils.toObject((byte[])stats)), Maps::immutableEntry).map(e -> Maps.immutableEntry((Object)StringUtil.encode58Check((byte[])((ByteString)e.getKey()).toByteArray()), e.getValue())).map(e -> Maps.immutableEntry((Object)StringUtils.substring((String)((String)e.getKey()), (int)(((String)e.getKey()).length() - 4)), e.getValue())).collect(Collectors.toList()), witnesses.size(), slot, StringUtil.encode58Check((byte[])witness.toByteArray()), version});
    }

    public synchronized void reset() {
        int size = this.manager.getWitnessScheduleStore().getActiveWitnesses().size();
        for (Parameter.ForkBlockVersionEnum versionEnum : Parameter.ForkBlockVersionEnum.values()) {
            int versionValue = versionEnum.getValue();
            byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(versionValue);
            if (!Objects.nonNull(stats) || this.pass(versionValue)) continue;
            stats = new byte[size];
            this.manager.getDynamicPropertiesStore().statsByVersion(versionValue, stats);
        }
    }

    public static ForkController instance() {
        return ForkControllerEnum.INSTANCE.getInstance();
    }

    public ChainBaseManager getManager() {
        return this.manager;
    }

    static {
        Arrays.fill(check, (byte)1);
    }

    private static enum ForkControllerEnum {
        INSTANCE;

        private ForkController instance = new ForkController();

        private ForkController getInstance() {
            return this.instance;
        }
    }
}

