/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.tron.core.actuator.UnfreezeBalanceV2Actuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.Protocol;

public class FreezeV2Util {
    private FreezeV2Util() {
    }

    public static long queryExpireUnfreezeBalanceV2(byte[] address, long time, Repository repository) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return 0L;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        if (accountCapsule == null) {
            return 0L;
        }
        List unfrozenV2List = accountCapsule.getInstance().getUnfrozenV2List();
        return FreezeV2Util.getTotalWithdrawUnfreeze(unfrozenV2List, time);
    }

    public static long queryUnfreezableBalanceV2(byte[] address, long type, Repository repository) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return 0L;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        if (accountCapsule == null) {
            return 0L;
        }
        if (type == 0L) {
            return accountCapsule.getFrozenV2BalanceForBandwidth();
        }
        if (type == 1L) {
            return accountCapsule.getFrozenV2BalanceForEnergy();
        }
        if (type == 2L) {
            return accountCapsule.getTronPowerFrozenV2Balance();
        }
        return 0L;
    }

    public static long queryResourceV2(byte[] from, byte[] to, long type, Repository repository) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return 0L;
        }
        byte[] key = DelegatedResourceCapsule.createDbKeyV2((byte[])from, (byte[])to, (boolean)false);
        byte[] lockKey = DelegatedResourceCapsule.createDbKeyV2((byte[])from, (byte[])to, (boolean)true);
        DelegatedResourceCapsule delegatedResource = repository.getDelegatedResource(key);
        DelegatedResourceCapsule lockDelegateResource = repository.getDelegatedResource(lockKey);
        if (delegatedResource == null && lockDelegateResource == null) {
            return 0L;
        }
        long amount = 0L;
        if (type == 0L) {
            if (delegatedResource != null) {
                amount += delegatedResource.getFrozenBalanceForBandwidth();
            }
            if (lockDelegateResource != null) {
                amount += lockDelegateResource.getFrozenBalanceForBandwidth();
            }
            return amount;
        }
        if (type == 1L) {
            if (delegatedResource != null) {
                amount += delegatedResource.getFrozenBalanceForEnergy();
            }
            if (lockDelegateResource != null) {
                amount += lockDelegateResource.getFrozenBalanceForEnergy();
            }
            return amount;
        }
        return 0L;
    }

    public static Pair<Long, Long> queryFrozenBalanceUsage(byte[] address, long type, Repository repository) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return Pair.of((Object)0L, (Object)0L);
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        if (accountCapsule == null) {
            return Pair.of((Object)0L, (Object)0L);
        }
        if (type == 0L) {
            return repository.getAccountNetUsageBalanceAndRestoreSeconds(accountCapsule);
        }
        if (type == 1L) {
            return repository.getAccountEnergyUsageBalanceAndRestoreSeconds(accountCapsule);
        }
        return Pair.of((Object)0L, (Object)0L);
    }

    public static long queryAvailableUnfreezeV2Size(byte[] address, Repository repository) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return 0L;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        if (accountCapsule == null) {
            return 0L;
        }
        long now = repository.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        int unfreezingV2Count = accountCapsule.getUnfreezingV2Count(now);
        return Long.max(UnfreezeBalanceV2Actuator.getUNFREEZE_MAX_TIMES() - unfreezingV2Count, 0L);
    }

    public static long queryDelegatableResource(byte[] address, long type, Repository repository) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return 0L;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        if (accountCapsule == null) {
            return 0L;
        }
        if (type == 0L) {
            long frozenV2Resource = accountCapsule.getFrozenV2BalanceForBandwidth();
            Pair<Long, Long> usagePair = repository.getAccountNetUsageBalanceAndRestoreSeconds(accountCapsule);
            if (usagePair == null || usagePair.getLeft() == null) {
                return frozenV2Resource;
            }
            long usage = (Long)usagePair.getLeft();
            if (usage <= 0L) {
                return frozenV2Resource;
            }
            long v2NetUsage = FreezeV2Util.getV2NetUsage(accountCapsule, usage);
            return Math.max(0L, frozenV2Resource - v2NetUsage);
        }
        if (type == 1L) {
            long frozenV2Resource = accountCapsule.getFrozenV2BalanceForEnergy();
            Pair<Long, Long> usagePair = repository.getAccountEnergyUsageBalanceAndRestoreSeconds(accountCapsule);
            if (usagePair == null || usagePair.getLeft() == null) {
                return frozenV2Resource;
            }
            long usage = (Long)usagePair.getLeft();
            if (usage <= 0L) {
                return frozenV2Resource;
            }
            long v2EnergyUsage = FreezeV2Util.getV2EnergyUsage(accountCapsule, usage);
            return Math.max(0L, frozenV2Resource - v2EnergyUsage);
        }
        return 0L;
    }

    public static Triple<Long, Long, Long> checkUndelegateResource(byte[] address, long amount, long type, Repository repository) {
        long resourceLimit;
        Pair<Long, Long> usagePair;
        if (!VMConfig.allowTvmFreezeV2()) {
            return Triple.of((Object)0L, (Object)0L, (Object)0L);
        }
        if (amount <= 0L) {
            return Triple.of((Object)0L, (Object)0L, (Object)0L);
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        if (accountCapsule == null) {
            return Triple.of((Object)0L, (Object)0L, (Object)0L);
        }
        if (type == 0L) {
            usagePair = repository.getAccountNetUsageBalanceAndRestoreSeconds(accountCapsule);
            resourceLimit = accountCapsule.getAllFrozenBalanceForBandwidth();
        } else if (type == 1L) {
            usagePair = repository.getAccountEnergyUsageBalanceAndRestoreSeconds(accountCapsule);
            resourceLimit = accountCapsule.getAllFrozenBalanceForEnergy();
        } else {
            return Triple.of((Object)0L, (Object)0L, (Object)0L);
        }
        if (usagePair == null || usagePair.getLeft() == null || usagePair.getRight() == null) {
            return Triple.of((Object)0L, (Object)0L, (Object)0L);
        }
        amount = Math.min(amount, resourceLimit);
        if (resourceLimit <= (Long)usagePair.getLeft()) {
            return Triple.of((Object)0L, (Object)amount, (Object)usagePair.getRight());
        }
        long clean = (long)((double)amount * ((double)(resourceLimit - (Long)usagePair.getLeft()) / (double)resourceLimit));
        return Triple.of((Object)clean, (Object)(amount - clean), (Object)usagePair.getRight());
    }

    private static long getTotalWithdrawUnfreeze(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long time) {
        return FreezeV2Util.getTotalWithdrawList(unfrozenV2List, time).stream().mapToLong(Protocol.Account.UnFreezeV2::getUnfreezeAmount).sum();
    }

    private static List<Protocol.Account.UnFreezeV2> getTotalWithdrawList(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeExpireTime() <= now).collect(Collectors.toList());
    }

    public static long getV2NetUsage(AccountCapsule ownerCapsule, long netUsage) {
        long v2NetUsage = netUsage - ownerCapsule.getFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
        return Math.max(0L, v2NetUsage);
    }

    public static long getV2EnergyUsage(AccountCapsule ownerCapsule, long energyUsage) {
        long v2EnergyUsage = energyUsage - ownerCapsule.getEnergyFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForEnergy();
        return Math.max(0L, v2EnergyUsage);
    }
}

