/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program.invoke;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.vm.program.invoke.ProgramInvoke;
import org.tron.core.vm.repository.Repository;

public class ProgramInvokeImpl
implements ProgramInvoke {
    private static final Logger logger = LoggerFactory.getLogger(ProgramInvokeImpl.class);
    private static final BigInteger MAX_MSG_DATA = BigInteger.valueOf(Integer.MAX_VALUE);
    private final DataWord address;
    private final DataWord origin;
    private final DataWord caller;
    private final DataWord balance;
    private final DataWord callValue;
    private final DataWord tokenValue;
    private final DataWord tokenId;
    private final DataWord prevHash;
    private final DataWord coinbase;
    private final DataWord timestamp;
    private final DataWord number;
    private byte[] msgData;
    private long vmStartInUs;
    private long vmShouldEndInUs;
    private long energyLimit;
    private Repository deposit;
    private boolean byTransaction = true;
    private boolean byTestingSuite = false;
    private int callDeep = 0;
    private boolean isStaticCall = false;
    private boolean isConstantCall = false;

    public ProgramInvokeImpl(DataWord address, DataWord origin, DataWord caller, DataWord balance, DataWord callValue, DataWord tokenValue, DataWord tokenId, byte[] msgData, DataWord lastHash, DataWord coinbase, DataWord timestamp, DataWord number, DataWord difficulty, Repository deposit, int callDeep, boolean isStaticCall, boolean byTestingSuite, long vmStartInUs, long vmShouldEndInUs, long energyLimit) {
        this.address = address;
        this.origin = origin;
        this.caller = caller;
        this.balance = balance;
        this.callValue = callValue;
        this.tokenValue = tokenValue;
        this.tokenId = tokenId;
        if (Objects.nonNull(msgData)) {
            this.msgData = Arrays.copyOf(msgData, msgData.length);
        }
        this.prevHash = lastHash;
        this.coinbase = coinbase;
        this.timestamp = timestamp;
        this.number = number;
        this.callDeep = callDeep;
        this.deposit = deposit;
        this.byTransaction = false;
        this.isStaticCall = isStaticCall;
        this.byTestingSuite = byTestingSuite;
        this.vmStartInUs = vmStartInUs;
        this.vmShouldEndInUs = vmShouldEndInUs;
        this.energyLimit = energyLimit;
    }

    public ProgramInvokeImpl(byte[] address, byte[] origin, byte[] caller, long balance, long callValue, long tokenValue, long tokenId, byte[] msgData, byte[] lastHash, byte[] coinbase, long timestamp, long number, Repository deposit, long vmStartInUs, long vmShouldEndInUs, boolean byTestingSuite, long energyLimit) {
        this(address, origin, caller, balance, callValue, tokenValue, tokenId, msgData, lastHash, coinbase, timestamp, number, deposit, vmStartInUs, vmShouldEndInUs, energyLimit);
        this.byTestingSuite = byTestingSuite;
    }

    public ProgramInvokeImpl(byte[] address, byte[] origin, byte[] caller, long balance, long callValue, long tokenValue, long tokenId, byte[] msgData, byte[] lastHash, byte[] coinbase, long timestamp, long number, Repository deposit, long vmStartInUs, long vmShouldEndInUs, long energyLimit) {
        this.address = new DataWord(address);
        this.origin = new DataWord(origin);
        this.caller = new DataWord(caller);
        this.balance = new DataWord(balance);
        this.callValue = new DataWord(callValue);
        this.tokenValue = new DataWord(tokenValue);
        this.tokenId = new DataWord(tokenId);
        this.msgData = Arrays.copyOf(msgData, msgData.length);
        this.prevHash = new DataWord(lastHash);
        this.coinbase = new DataWord(coinbase);
        this.timestamp = new DataWord(timestamp);
        this.number = new DataWord(number);
        this.deposit = deposit;
        this.vmStartInUs = vmStartInUs;
        this.vmShouldEndInUs = vmShouldEndInUs;
        this.energyLimit = energyLimit;
    }

    @Override
    public DataWord getContractAddress() {
        return this.address;
    }

    @Override
    public DataWord getBalance() {
        return this.balance;
    }

    @Override
    public DataWord getOriginAddress() {
        return this.origin;
    }

    @Override
    public DataWord getCallerAddress() {
        return this.caller;
    }

    @Override
    public DataWord getCallValue() {
        return this.callValue;
    }

    @Override
    public DataWord getTokenValue() {
        return this.tokenValue;
    }

    @Override
    public DataWord getTokenId() {
        return this.tokenId;
    }

    @Override
    public DataWord getDataValue(DataWord indexData) {
        BigInteger tempIndex = indexData.value();
        int index = tempIndex.intValue();
        int size = 32;
        if (this.msgData == null || index >= this.msgData.length || tempIndex.compareTo(MAX_MSG_DATA) > 0) {
            return new DataWord();
        }
        if (index + size > this.msgData.length) {
            size = this.msgData.length - index;
        }
        byte[] data = new byte[32];
        System.arraycopy(this.msgData, index, data, 0, size);
        return new DataWord(data);
    }

    @Override
    public DataWord getDataSize() {
        if (this.msgData == null || this.msgData.length == 0) {
            return DataWord.ZERO;
        }
        int size = this.msgData.length;
        return new DataWord(size);
    }

    @Override
    public byte[] getDataCopy(DataWord offsetData, DataWord lengthData) {
        int offset = offsetData.intValueSafe();
        int length = lengthData.intValueSafe();
        byte[] data = new byte[length];
        if (this.msgData == null) {
            return data;
        }
        if (offset > this.msgData.length) {
            return data;
        }
        if (offset + length > this.msgData.length) {
            length = this.msgData.length - offset;
        }
        System.arraycopy(this.msgData, offset, data, 0, length);
        return data;
    }

    @Override
    public DataWord getPrevHash() {
        return this.prevHash;
    }

    @Override
    public DataWord getCoinbase() {
        return this.coinbase;
    }

    @Override
    public DataWord getTimestamp() {
        return this.timestamp;
    }

    @Override
    public DataWord getNumber() {
        return this.number;
    }

    @Override
    public DataWord getDifficulty() {
        return DataWord.ZERO();
    }

    @Override
    public long getVmShouldEndInUs() {
        return this.vmShouldEndInUs;
    }

    @Override
    public Repository getDeposit() {
        return this.deposit;
    }

    @Override
    public boolean isStaticCall() {
        return this.isStaticCall;
    }

    @Override
    public boolean isConstantCall() {
        return this.isConstantCall;
    }

    @Override
    public boolean byTestingSuite() {
        return this.byTestingSuite;
    }

    @Override
    public long getVmStartInUs() {
        return this.vmStartInUs;
    }

    @Override
    public int getCallDeep() {
        return this.callDeep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramInvokeImpl that = (ProgramInvokeImpl)o;
        if (this.byTestingSuite != that.byTestingSuite) {
            return false;
        }
        if (this.byTransaction != that.byTransaction) {
            return false;
        }
        if (this.address != null ? !this.address.equals((Object)that.address) : that.address != null) {
            return false;
        }
        if (this.balance != null ? !this.balance.equals((Object)that.balance) : that.balance != null) {
            return false;
        }
        if (this.callValue != null ? !this.callValue.equals((Object)that.callValue) : that.callValue != null) {
            return false;
        }
        if (this.caller != null ? !this.caller.equals((Object)that.caller) : that.caller != null) {
            return false;
        }
        if (this.coinbase != null ? !this.coinbase.equals((Object)that.coinbase) : that.coinbase != null) {
            return false;
        }
        if (!Arrays.equals(this.msgData, that.msgData)) {
            return false;
        }
        if (this.number != null ? !this.number.equals((Object)that.number) : that.number != null) {
            return false;
        }
        if (this.origin != null ? !this.origin.equals((Object)that.origin) : that.origin != null) {
            return false;
        }
        if (this.prevHash != null ? !this.prevHash.equals((Object)that.prevHash) : that.prevHash != null) {
            return false;
        }
        if (this.deposit != null ? !this.deposit.equals(that.deposit) : that.deposit != null) {
            return false;
        }
        return this.timestamp != null ? this.timestamp.equals((Object)that.timestamp) : that.timestamp == null;
    }

    public int hashCode() {
        return new Integer(Boolean.valueOf(this.byTestingSuite).hashCode() + Boolean.valueOf(this.byTransaction).hashCode() + this.address.hashCode() + this.balance.hashCode() + this.callValue.hashCode() + this.caller.hashCode() + this.coinbase.hashCode() + Arrays.hashCode(this.msgData) + this.number.hashCode() + this.origin.hashCode() + this.prevHash.hashCode() + this.deposit.hashCode() + this.timestamp.hashCode()).hashCode();
    }

    public String toString() {
        return "ProgramInvokeImpl{address=" + this.address + ", origin=" + this.origin + ", caller=" + this.caller + ", balance=" + this.balance + ", callValue=" + this.callValue + ", msgData=" + Arrays.toString(this.msgData) + ", prevHash=" + this.prevHash + ", coinbase=" + this.coinbase + ", timestamp=" + this.timestamp + ", number=" + this.number + ", byTransaction=" + this.byTransaction + ", byTestingSuite=" + this.byTestingSuite + ", callDeep=" + this.callDeep + '}';
    }

    @Override
    public long getEnergyLimit() {
        return this.energyLimit;
    }

    @Override
    public void setConstantCall() {
        this.isConstantCall = true;
    }
}

