/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program;

import org.apache.commons.lang3.tuple.Pair;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ContractStateCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.program.Storage;
import org.tron.core.vm.program.invoke.ProgramInvoke;
import org.tron.core.vm.program.listener.ProgramListener;
import org.tron.core.vm.program.listener.ProgramListenerAware;
import org.tron.core.vm.repository.Key;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.repository.Value;
import org.tron.protos.Protocol;

public class ContractState
implements Repository,
ProgramListenerAware {
    private final DataWord address;
    private Repository repository;
    private ProgramListener programListener;

    ContractState(ProgramInvoke programInvoke) {
        this.address = programInvoke.getContractAddress();
        this.repository = programInvoke.getDeposit();
    }

    @Override
    public void setProgramListener(ProgramListener listener) {
        this.programListener = listener;
    }

    @Override
    public AssetIssueCapsule getAssetIssue(byte[] tokenId) {
        return this.repository.getAssetIssue(tokenId);
    }

    @Override
    public AssetIssueV2Store getAssetIssueV2Store() {
        return this.repository.getAssetIssueV2Store();
    }

    @Override
    public AssetIssueStore getAssetIssueStore() {
        return this.repository.getAssetIssueStore();
    }

    @Override
    public DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.repository.getDynamicPropertiesStore();
    }

    @Override
    public AccountCapsule createAccount(byte[] addr, Protocol.AccountType type) {
        return this.repository.createAccount(addr, type);
    }

    @Override
    public AccountCapsule createAccount(byte[] address, String accountName, Protocol.AccountType type) {
        return this.repository.createAccount(address, accountName, type);
    }

    @Override
    public AccountCapsule getAccount(byte[] addr) {
        return this.repository.getAccount(addr);
    }

    @Override
    public BytesCapsule getDynamicProperty(byte[] bytesKey) {
        return this.repository.getDynamicProperty(bytesKey);
    }

    @Override
    public DelegatedResourceCapsule getDelegatedResource(byte[] key) {
        return this.repository.getDelegatedResource(key);
    }

    @Override
    public WitnessCapsule getWitness(byte[] address) {
        return this.repository.getWitness(address);
    }

    @Override
    public void deleteContract(byte[] address) {
        this.repository.deleteContract(address);
    }

    @Override
    public void createContract(byte[] codeHash, ContractCapsule contractCapsule) {
        this.repository.createContract(codeHash, contractCapsule);
    }

    @Override
    public ContractCapsule getContract(byte[] codeHash) {
        return this.repository.getContract(codeHash);
    }

    @Override
    public ContractStateCapsule getContractState(byte[] address) {
        return this.repository.getContractState(address);
    }

    @Override
    public void updateContract(byte[] address, ContractCapsule contractCapsule) {
        this.repository.updateContract(address, contractCapsule);
    }

    @Override
    public void updateContractState(byte[] address, ContractStateCapsule contractStateCapsule) {
        this.repository.updateContractState(address, contractStateCapsule);
    }

    @Override
    public void updateAccount(byte[] address, AccountCapsule accountCapsule) {
        this.repository.updateAccount(address, accountCapsule);
    }

    @Override
    public void saveCode(byte[] address, byte[] code2) {
        this.repository.saveCode(address, code2);
    }

    @Override
    public byte[] getCode(byte[] address) {
        return this.repository.getCode(address);
    }

    @Override
    public void putStorageValue(byte[] addr, DataWord key, DataWord value) {
        if (this.canListenTrace(addr)) {
            this.programListener.onStoragePut(key, value);
        }
        this.repository.putStorageValue(addr, key, value);
    }

    private boolean canListenTrace(byte[] address) {
        return this.programListener != null && this.address.equals((Object)new DataWord(address));
    }

    @Override
    public DataWord getStorageValue(byte[] addr, DataWord key) {
        return this.repository.getStorageValue(addr, key);
    }

    @Override
    public long getBalance(byte[] addr) {
        return this.repository.getBalance(addr);
    }

    @Override
    public long addBalance(byte[] addr, long value) {
        return this.repository.addBalance(addr, value);
    }

    @Override
    public Repository newRepositoryChild() {
        return this.repository.newRepositoryChild();
    }

    @Override
    public void setParent(Repository repository) {
        this.repository.setParent(repository);
    }

    @Override
    public void commit() {
        this.repository.commit();
    }

    @Override
    public void putAccount(Key key, Value value) {
        this.repository.putAccount(key, value);
    }

    @Override
    public void putCode(Key key, Value value) {
        this.repository.putCode(key, value);
    }

    @Override
    public void putContract(Key key, Value value) {
        this.repository.putContract(key, value);
    }

    @Override
    public void putContractState(Key key, Value value) {
        this.repository.putContractState(key, value);
    }

    @Override
    public void putStorage(Key key, Storage cache) {
        this.repository.putStorage(key, cache);
    }

    @Override
    public Storage getStorage(byte[] address) {
        return this.repository.getStorage(address);
    }

    @Override
    public void putAccountValue(byte[] address, AccountCapsule accountCapsule) {
        this.repository.putAccountValue(address, accountCapsule);
    }

    @Override
    public void putDelegatedResource(Key key, Value value) {
        this.repository.putDelegatedResource(key, value);
    }

    @Override
    public void putDelegation(Key key, Value value) {
        this.repository.putDelegation(key, value);
    }

    @Override
    public void putDelegatedResourceAccountIndex(Key key, Value value) {
        this.repository.putDelegatedResourceAccountIndex(key, value);
    }

    @Override
    public long addTokenBalance(byte[] address, byte[] tokenId, long value) {
        return this.repository.addTokenBalance(address, tokenId, value);
    }

    @Override
    public long getTokenBalance(byte[] address, byte[] tokenId) {
        return this.repository.getTokenBalance(address, tokenId);
    }

    @Override
    public long getAccountLeftEnergyFromFreeze(AccountCapsule accountCapsule) {
        return this.repository.getAccountLeftEnergyFromFreeze(accountCapsule);
    }

    @Override
    public long getAccountEnergyUsage(AccountCapsule accountCapsule) {
        return this.repository.getAccountEnergyUsage(accountCapsule);
    }

    @Override
    public Pair<Long, Long> getAccountEnergyUsageBalanceAndRestoreSeconds(AccountCapsule accountCapsule) {
        return this.repository.getAccountEnergyUsageBalanceAndRestoreSeconds(accountCapsule);
    }

    @Override
    public Pair<Long, Long> getAccountNetUsageBalanceAndRestoreSeconds(AccountCapsule accountCapsule) {
        return this.repository.getAccountNetUsageBalanceAndRestoreSeconds(accountCapsule);
    }

    @Override
    public long calculateGlobalEnergyLimit(AccountCapsule accountCapsule) {
        return this.repository.calculateGlobalEnergyLimit(accountCapsule);
    }

    @Override
    public byte[] getBlackHoleAddress() {
        return this.repository.getBlackHoleAddress();
    }

    @Override
    public BlockCapsule getBlockByNum(long num) {
        return this.repository.getBlockByNum(num);
    }

    @Override
    public AccountCapsule createNormalAccount(byte[] address) {
        return this.repository.createNormalAccount(address);
    }

    @Override
    public DelegationStore getDelegationStore() {
        return this.repository.getDelegationStore();
    }

    @Override
    public VotesCapsule getVotes(byte[] address) {
        return this.repository.getVotes(address);
    }

    @Override
    public long getBeginCycle(byte[] address) {
        return this.repository.getBeginCycle(address);
    }

    @Override
    public long getEndCycle(byte[] address) {
        return this.repository.getEndCycle(address);
    }

    @Override
    public AccountCapsule getAccountVote(long cycle, byte[] address) {
        return this.repository.getAccountVote(cycle, address);
    }

    @Override
    public BytesCapsule getDelegation(Key key) {
        return this.repository.getDelegation(key);
    }

    @Override
    public DelegatedResourceAccountIndexCapsule getDelegatedResourceAccountIndex(byte[] key) {
        return this.repository.getDelegatedResourceAccountIndex(key);
    }

    @Override
    public void updateDynamicProperty(byte[] word, BytesCapsule bytesCapsule) {
        this.repository.updateDynamicProperty(word, bytesCapsule);
    }

    @Override
    public void updateDelegatedResource(byte[] word, DelegatedResourceCapsule delegatedResourceCapsule) {
        this.repository.updateDelegatedResource(word, delegatedResourceCapsule);
    }

    @Override
    public void updateVotes(byte[] word, VotesCapsule votesCapsule) {
        this.repository.updateVotes(word, votesCapsule);
    }

    @Override
    public void updateBeginCycle(byte[] word, long cycle) {
        this.repository.updateBeginCycle(word, cycle);
    }

    @Override
    public void updateEndCycle(byte[] word, long cycle) {
        this.repository.updateEndCycle(word, cycle);
    }

    @Override
    public void updateAccountVote(byte[] word, long cycle, AccountCapsule accountCapsule) {
        this.repository.updateAccountVote(word, cycle, accountCapsule);
    }

    @Override
    public void updateDelegation(byte[] word, BytesCapsule bytesCapsule) {
        this.repository.updateDelegation(word, bytesCapsule);
    }

    @Override
    public void updateDelegatedResourceAccountIndex(byte[] word, DelegatedResourceAccountIndexCapsule delegatedResourceAccountIndexCapsule) {
        this.repository.updateDelegatedResourceAccountIndex(word, delegatedResourceAccountIndexCapsule);
    }

    @Override
    public void putDynamicProperty(Key key, Value value) {
        this.repository.putDynamicProperty(key, value);
    }

    @Override
    public void putVotes(Key key, Value value) {
        this.repository.putVotes(key, value);
    }

    @Override
    public void addTotalNetWeight(long amount) {
        this.repository.addTotalNetWeight(amount);
    }

    @Override
    public void addTotalEnergyWeight(long amount) {
        this.repository.addTotalEnergyWeight(amount);
    }

    @Override
    public void addTotalTronPowerWeight(long amount) {
        this.repository.addTotalTronPowerWeight(amount);
    }

    @Override
    public void saveTotalNetWeight(long totalNetWeight) {
        this.repository.saveTotalNetWeight(totalNetWeight);
    }

    @Override
    public void saveTotalEnergyWeight(long totalEnergyWeight) {
        this.repository.saveTotalEnergyWeight(totalEnergyWeight);
    }

    @Override
    public void saveTotalTronPowerWeight(long totalTronPowerWeight) {
        this.repository.saveTotalTronPowerWeight(totalTronPowerWeight);
    }

    @Override
    public long getTotalNetWeight() {
        return this.repository.getTotalNetWeight();
    }

    @Override
    public long getTotalEnergyWeight() {
        return this.repository.getTotalEnergyWeight();
    }

    @Override
    public long getTotalTronPowerWeight() {
        return this.repository.getTotalTronPowerWeight();
    }

    @Override
    public long getHeadSlot() {
        return this.repository.getHeadSlot();
    }

    @Override
    public long getSlotByTimestampMs(long timestamp) {
        return this.repository.getSlotByTimestampMs(timestamp);
    }
}

