/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.math.LongMath;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.vm.nativecontract.param.WithdrawRewardParam;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.utils.VoteRewardUtil;

public class WithdrawRewardProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(WithdrawRewardParam param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        boolean isGP = CommonParameter.getInstance().getGenesisBlock().getWitnesses().stream().anyMatch(witness -> Arrays.equals(ownerAddress, witness.getAddress()));
        if (isGP) {
            throw new ContractValidateException("Account[" + StringUtil.encode58Check((byte[])ownerAddress) + "] is a guard representative and is not allowed to withdraw Balance");
        }
    }

    public long execute(WithdrawRewardParam param, Repository repo) throws ContractExeException {
        byte[] ownerAddress = param.getOwnerAddress();
        VoteRewardUtil.withdrawReward(ownerAddress, repo);
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        long oldBalance = accountCapsule.getBalance();
        long allowance = accountCapsule.getAllowance();
        long newBalance = 0L;
        try {
            newBalance = LongMath.checkedAdd((long)oldBalance, (long)allowance);
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractExeException(e.getMessage());
        }
        if (allowance <= 0L) {
            return 0L;
        }
        accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(newBalance).setAllowance(0L).setLatestWithdrawTime(param.getNowInMs()).build());
        repo.updateAccount(accountCapsule.createDbKey(), accountCapsule);
        return allowance;
    }
}

