/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.math.LongMath;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.nativecontract.param.WithdrawExpireUnfreezeParam;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.Protocol;

public class WithdrawExpireUnfreezeProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(WithdrawExpireUnfreezeParam param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        if (Objects.isNull(accountCapsule)) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        List unfrozenV2List = accountCapsule.getInstance().getUnfrozenV2List();
        long totalWithdrawUnfreeze = this.getTotalWithdrawUnfreeze(unfrozenV2List, now);
        if (totalWithdrawUnfreeze < 0L) {
            throw new ContractValidateException("no unFreeze balance to withdraw ");
        }
        try {
            LongMath.checkedAdd((long)accountCapsule.getBalance(), (long)totalWithdrawUnfreeze);
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
    }

    private long getTotalWithdrawUnfreeze(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return this.getTotalWithdrawList(unfrozenV2List, now).stream().mapToLong(Protocol.Account.UnFreezeV2::getUnfreezeAmount).sum();
    }

    private List<Protocol.Account.UnFreezeV2> getTotalWithdrawList(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeExpireTime() <= now).collect(Collectors.toList());
    }

    public long execute(WithdrawExpireUnfreezeParam param, Repository repo) throws ContractExeException {
        byte[] ownerAddress = param.getOwnerAddress();
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddress);
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        List unfrozenV2List = ownerCapsule.getInstance().getUnfrozenV2List();
        long totalWithdrawUnfreeze = this.getTotalWithdrawUnfreeze(unfrozenV2List, now);
        if (totalWithdrawUnfreeze <= 0L) {
            return 0L;
        }
        ownerCapsule.setInstance(ownerCapsule.getInstance().toBuilder().setBalance(ownerCapsule.getBalance() + totalWithdrawUnfreeze).build());
        List<Protocol.Account.UnFreezeV2> newUnFreezeList = this.getRemainWithdrawList(unfrozenV2List, now);
        ownerCapsule.clearUnfrozenV2();
        ownerCapsule.addAllUnfrozenV2(newUnFreezeList);
        repo.updateAccount(ownerCapsule.createDbKey(), ownerCapsule);
        return totalWithdrawUnfreeze;
    }

    private List<Protocol.Account.UnFreezeV2> getRemainWithdrawList(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeExpireTime() > now).collect(Collectors.toList());
    }
}

