/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.nativecontract.param.UnDelegateResourceParam;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.contract.Common;

public class UnDelegateResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(UnDelegateResourceParam param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        if (!dynamicStore.supportDR()) {
            throw new ContractValidateException("No support for resource delegate");
        }
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddress);
        if (ownerCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        byte[] receiverAddress = param.getReceiverAddress();
        if (!DecodeUtil.addressValid((byte[])receiverAddress)) {
            throw new ContractValidateException("Invalid receiverAddress");
        }
        if (Arrays.equals(receiverAddress, ownerAddress)) {
            throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
        }
        byte[] key = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)false);
        DelegatedResourceCapsule delegatedResourceCapsule = repo.getDelegatedResource(key);
        if (delegatedResourceCapsule == null) {
            throw new ContractValidateException("delegated Resource does not exist");
        }
        long unDelegateBalance = param.getUnDelegateBalance();
        if (unDelegateBalance <= 0L) {
            throw new ContractValidateException("unDelegateBalance must be more than 0 TRX");
        }
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() >= unDelegateBalance) break;
                throw new ContractValidateException("insufficient delegatedFrozenBalance(BANDWIDTH), request=" + unDelegateBalance + ", balance=" + delegatedResourceCapsule.getFrozenBalanceForBandwidth());
            }
            case ENERGY: {
                if (delegatedResourceCapsule.getFrozenBalanceForEnergy() >= unDelegateBalance) break;
                throw new ContractValidateException("insufficient delegateFrozenBalance(ENERGY), request=" + unDelegateBalance + ", balance=" + delegatedResourceCapsule.getFrozenBalanceForEnergy());
            }
            default: {
                throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
    }

    public void execute(UnDelegateResourceParam param, Repository repo) {
        byte[] ownerAddress = param.getOwnerAddress();
        byte[] receiverAddress = param.getReceiverAddress();
        long unDelegateBalance = param.getUnDelegateBalance();
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddress);
        AccountCapsule receiverCapsule = repo.getAccount(receiverAddress);
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        long now = repo.getHeadSlot();
        long transferUsage = 0L;
        if (receiverCapsule != null) {
            switch (param.getResourceType()) {
                case BANDWIDTH: {
                    BandwidthProcessor bandwidthProcessor = new BandwidthProcessor(ChainBaseManager.getInstance());
                    bandwidthProcessor.updateUsageForDelegated(receiverCapsule);
                    if (receiverCapsule.getAcquiredDelegatedFrozenV2BalanceForBandwidth() < unDelegateBalance) {
                        receiverCapsule.setAcquiredDelegatedFrozenV2BalanceForBandwidth(0L);
                    } else {
                        long unDelegateMaxUsage = (long)((double)unDelegateBalance / 1000000.0 * (double)dynamicStore.getTotalNetLimit() / (double)repo.getTotalNetWeight());
                        transferUsage = (long)((double)receiverCapsule.getNetUsage() * ((double)unDelegateBalance / (double)receiverCapsule.getAllFrozenBalanceForBandwidth()));
                        transferUsage = Math.min(unDelegateMaxUsage, transferUsage);
                        receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForBandwidth(-unDelegateBalance);
                    }
                    long newNetUsage = receiverCapsule.getNetUsage() - transferUsage;
                    receiverCapsule.setNetUsage(newNetUsage);
                    receiverCapsule.setLatestConsumeTime(now);
                    break;
                }
                case ENERGY: {
                    EnergyProcessor energyProcessor = new EnergyProcessor(dynamicStore, ChainBaseManager.getInstance().getAccountStore());
                    energyProcessor.updateUsage(receiverCapsule);
                    if (receiverCapsule.getAcquiredDelegatedFrozenV2BalanceForEnergy() < unDelegateBalance) {
                        receiverCapsule.setAcquiredDelegatedFrozenV2BalanceForEnergy(0L);
                    } else {
                        long unDelegateMaxUsage = (long)((double)unDelegateBalance / 1000000.0 * (double)dynamicStore.getTotalEnergyCurrentLimit() / (double)repo.getTotalEnergyWeight());
                        transferUsage = (long)((double)receiverCapsule.getEnergyUsage() * ((double)unDelegateBalance / (double)receiverCapsule.getAllFrozenBalanceForEnergy()));
                        transferUsage = Math.min(unDelegateMaxUsage, transferUsage);
                        receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForEnergy(-unDelegateBalance);
                    }
                    long newEnergyUsage = receiverCapsule.getEnergyUsage() - transferUsage;
                    receiverCapsule.setEnergyUsage(newEnergyUsage);
                    receiverCapsule.setLatestConsumeTimeForEnergy(now);
                    break;
                }
            }
            repo.updateAccount(receiverCapsule.createDbKey(), receiverCapsule);
        }
        byte[] key = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)false);
        DelegatedResourceCapsule delegatedResourceCapsule = repo.getDelegatedResource(key);
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                delegatedResourceCapsule.addFrozenBalanceForBandwidth(-unDelegateBalance, 0L);
                ownerCapsule.addDelegatedFrozenV2BalanceForBandwidth(-unDelegateBalance);
                ownerCapsule.addFrozenBalanceForBandwidthV2(unDelegateBalance);
                BandwidthProcessor processor = new BandwidthProcessor(ChainBaseManager.getInstance());
                if (!Objects.nonNull(receiverCapsule) || transferUsage <= 0L) break;
                processor.unDelegateIncrease(ownerCapsule, receiverCapsule, transferUsage, Common.ResourceCode.BANDWIDTH, now);
                break;
            }
            case ENERGY: {
                delegatedResourceCapsule.addFrozenBalanceForEnergy(-unDelegateBalance, 0L);
                ownerCapsule.addDelegatedFrozenV2BalanceForEnergy(-unDelegateBalance);
                ownerCapsule.addFrozenBalanceForEnergyV2(unDelegateBalance);
                BandwidthProcessor processor = new EnergyProcessor(dynamicStore, ChainBaseManager.getInstance().getAccountStore());
                if (!Objects.nonNull(receiverCapsule) || transferUsage <= 0L) break;
                processor.unDelegateIncrease(ownerCapsule, receiverCapsule, transferUsage, Common.ResourceCode.ENERGY, now);
                break;
            }
        }
        if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() == 0L && delegatedResourceCapsule.getFrozenBalanceForEnergy() == 0L) {
            byte[] fromKey = Bytes.concat((byte[][])new byte[][]{DelegatedResourceAccountIndexStore.getV2_FROM_PREFIX(), ownerAddress, receiverAddress});
            repo.updateDelegatedResourceAccountIndex(fromKey, new DelegatedResourceAccountIndexCapsule(new byte[0]));
            byte[] toKey = Bytes.concat((byte[][])new byte[][]{DelegatedResourceAccountIndexStore.getV2_TO_PREFIX(), receiverAddress, ownerAddress});
            repo.updateDelegatedResourceAccountIndex(toKey, new DelegatedResourceAccountIndexCapsule(new byte[0]));
        }
        repo.updateDelegatedResource(key, delegatedResourceCapsule);
        repo.updateAccount(ownerCapsule.createDbKey(), ownerCapsule);
    }
}

