/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.vm.nativecontract.param.CancelAllUnfreezeV2Param;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.Protocol;
import org.tron.protos.contract.Common;

public class CancelAllUnfreezeV2Processor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(CancelAllUnfreezeV2Param param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        if (Objects.isNull(accountCapsule)) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
    }

    public long execute(CancelAllUnfreezeV2Param param, Repository repo) throws ContractExeException {
        byte[] ownerAddress = param.getOwnerAddress();
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddress);
        long now = repo.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        long withdrawExpireBalance = 0L;
        for (Protocol.Account.UnFreezeV2 unFreezeV2 : ownerCapsule.getUnfrozenV2List()) {
            if (unFreezeV2.getUnfreezeExpireTime() > now) {
                this.updateFrozenInfoAndTotalResourceWeight(ownerCapsule, unFreezeV2, repo);
                continue;
            }
            withdrawExpireBalance += unFreezeV2.getUnfreezeAmount();
        }
        if (withdrawExpireBalance > 0L) {
            ownerCapsule.setBalance(ownerCapsule.getBalance() + withdrawExpireBalance);
        }
        ownerCapsule.clearUnfrozenV2();
        repo.updateAccount(ownerCapsule.createDbKey(), ownerCapsule);
        return withdrawExpireBalance;
    }

    public void updateFrozenInfoAndTotalResourceWeight(AccountCapsule accountCapsule, Protocol.Account.UnFreezeV2 unFreezeV2, Repository repo) {
        switch (unFreezeV2.getType()) {
            case BANDWIDTH: {
                long oldNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                accountCapsule.addFrozenBalanceForBandwidthV2(unFreezeV2.getUnfreezeAmount());
                long newNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                repo.addTotalNetWeight(newNetWeight - oldNetWeight);
                break;
            }
            case ENERGY: {
                long oldEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                accountCapsule.addFrozenBalanceForEnergyV2(unFreezeV2.getUnfreezeAmount());
                long newEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                repo.addTotalEnergyWeight(newEnergyWeight - oldEnergyWeight);
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                accountCapsule.addFrozenForTronPowerV2(unFreezeV2.getUnfreezeAmount());
                long newTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                repo.addTotalTronPowerWeight(newTPWeight - oldTPWeight);
                break;
            }
        }
    }
}

