/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;

public class TransferActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public TransferActuator() {
        super(Protocol.Transaction.Contract.ContractType.TransferContract, BalanceContract.TransferContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            BalanceContract.TransferContract transferContract = (BalanceContract.TransferContract)this.any.unpack(BalanceContract.TransferContract.class);
            long amount = transferContract.getAmount();
            byte[] toAddress = transferContract.getToAddress().toByteArray();
            byte[] ownerAddress = transferContract.getOwnerAddress().toByteArray();
            AccountCapsule toAccount = accountStore.get(toAddress);
            if (toAccount == null) {
                boolean withDefaultPermission = dynamicStore.getAllowMultiSign() == 1L;
                toAccount = new AccountCapsule(ByteString.copyFrom((byte[])toAddress), Protocol.AccountType.Normal, dynamicStore.getLatestBlockHeaderTimestamp(), withDefaultPermission, dynamicStore);
                accountStore.put(toAddress, toAccount);
                fee += dynamicStore.getCreateNewAccountFeeInSystemContract();
            }
            Commons.adjustBalance((AccountStore)accountStore, (byte[])ownerAddress, (long)(-Math.addExact(fee, amount)));
            if (dynamicStore.supportBlackHoleOptimization()) {
                dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)fee);
            }
            Commons.adjustBalance((AccountStore)accountStore, (byte[])toAddress, (long)amount);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ArithmeticException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        BalanceContract.TransferContract transferContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(BalanceContract.TransferContract.class)) {
            throw new ContractValidateException("contract type error, expected type [TransferContract], real type [" + this.any.getClass() + "]");
        }
        long fee = this.calcFee();
        try {
            transferContract = (BalanceContract.TransferContract)this.any.unpack(BalanceContract.TransferContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] toAddress = transferContract.getToAddress().toByteArray();
        byte[] ownerAddress = transferContract.getOwnerAddress().toByteArray();
        long amount = transferContract.getAmount();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress!");
        }
        if (!DecodeUtil.addressValid((byte[])toAddress)) {
            throw new ContractValidateException("Invalid toAddress!");
        }
        if (Arrays.equals(toAddress, ownerAddress)) {
            throw new ContractValidateException("Cannot transfer TRX to yourself.");
        }
        AccountCapsule ownerAccount = accountStore.get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Validate TransferContract error, no OwnerAccount.");
        }
        long balance = ownerAccount.getBalance();
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must be greater than 0.");
        }
        try {
            AccountCapsule toAccount = accountStore.get(toAddress);
            if (toAccount == null) {
                fee += dynamicStore.getCreateNewAccountFeeInSystemContract();
            }
            if (dynamicStore.getForbidTransferToContract() == 1L && toAccount != null && toAccount.getType() == Protocol.AccountType.Contract) {
                throw new ContractValidateException("Cannot transfer TRX to a smartContract.");
            }
            if (dynamicStore.getAllowTvmCompatibleEvm() == 1L && toAccount != null && toAccount.getType() == Protocol.AccountType.Contract) {
                ContractCapsule contractCapsule = this.chainBaseManager.getContractStore().get(toAddress);
                if (contractCapsule == null) {
                    throw new ContractValidateException("Account type is Contract, but it is not exist in contract store.");
                }
                if (contractCapsule.getContractVersion() == 1) {
                    throw new ContractValidateException("Cannot transfer TRX to a smartContract which version is one. Instead please use TriggerSmartContract ");
                }
            }
            if (balance < Math.addExact(amount, fee)) {
                logger.warn("Balance is not sufficient. Account: {}, balance: {}, amount: {}, fee: {}.", new Object[]{StringUtil.encode58Check((byte[])ownerAddress), balance, amount, fee});
                throw new ContractValidateException("Validate TransferContract error, balance is not sufficient.");
            }
            if (toAccount != null) {
                Math.addExact(toAccount.getBalance(), amount);
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.TransferContract)this.any.unpack(BalanceContract.TransferContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

