/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountIdIndexStore;
import org.tron.core.store.AccountStore;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;

public class SetAccountIdActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public SetAccountIdActuator() {
        super(Protocol.Transaction.Contract.ContractType.SetAccountIdContract, AccountContract.SetAccountIdContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        AccountContract.SetAccountIdContract setAccountIdContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AccountIdIndexStore accountIdIndexStore = this.chainBaseManager.getAccountIdIndexStore();
        try {
            setAccountIdContract = (AccountContract.SetAccountIdContract)this.any.unpack(AccountContract.SetAccountIdContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = setAccountIdContract.getOwnerAddress().toByteArray();
        AccountCapsule account = accountStore.get(ownerAddress);
        account.setAccountId(setAccountIdContract.getAccountId().toByteArray());
        accountStore.put(ownerAddress, account);
        accountIdIndexStore.put(account);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AccountContract.SetAccountIdContract setAccountIdContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or account id index store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AccountIdIndexStore accountIdIndexStore = this.chainBaseManager.getAccountIdIndexStore();
        if (!this.any.is(AccountContract.SetAccountIdContract.class)) {
            throw new ContractValidateException("contract type error,expected type [SetAccountIdContract],real type[" + this.any.getClass() + "]");
        }
        try {
            setAccountIdContract = (AccountContract.SetAccountIdContract)this.any.unpack(AccountContract.SetAccountIdContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = setAccountIdContract.getOwnerAddress().toByteArray();
        byte[] accountId = setAccountIdContract.getAccountId().toByteArray();
        if (!TransactionUtil.validAccountId(accountId)) {
            throw new ContractValidateException("Invalid accountId");
        }
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule account = accountStore.get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account has not existed");
        }
        if (account.getAccountId() != null && !account.getAccountId().isEmpty()) {
            throw new ContractValidateException("This account id already set");
        }
        if (accountIdIndexStore.has(accountId)) {
            throw new ContractValidateException("This id has existed");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AccountContract.SetAccountIdContract)this.any.unpack(AccountContract.SetAccountIdContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

