/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.MarketAccountOrderCapsule;
import org.tron.core.capsule.MarketOrderCapsule;
import org.tron.core.capsule.MarketOrderIdListCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.MarketAccountStore;
import org.tron.core.store.MarketOrderStore;
import org.tron.core.store.MarketPairPriceToOrderStore;
import org.tron.core.store.MarketPairToPriceStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.MarketContract;

public class MarketSellAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    private static int MAX_ACTIVE_ORDER_NUM = 100;
    private static int MAX_MATCH_NUM = 20;
    private AccountStore accountStore;
    private DynamicPropertiesStore dynamicStore;
    private AssetIssueStore assetIssueStore;
    private AssetIssueV2Store assetIssueV2Store;
    private MarketAccountStore marketAccountStore;
    private MarketOrderStore orderStore;
    private MarketPairToPriceStore pairToPriceStore;
    private MarketPairPriceToOrderStore pairPriceToOrderStore;
    private byte[] sellTokenID = null;
    private byte[] buyTokenID = null;
    private long sellTokenQuantity;
    private long buyTokenQuantity;

    public MarketSellAssetActuator() {
        super(Protocol.Transaction.Contract.ContractType.MarketSellAssetContract, MarketContract.MarketSellAssetContract.class);
    }

    private void initStores() {
        this.accountStore = this.chainBaseManager.getAccountStore();
        this.dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        this.assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        this.assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        this.marketAccountStore = this.chainBaseManager.getMarketAccountStore();
        this.orderStore = this.chainBaseManager.getMarketOrderStore();
        this.pairToPriceStore = this.chainBaseManager.getMarketPairToPriceStore();
        this.pairPriceToOrderStore = this.chainBaseManager.getMarketPairPriceToOrderStore();
    }

    public boolean execute(Object object) throws ContractExeException {
        this.initStores();
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            MarketContract.MarketSellAssetContract contract = (MarketContract.MarketSellAssetContract)this.any.unpack(MarketContract.MarketSellAssetContract.class);
            AccountCapsule accountCapsule = this.accountStore.get(contract.getOwnerAddress().toByteArray());
            this.sellTokenID = contract.getSellTokenId().toByteArray();
            this.buyTokenID = contract.getBuyTokenId().toByteArray();
            this.sellTokenQuantity = contract.getSellTokenQuantity();
            this.buyTokenQuantity = contract.getBuyTokenQuantity();
            Protocol.MarketPrice takerPrice = Protocol.MarketPrice.newBuilder().setSellTokenQuantity(this.sellTokenQuantity).setBuyTokenQuantity(this.buyTokenQuantity).build();
            accountCapsule.setBalance(accountCapsule.getBalance() - fee);
            if (this.dynamicStore.supportBlackHoleOptimization()) {
                this.dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)this.accountStore, (AccountCapsule)this.accountStore.getBlackhole(), (long)fee);
            }
            this.transferBalanceOrToken(accountCapsule);
            MarketOrderCapsule orderCapsule = this.createAndSaveOrder(accountCapsule, contract);
            this.matchOrder(orderCapsule, takerPrice, ret, accountCapsule);
            if (orderCapsule.getSellTokenQuantityRemain() != 0L) {
                this.saveRemainOrder(orderCapsule);
            }
            this.orderStore.put(orderCapsule.getID().toByteArray(), (ProtoCapsule)orderCapsule);
            this.accountStore.put(accountCapsule.createDbKey(), accountCapsule);
            ret.setOrderId(orderCapsule.getID());
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | BalanceInsufficientException | ContractValidateException | ItemNotFoundException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        MarketContract.MarketSellAssetContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        this.initStores();
        if (!this.any.is(MarketContract.MarketSellAssetContract.class)) {
            throw new ContractValidateException("contract type error,expected type [MarketSellAssetContract],real type[" + this.any.getClass() + "]");
        }
        if (!this.dynamicStore.supportAllowMarketTransaction()) {
            throw new ContractValidateException("Not support Market Transaction, need to be opened by the committee");
        }
        try {
            contract = (MarketContract.MarketSellAssetContract)this.any.unpack(MarketContract.MarketSellAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        this.sellTokenID = contract.getSellTokenId().toByteArray();
        this.buyTokenID = contract.getBuyTokenId().toByteArray();
        this.sellTokenQuantity = contract.getSellTokenQuantity();
        this.buyTokenQuantity = contract.getBuyTokenQuantity();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerAccount = this.accountStore.get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Account does not exist!");
        }
        if (!Arrays.equals(this.sellTokenID, "_".getBytes()) && !TransactionUtil.isNumber((byte[])this.sellTokenID)) {
            throw new ContractValidateException("sellTokenId is not a valid number");
        }
        if (!Arrays.equals(this.buyTokenID, "_".getBytes()) && !TransactionUtil.isNumber((byte[])this.buyTokenID)) {
            throw new ContractValidateException("buyTokenId is not a valid number");
        }
        if (Arrays.equals(this.sellTokenID, this.buyTokenID)) {
            throw new ContractValidateException("cannot exchange same tokens");
        }
        if (this.sellTokenQuantity <= 0L || this.buyTokenQuantity <= 0L) {
            throw new ContractValidateException("token quantity must greater than zero");
        }
        long quantityLimit = this.dynamicStore.getMarketQuantityLimit();
        if (this.sellTokenQuantity > quantityLimit || this.buyTokenQuantity > quantityLimit) {
            throw new ContractValidateException("token quantity must less than " + quantityLimit);
        }
        MarketAccountOrderCapsule marketAccountOrderCapsule = (MarketAccountOrderCapsule)this.marketAccountStore.getUnchecked(ownerAddress);
        if (marketAccountOrderCapsule != null && marketAccountOrderCapsule.getCount() >= (long)MAX_ACTIVE_ORDER_NUM) {
            throw new ContractValidateException("Maximum number of orders exceeded\uff0c" + MAX_ACTIVE_ORDER_NUM);
        }
        try {
            AssetIssueCapsule assetIssueCapsule;
            long fee = this.calcFee();
            if (Arrays.equals(this.sellTokenID, "_".getBytes())) {
                if (ownerAccount.getBalance() < Math.addExact(this.sellTokenQuantity, fee)) {
                    throw new ContractValidateException("No enough balance !");
                }
            } else {
                if (ownerAccount.getBalance() < fee) {
                    throw new ContractValidateException("No enough balance !");
                }
                assetIssueCapsule = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.dynamicStore, (AssetIssueStore)this.assetIssueStore, (AssetIssueV2Store)this.assetIssueV2Store).get(this.sellTokenID);
                if (assetIssueCapsule == null) {
                    throw new ContractValidateException("No sellTokenId !");
                }
                if (!ownerAccount.assetBalanceEnoughV2(this.sellTokenID, this.sellTokenQuantity, this.dynamicStore)) {
                    throw new ContractValidateException("SellToken balance is not enough !");
                }
            }
            if (!Arrays.equals(this.buyTokenID, "_".getBytes()) && (assetIssueCapsule = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.dynamicStore, (AssetIssueStore)this.assetIssueStore, (AssetIssueV2Store)this.assetIssueV2Store).get(this.buyTokenID)) == null) {
                throw new ContractValidateException("No buyTokenId !");
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AssetIssueContractOuterClass.AssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.AssetIssueContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.dynamicStore.getMarketSellFee();
    }

    private Protocol.MarketPrice hasMatch(List<byte[]> priceKeysList, Protocol.MarketPrice takerPrice) {
        if (priceKeysList.isEmpty()) {
            return null;
        }
        Protocol.MarketPrice bestPrice = MarketUtils.decodeKeyToMarketPrice((byte[])priceKeysList.get(0));
        return MarketUtils.priceMatch((Protocol.MarketPrice)takerPrice, (Protocol.MarketPrice)bestPrice) ? bestPrice : null;
    }

    private void matchOrder(MarketOrderCapsule takerCapsule, Protocol.MarketPrice takerPrice, TransactionResultCapsule ret, AccountCapsule takerAccountCapsule) throws ItemNotFoundException, ContractValidateException {
        byte[] makerSellTokenID = this.buyTokenID;
        byte[] makerBuyTokenID = this.sellTokenID;
        byte[] makerPair = MarketUtils.createPairKey((byte[])makerSellTokenID, (byte[])makerBuyTokenID);
        long makerPriceNumber = this.pairToPriceStore.getPriceNum(makerPair);
        if (makerPriceNumber == 0L) {
            return;
        }
        long remainCount = makerPriceNumber;
        List priceKeysList = this.pairPriceToOrderStore.getPriceKeysList(MarketUtils.getPairPriceHeadKey((byte[])makerSellTokenID, (byte[])makerBuyTokenID), (long)(MAX_MATCH_NUM + 1), makerPriceNumber, true);
        int matchOrderCount = 0;
        while (takerCapsule.getSellTokenQuantityRemain() != 0L) {
            Protocol.MarketPrice makerPrice = this.hasMatch(priceKeysList, takerPrice);
            if (makerPrice == null) {
                return;
            }
            byte[] pairPriceKey = (byte[])priceKeysList.get(0);
            MarketOrderIdListCapsule orderIdListCapsule = this.pairPriceToOrderStore.get(pairPriceKey);
            while (takerCapsule.getSellTokenQuantityRemain() != 0L && !orderIdListCapsule.isOrderEmpty()) {
                byte[] orderId = orderIdListCapsule.getHead();
                MarketOrderCapsule makerOrderCapsule = this.orderStore.get(orderId);
                this.matchSingleOrder(takerCapsule, makerOrderCapsule, ret, takerAccountCapsule);
                if (makerOrderCapsule.getSellTokenQuantityRemain() == 0L) {
                    orderIdListCapsule.removeOrder(makerOrderCapsule, this.orderStore, pairPriceKey, this.pairPriceToOrderStore);
                }
                if (++matchOrderCount <= MAX_MATCH_NUM) continue;
                throw new ContractValidateException("Too many matches. MAX_MATCH_NUM = " + MAX_MATCH_NUM);
            }
            if (!orderIdListCapsule.isOrderEmpty()) continue;
            this.pairPriceToOrderStore.delete(pairPriceKey);
            priceKeysList.remove(0);
            if (--remainCount == 0L) {
                this.pairToPriceStore.delete(makerPair);
                break;
            }
            this.pairToPriceStore.setPriceNum(makerPair, remainCount);
        }
    }

    private void matchSingleOrder(MarketOrderCapsule takerOrderCapsule, MarketOrderCapsule makerOrderCapsule, TransactionResultCapsule ret, AccountCapsule takerAccountCapsule) throws ItemNotFoundException {
        long takerBuyTokenQuantityReceive;
        long makerBuyTokenQuantityReceive;
        long takerSellRemainQuantity = takerOrderCapsule.getSellTokenQuantityRemain();
        long makerSellQuantity = makerOrderCapsule.getSellTokenQuantity();
        long makerBuyQuantity = makerOrderCapsule.getBuyTokenQuantity();
        long makerSellRemainQuantity = makerOrderCapsule.getSellTokenQuantityRemain();
        long takerBuyTokenQuantityRemain = MarketUtils.multiplyAndDivide((long)takerSellRemainQuantity, (long)makerSellQuantity, (long)makerBuyQuantity);
        if (takerBuyTokenQuantityRemain == 0L) {
            takerOrderCapsule.setSellTokenQuantityReturn();
            MarketUtils.returnSellTokenRemain((MarketOrderCapsule)takerOrderCapsule, (AccountCapsule)takerAccountCapsule, (DynamicPropertiesStore)this.dynamicStore, (AssetIssueStore)this.assetIssueStore);
            MarketUtils.updateOrderState((MarketOrderCapsule)takerOrderCapsule, (Protocol.MarketOrder.State)Protocol.MarketOrder.State.INACTIVE, (MarketAccountStore)this.marketAccountStore);
            return;
        }
        if (takerBuyTokenQuantityRemain == makerOrderCapsule.getSellTokenQuantityRemain()) {
            makerBuyTokenQuantityReceive = MarketUtils.multiplyAndDivide((long)makerSellRemainQuantity, (long)makerBuyQuantity, (long)makerSellQuantity);
            takerBuyTokenQuantityReceive = makerOrderCapsule.getSellTokenQuantityRemain();
            long takerSellTokenLeft = takerOrderCapsule.getSellTokenQuantityRemain() - makerBuyTokenQuantityReceive;
            takerOrderCapsule.setSellTokenQuantityRemain(takerSellTokenLeft);
            makerOrderCapsule.setSellTokenQuantityRemain(0L);
            if (takerSellTokenLeft == 0L) {
                MarketUtils.updateOrderState((MarketOrderCapsule)takerOrderCapsule, (Protocol.MarketOrder.State)Protocol.MarketOrder.State.INACTIVE, (MarketAccountStore)this.marketAccountStore);
            }
            MarketUtils.updateOrderState((MarketOrderCapsule)makerOrderCapsule, (Protocol.MarketOrder.State)Protocol.MarketOrder.State.INACTIVE, (MarketAccountStore)this.marketAccountStore);
        } else if (takerBuyTokenQuantityRemain < makerOrderCapsule.getSellTokenQuantityRemain()) {
            takerBuyTokenQuantityReceive = takerBuyTokenQuantityRemain;
            makerBuyTokenQuantityReceive = takerOrderCapsule.getSellTokenQuantityRemain();
            takerOrderCapsule.setSellTokenQuantityRemain(0L);
            MarketUtils.updateOrderState((MarketOrderCapsule)takerOrderCapsule, (Protocol.MarketOrder.State)Protocol.MarketOrder.State.INACTIVE, (MarketAccountStore)this.marketAccountStore);
            makerOrderCapsule.setSellTokenQuantityRemain(Math.subtractExact(makerOrderCapsule.getSellTokenQuantityRemain(), takerBuyTokenQuantityRemain));
        } else {
            takerBuyTokenQuantityReceive = makerOrderCapsule.getSellTokenQuantityRemain();
            makerBuyTokenQuantityReceive = MarketUtils.multiplyAndDivide((long)makerSellRemainQuantity, (long)makerBuyQuantity, (long)makerSellQuantity);
            MarketUtils.updateOrderState((MarketOrderCapsule)makerOrderCapsule, (Protocol.MarketOrder.State)Protocol.MarketOrder.State.INACTIVE, (MarketAccountStore)this.marketAccountStore);
            if (makerBuyTokenQuantityReceive == 0L) {
                makerOrderCapsule.setSellTokenQuantityReturn();
                this.returnSellTokenRemain(makerOrderCapsule);
                return;
            }
            makerOrderCapsule.setSellTokenQuantityRemain(0L);
            takerOrderCapsule.setSellTokenQuantityRemain(Math.subtractExact(takerOrderCapsule.getSellTokenQuantityRemain(), makerBuyTokenQuantityReceive));
        }
        this.orderStore.put(makerOrderCapsule.getID().toByteArray(), (ProtoCapsule)makerOrderCapsule);
        this.addTrxOrToken(takerOrderCapsule, takerBuyTokenQuantityReceive, takerAccountCapsule);
        this.addTrxOrToken(makerOrderCapsule, makerBuyTokenQuantityReceive);
        Protocol.MarketOrderDetail orderDetail = Protocol.MarketOrderDetail.newBuilder().setMakerOrderId(makerOrderCapsule.getID()).setTakerOrderId(takerOrderCapsule.getID()).setFillSellQuantity(makerBuyTokenQuantityReceive).setFillBuyQuantity(takerBuyTokenQuantityReceive).build();
        ret.addOrderDetails(orderDetail);
    }

    private MarketOrderCapsule createAndSaveOrder(AccountCapsule accountCapsule, MarketContract.MarketSellAssetContract contract) {
        MarketAccountOrderCapsule marketAccountOrderCapsule = (MarketAccountOrderCapsule)this.marketAccountStore.getUnchecked(contract.getOwnerAddress().toByteArray());
        if (marketAccountOrderCapsule == null) {
            marketAccountOrderCapsule = new MarketAccountOrderCapsule(contract.getOwnerAddress());
        }
        byte[] orderId = MarketUtils.calculateOrderId((ByteString)contract.getOwnerAddress(), (byte[])this.sellTokenID, (byte[])this.buyTokenID, (long)marketAccountOrderCapsule.getTotalCount());
        MarketOrderCapsule orderCapsule = new MarketOrderCapsule(orderId, contract);
        long now = this.dynamicStore.getLatestBlockHeaderTimestamp();
        orderCapsule.setCreateTime(now);
        marketAccountOrderCapsule.addOrders(orderCapsule.getID());
        marketAccountOrderCapsule.setCount(marketAccountOrderCapsule.getCount() + 1L);
        marketAccountOrderCapsule.setTotalCount(marketAccountOrderCapsule.getTotalCount() + 1L);
        this.marketAccountStore.put(accountCapsule.createDbKey(), (ProtoCapsule)marketAccountOrderCapsule);
        this.orderStore.put(orderId, (ProtoCapsule)orderCapsule);
        return orderCapsule;
    }

    private void transferBalanceOrToken(AccountCapsule accountCapsule) {
        if (Arrays.equals(this.sellTokenID, "_".getBytes())) {
            accountCapsule.setBalance(Math.subtractExact(accountCapsule.getBalance(), this.sellTokenQuantity));
        } else {
            accountCapsule.reduceAssetAmountV2(this.sellTokenID, this.sellTokenQuantity, this.dynamicStore, this.assetIssueStore);
        }
    }

    private void addTrxOrToken(MarketOrderCapsule orderCapsule, long num, AccountCapsule accountCapsule) {
        byte[] buyTokenId = orderCapsule.getBuyTokenId();
        if (Arrays.equals(buyTokenId, "_".getBytes())) {
            accountCapsule.setBalance(Math.addExact(accountCapsule.getBalance(), num));
        } else {
            accountCapsule.addAssetAmountV2(buyTokenId, num, this.dynamicStore, this.assetIssueStore);
        }
    }

    private void addTrxOrToken(MarketOrderCapsule orderCapsule, long num) {
        AccountCapsule accountCapsule = this.accountStore.get(orderCapsule.getOwnerAddress().toByteArray());
        byte[] buyTokenId = orderCapsule.getBuyTokenId();
        if (Arrays.equals(buyTokenId, "_".getBytes())) {
            accountCapsule.setBalance(Math.addExact(accountCapsule.getBalance(), num));
        } else {
            accountCapsule.addAssetAmountV2(buyTokenId, num, this.dynamicStore, this.assetIssueStore);
        }
        this.accountStore.put(orderCapsule.getOwnerAddress().toByteArray(), accountCapsule);
    }

    private void returnSellTokenRemain(MarketOrderCapsule orderCapsule) {
        AccountCapsule accountCapsule = this.accountStore.get(orderCapsule.getOwnerAddress().toByteArray());
        MarketUtils.returnSellTokenRemain((MarketOrderCapsule)orderCapsule, (AccountCapsule)accountCapsule, (DynamicPropertiesStore)this.dynamicStore, (AssetIssueStore)this.assetIssueStore);
        this.accountStore.put(orderCapsule.getOwnerAddress().toByteArray(), accountCapsule);
    }

    private void saveRemainOrder(MarketOrderCapsule orderCapsule) throws ItemNotFoundException {
        byte[] pairPriceKey = MarketUtils.createPairPriceKey((byte[])this.sellTokenID, (byte[])this.buyTokenID, (long)this.sellTokenQuantity, (long)this.buyTokenQuantity);
        MarketOrderIdListCapsule orderIdListCapsule = (MarketOrderIdListCapsule)this.pairPriceToOrderStore.getUnchecked(pairPriceKey);
        if (orderIdListCapsule == null) {
            orderIdListCapsule = new MarketOrderIdListCapsule();
            this.pairToPriceStore.addNewPriceKey(this.sellTokenID, this.buyTokenID, this.pairPriceToOrderStore);
        }
        orderIdListCapsule.addOrder(orderCapsule, this.orderStore);
        this.pairPriceToOrderStore.put(pairPriceKey, (ProtoCapsule)orderIdListCapsule);
    }

    public static int getMAX_ACTIVE_ORDER_NUM() {
        return MAX_ACTIVE_ORDER_NUM;
    }

    public static void setMAX_ACTIVE_ORDER_NUM(int MAX_ACTIVE_ORDER_NUM) {
        MarketSellAssetActuator.MAX_ACTIVE_ORDER_NUM = MAX_ACTIVE_ORDER_NUM;
    }

    public static int getMAX_MATCH_NUM() {
        return MAX_MATCH_NUM;
    }
}

