/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.config.Parameter;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ExchangeContract;

public class ExchangeCreateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ExchangeCreateActuator() {
        super(Protocol.Transaction.Contract.ContractType.ExchangeCreateContract, ExchangeContract.ExchangeCreateContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        ExchangeStore exchangeStore = this.chainBaseManager.getExchangeStore();
        ExchangeV2Store exchangeV2Store = this.chainBaseManager.getExchangeV2Store();
        try {
            ExchangeContract.ExchangeCreateContract exchangeCreateContract = (ExchangeContract.ExchangeCreateContract)this.any.unpack(ExchangeContract.ExchangeCreateContract.class);
            AccountCapsule accountCapsule = accountStore.get(exchangeCreateContract.getOwnerAddress().toByteArray());
            byte[] firstTokenID = exchangeCreateContract.getFirstTokenId().toByteArray();
            byte[] secondTokenID = exchangeCreateContract.getSecondTokenId().toByteArray();
            long firstTokenBalance = exchangeCreateContract.getFirstTokenBalance();
            long secondTokenBalance = exchangeCreateContract.getSecondTokenBalance();
            long newBalance = accountCapsule.getBalance() - fee;
            accountCapsule.setBalance(newBalance);
            if (Arrays.equals(firstTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                accountCapsule.setBalance(newBalance - firstTokenBalance);
            } else {
                accountCapsule.reduceAssetAmountV2(firstTokenID, firstTokenBalance, dynamicStore, assetIssueStore);
            }
            if (Arrays.equals(secondTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                accountCapsule.setBalance(newBalance - secondTokenBalance);
            } else {
                accountCapsule.reduceAssetAmountV2(secondTokenID, secondTokenBalance, dynamicStore, assetIssueStore);
            }
            long id = dynamicStore.getLatestExchangeNum() + 1L;
            long now = dynamicStore.getLatestBlockHeaderTimestamp();
            if (dynamicStore.getAllowSameTokenName() == 0L) {
                ExchangeCapsule exchangeCapsule = new ExchangeCapsule(exchangeCreateContract.getOwnerAddress(), id, now, firstTokenID, secondTokenID);
                exchangeCapsule.setBalance(firstTokenBalance, secondTokenBalance);
                exchangeStore.put(exchangeCapsule.createDbKey(), (ProtoCapsule)exchangeCapsule);
                if (!Arrays.equals(firstTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                    String firstTokenRealID = assetIssueStore.get(firstTokenID).getId();
                    firstTokenID = firstTokenRealID.getBytes();
                }
                if (!Arrays.equals(secondTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                    String secondTokenRealID = assetIssueStore.get(secondTokenID).getId();
                    secondTokenID = secondTokenRealID.getBytes();
                }
            }
            ExchangeCapsule exchangeCapsuleV2 = new ExchangeCapsule(exchangeCreateContract.getOwnerAddress(), id, now, firstTokenID, secondTokenID);
            exchangeCapsuleV2.setBalance(firstTokenBalance, secondTokenBalance);
            exchangeV2Store.put(exchangeCapsuleV2.createDbKey(), (ProtoCapsule)exchangeCapsuleV2);
            accountStore.put(accountCapsule.createDbKey(), accountCapsule);
            dynamicStore.saveLatestExchangeNum(id);
            if (dynamicStore.supportBlackHoleOptimization()) {
                dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)fee);
            }
            ret.setExchangeId(id);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        ExchangeContract.ExchangeCreateContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(ExchangeContract.ExchangeCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeCreateContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (ExchangeContract.ExchangeCreateContract)this.any.unpack(ExchangeContract.ExchangeCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!accountStore.has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange create fee!");
        }
        byte[] firstTokenID = contract.getFirstTokenId().toByteArray();
        byte[] secondTokenID = contract.getSecondTokenId().toByteArray();
        long firstTokenBalance = contract.getFirstTokenBalance();
        long secondTokenBalance = contract.getSecondTokenBalance();
        if (dynamicStore.getAllowSameTokenName() == 1L) {
            if (!Arrays.equals(firstTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES) && !TransactionUtil.isNumber((byte[])firstTokenID)) {
                throw new ContractValidateException("first token id is not a valid number");
            }
            if (!Arrays.equals(secondTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES) && !TransactionUtil.isNumber((byte[])secondTokenID)) {
                throw new ContractValidateException("second token id is not a valid number");
            }
        }
        if (Arrays.equals(firstTokenID, secondTokenID)) {
            throw new ContractValidateException("cannot exchange same tokens");
        }
        if (firstTokenBalance <= 0L || secondTokenBalance <= 0L) {
            throw new ContractValidateException("token balance must greater than zero");
        }
        long balanceLimit = dynamicStore.getExchangeBalanceLimit();
        if (firstTokenBalance > balanceLimit || secondTokenBalance > balanceLimit) {
            throw new ContractValidateException("token balance must less than " + balanceLimit);
        }
        if (Arrays.equals(firstTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
            if (accountCapsule.getBalance() < firstTokenBalance + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(firstTokenID, firstTokenBalance, dynamicStore)) {
            throw new ContractValidateException("first token balance is not enough");
        }
        if (Arrays.equals(secondTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
            if (accountCapsule.getBalance() < secondTokenBalance + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(secondTokenID, secondTokenBalance, dynamicStore)) {
            throw new ContractValidateException("second token balance is not enough");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((ExchangeContract.ExchangeCreateContract)this.any.unpack(ExchangeContract.ExchangeCreateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getExchangeCreateFee();
    }
}

