/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AbiCapsule;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AbiStore;
import org.tron.core.store.AccountStore;
import org.tron.core.store.ContractStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class ClearABIContractActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ClearABIContractActuator() {
        super(Protocol.Transaction.Contract.ContractType.ClearABIContract, SmartContractOuterClass.ClearABIContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AbiStore abiStore = this.chainBaseManager.getAbiStore();
        try {
            SmartContractOuterClass.ClearABIContract usContract = (SmartContractOuterClass.ClearABIContract)this.any.unpack(SmartContractOuterClass.ClearABIContract.class);
            byte[] contractAddress = usContract.getContractAddress().toByteArray();
            abiStore.put(contractAddress, (ProtoCapsule)new AbiCapsule(SmartContractOuterClass.SmartContract.ABI.getDefaultInstance()));
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        SmartContractOuterClass.ClearABIContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or contract store!");
        }
        if (this.chainBaseManager.getDynamicPropertiesStore().getAllowTvmConstantinople() == 0L) {
            throw new ContractValidateException("contract type error,unexpected type [ClearABIContract]");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        ContractStore contractStore = this.chainBaseManager.getContractStore();
        if (!this.any.is(SmartContractOuterClass.ClearABIContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ClearABIContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (SmartContractOuterClass.ClearABIContract)this.any.unpack(SmartContractOuterClass.ClearABIContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!DecodeUtil.addressValid((byte[])contract.getOwnerAddress().toByteArray())) {
            throw new ContractValidateException("Invalid address");
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        byte[] contractAddress = contract.getContractAddress().toByteArray();
        ContractCapsule deployedContract = contractStore.get(contractAddress);
        if (deployedContract == null) {
            throw new ContractValidateException("Contract not exists");
        }
        byte[] deployedContractOwnerAddress = deployedContract.getInstance().getOriginAddress().toByteArray();
        if (!Arrays.equals(ownerAddress, deployedContractOwnerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] is not the owner of the contract");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((SmartContractOuterClass.ClearABIContract)this.any.unpack(SmartContractOuterClass.ClearABIContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

