/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.trace;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.IOException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.vm.Op;

public final class Serializers {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");

    public static String serializeFieldsOnly(Object value, boolean pretty) {
        try {
            ObjectMapper mapper = Serializers.createMapper(pretty);
            mapper.setVisibilityChecker(Serializers.fieldsOnlyVisibilityChecker(mapper));
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            logger.error("JSON serialization error: ", (Throwable)e);
            return "{}";
        }
    }

    private static VisibilityChecker<?> fieldsOnlyVisibilityChecker(ObjectMapper mapper) {
        return mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
    }

    public static ObjectMapper createMapper(boolean pretty) {
        ObjectMapper mapper = new ObjectMapper();
        if (pretty) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        return mapper;
    }

    public static class OpCodeSerializer
    extends JsonSerializer<Byte> {
        public void serialize(Byte op, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(Op.getNameOf(op));
        }
    }

    public static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        public void serialize(byte[] memory, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(Hex.toHexString((byte[])memory));
        }
    }

    public static class DataWordSerializer
    extends JsonSerializer<DataWord> {
        public void serialize(DataWord energy, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(energy.value().toString());
        }
    }
}

