/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.repository;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.Hash;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Commons;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StorageUtils;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AbiCapsule;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.CodeCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ContractStateCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.BlockIndexStore;
import org.tron.core.db.BlockStore;
import org.tron.core.db.KhaosDatabase;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.StoreException;
import org.tron.core.store.AbiStore;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.CodeStore;
import org.tron.core.store.ContractStateStore;
import org.tron.core.store.ContractStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.StorageRowStore;
import org.tron.core.store.StoreFactory;
import org.tron.core.store.VotesStore;
import org.tron.core.store.WitnessStore;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.program.Program;
import org.tron.core.vm.program.Storage;
import org.tron.core.vm.repository.Key;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.repository.Value;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.Common;
import org.tron.protos.contract.SmartContractOuterClass;

public class RepositoryImpl
implements Repository {
    private static final Logger logger = LoggerFactory.getLogger((String)"Repository");
    private final long precision = 1000000L;
    private static final byte[] TOTAL_NET_WEIGHT = "TOTAL_NET_WEIGHT".getBytes();
    private static final byte[] TOTAL_ENERGY_WEIGHT = "TOTAL_ENERGY_WEIGHT".getBytes();
    private static final byte[] TOTAL_TRON_POWER_WEIGHT = "TOTAL_TRON_POWER_WEIGHT".getBytes();
    private StoreFactory storeFactory;
    private DynamicPropertiesStore dynamicPropertiesStore;
    private AccountStore accountStore;
    private AssetIssueStore assetIssueStore;
    private AssetIssueV2Store assetIssueV2Store;
    private AbiStore abiStore;
    private CodeStore codeStore;
    private ContractStore contractStore;
    private ContractStateStore contractStateStore;
    private StorageRowStore storageRowStore;
    private BlockStore blockStore;
    private KhaosDatabase khaosDb;
    private BlockIndexStore blockIndexStore;
    private WitnessStore witnessStore;
    private DelegatedResourceStore delegatedResourceStore;
    private VotesStore votesStore;
    private DelegationStore delegationStore;
    private DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore;
    private Repository parent = null;
    private final HashMap<Key, Value<Protocol.Account>> accountCache = new HashMap();
    private final HashMap<Key, Value<byte[]>> codeCache = new HashMap();
    private final HashMap<Key, Value<SmartContractOuterClass.SmartContract>> contractCache = new HashMap();
    private final HashMap<Key, Value<SmartContractOuterClass.ContractState>> contractStateCache = new HashMap();
    private final HashMap<Key, Storage> storageCache = new HashMap();
    private final HashMap<Key, Value<AssetIssueContractOuterClass.AssetIssueContract>> assetIssueCache = new HashMap();
    private final HashMap<Key, Value<byte[]>> dynamicPropertiesCache = new HashMap();
    private final HashMap<Key, Value<Protocol.DelegatedResource>> delegatedResourceCache = new HashMap();
    private final HashMap<Key, Value<Protocol.Votes>> votesCache = new HashMap();
    private final HashMap<Key, Value<byte[]>> delegationCache = new HashMap();
    private final HashMap<Key, Value<Protocol.DelegatedResourceAccountIndex>> delegatedResourceAccountIndexCache = new HashMap();

    public static void removeLruCache(byte[] address) {
    }

    public RepositoryImpl(StoreFactory storeFactory, RepositoryImpl repository) {
        this.init(storeFactory, repository);
    }

    public static RepositoryImpl createRoot(StoreFactory storeFactory) {
        return new RepositoryImpl(storeFactory, null);
    }

    protected void init(StoreFactory storeFactory, RepositoryImpl parent) {
        if (storeFactory != null) {
            this.storeFactory = storeFactory;
            ChainBaseManager manager = storeFactory.getChainBaseManager();
            this.dynamicPropertiesStore = manager.getDynamicPropertiesStore();
            this.accountStore = manager.getAccountStore();
            this.abiStore = manager.getAbiStore();
            this.codeStore = manager.getCodeStore();
            this.contractStore = manager.getContractStore();
            this.contractStateStore = manager.getContractStateStore();
            this.assetIssueStore = manager.getAssetIssueStore();
            this.assetIssueV2Store = manager.getAssetIssueV2Store();
            this.storageRowStore = manager.getStorageRowStore();
            this.blockStore = manager.getBlockStore();
            this.khaosDb = manager.getKhaosDb();
            this.blockIndexStore = manager.getBlockIndexStore();
            this.witnessStore = manager.getWitnessStore();
            this.delegatedResourceStore = manager.getDelegatedResourceStore();
            this.votesStore = manager.getVotesStore();
            this.delegationStore = manager.getDelegationStore();
            this.delegatedResourceAccountIndexStore = manager.getDelegatedResourceAccountIndexStore();
        }
        this.parent = parent;
    }

    @Override
    public Repository newRepositoryChild() {
        return new RepositoryImpl(this.storeFactory, this);
    }

    @Override
    public long getAccountLeftEnergyFromFreeze(AccountCapsule accountCapsule) {
        long now = this.getHeadSlot();
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        long energyLimit = this.calculateGlobalEnergyLimit(accountCapsule);
        long windowSize = accountCapsule.getWindowSize(Common.ResourceCode.ENERGY);
        long newEnergyUsage = this.recover(energyUsage, latestConsumeTime, now, windowSize);
        return Long.max(energyLimit - newEnergyUsage, 0L);
    }

    @Override
    public long getAccountEnergyUsage(AccountCapsule accountCapsule) {
        long now = this.getHeadSlot();
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        long accountWindowSize = accountCapsule.getWindowSize(Common.ResourceCode.ENERGY);
        return this.recover(energyUsage, latestConsumeTime, now, accountWindowSize);
    }

    @Override
    public Pair<Long, Long> getAccountEnergyUsageBalanceAndRestoreSeconds(AccountCapsule accountCapsule) {
        long accountWindowSize;
        long now = this.getHeadSlot();
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        if (now >= latestConsumeTime + (accountWindowSize = accountCapsule.getWindowSize(Common.ResourceCode.ENERGY))) {
            return Pair.of((Object)0L, (Object)0L);
        }
        long restoreSlots = latestConsumeTime + accountWindowSize - now;
        long newEnergyUsage = this.recover(energyUsage, latestConsumeTime, now, accountWindowSize);
        long totalEnergyLimit = this.getDynamicPropertiesStore().getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.getTotalEnergyWeight();
        long balance = (long)((double)newEnergyUsage * (double)totalEnergyWeight / (double)totalEnergyLimit * 1000000.0);
        return Pair.of((Object)balance, (Object)(restoreSlots * 3000L / 1000L));
    }

    @Override
    public Pair<Long, Long> getAccountNetUsageBalanceAndRestoreSeconds(AccountCapsule accountCapsule) {
        long accountWindowSize;
        long now = this.getHeadSlot();
        long netUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        if (now >= latestConsumeTime + (accountWindowSize = accountCapsule.getWindowSize(Common.ResourceCode.BANDWIDTH))) {
            return Pair.of((Object)0L, (Object)0L);
        }
        long restoreSlots = latestConsumeTime + accountWindowSize - now;
        long newNetUsage = this.recover(netUsage, latestConsumeTime, now, accountWindowSize);
        long totalNetLimit = this.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.getTotalNetWeight();
        long balance = (long)((double)newNetUsage * (double)totalNetWeight / (double)totalNetLimit * 1000000.0);
        return Pair.of((Object)balance, (Object)(restoreSlots * 3000L / 1000L));
    }

    @Override
    public AssetIssueCapsule getAssetIssue(byte[] tokenId) {
        byte[] tokenIdWithoutLeadingZero = ByteUtil.stripLeadingZeroes((byte[])tokenId);
        Key key = Key.create(tokenIdWithoutLeadingZero);
        if (this.assetIssueCache.containsKey(key)) {
            return new AssetIssueCapsule(this.assetIssueCache.get(key).getValue());
        }
        AssetIssueCapsule assetIssueCapsule = this.parent != null ? this.parent.getAssetIssue(tokenIdWithoutLeadingZero) : Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.dynamicPropertiesStore, (AssetIssueStore)this.assetIssueStore, (AssetIssueV2Store)this.assetIssueV2Store).get(tokenIdWithoutLeadingZero);
        if (assetIssueCapsule != null) {
            this.assetIssueCache.put(key, Value.create(assetIssueCapsule));
        }
        return assetIssueCapsule;
    }

    @Override
    public AccountCapsule createAccount(byte[] address, Protocol.AccountType type) {
        Key key = new Key(address);
        AccountCapsule account = new AccountCapsule(ByteString.copyFrom((byte[])address), type);
        this.accountCache.put(key, Value.create(account, 2));
        return account;
    }

    @Override
    public AccountCapsule createAccount(byte[] address, String accountName, Protocol.AccountType type) {
        Key key = new Key(address);
        AccountCapsule account = new AccountCapsule(ByteString.copyFrom((byte[])address), ByteString.copyFromUtf8((String)accountName), type);
        this.accountCache.put(key, Value.create(account, 2));
        return account;
    }

    @Override
    public AccountCapsule getAccount(byte[] address) {
        Key key = new Key(address);
        if (this.accountCache.containsKey(key)) {
            return new AccountCapsule(this.accountCache.get(key).getValue());
        }
        AccountCapsule accountCapsule = this.parent != null ? this.parent.getAccount(address) : this.getAccountStore().get(address);
        if (accountCapsule != null) {
            this.accountCache.put(key, Value.create(accountCapsule));
        }
        return accountCapsule;
    }

    @Override
    public BytesCapsule getDynamicProperty(byte[] word) {
        BytesCapsule bytesCapsule;
        Key key = Key.create(word);
        if (this.dynamicPropertiesCache.containsKey(key)) {
            return new BytesCapsule(this.dynamicPropertiesCache.get(key).getValue());
        }
        if (this.parent != null) {
            bytesCapsule = this.parent.getDynamicProperty(word);
        } else {
            try {
                bytesCapsule = (BytesCapsule)this.getDynamicPropertiesStore().get(word);
            }
            catch (BadItemException | ItemNotFoundException e) {
                logger.warn("Not found dynamic property:" + Strings.fromUTF8ByteArray((byte[])word));
                bytesCapsule = null;
            }
        }
        if (bytesCapsule != null) {
            this.dynamicPropertiesCache.put(key, Value.create(bytesCapsule.getData()));
        }
        return bytesCapsule;
    }

    @Override
    public DelegatedResourceCapsule getDelegatedResource(byte[] key) {
        Key cacheKey = new Key(key);
        if (this.delegatedResourceCache.containsKey(cacheKey)) {
            return new DelegatedResourceCapsule(this.delegatedResourceCache.get(cacheKey).getValue());
        }
        DelegatedResourceCapsule delegatedResourceCapsule = this.parent != null ? this.parent.getDelegatedResource(key) : this.getDelegatedResourceStore().get(key);
        if (delegatedResourceCapsule != null) {
            this.delegatedResourceCache.put(cacheKey, Value.create(delegatedResourceCapsule));
        }
        return delegatedResourceCapsule;
    }

    @Override
    public VotesCapsule getVotes(byte[] address) {
        Key cacheKey = new Key(address);
        if (this.votesCache.containsKey(cacheKey)) {
            return new VotesCapsule(this.votesCache.get(cacheKey).getValue());
        }
        VotesCapsule votesCapsule = this.parent != null ? this.parent.getVotes(address) : this.getVotesStore().get(address);
        if (votesCapsule != null) {
            this.votesCache.put(cacheKey, Value.create(votesCapsule));
        }
        return votesCapsule;
    }

    @Override
    public WitnessCapsule getWitness(byte[] address) {
        return this.witnessStore.get(address);
    }

    @Override
    public long getBeginCycle(byte[] address) {
        Key cacheKey = new Key(address);
        BytesCapsule bytesCapsule = this.getDelegation(cacheKey);
        return bytesCapsule == null ? 0L : ByteArray.toLong((byte[])bytesCapsule.getData());
    }

    @Override
    public long getEndCycle(byte[] address) {
        byte[] key = ("end-" + Hex.toHexString((byte[])address)).getBytes();
        Key cacheKey = new Key(key);
        BytesCapsule bytesCapsule = this.getDelegation(cacheKey);
        return bytesCapsule == null ? -1L : ByteArray.toLong((byte[])bytesCapsule.getData());
    }

    @Override
    public AccountCapsule getAccountVote(long cycle, byte[] address) {
        byte[] key = (cycle + "-" + Hex.toHexString((byte[])address) + "-account-vote").getBytes();
        Key cacheKey = new Key(key);
        BytesCapsule bytesCapsule = this.getDelegation(cacheKey);
        if (bytesCapsule == null) {
            return null;
        }
        return new AccountCapsule(bytesCapsule.getData());
    }

    @Override
    public BytesCapsule getDelegation(Key key) {
        if (this.delegationCache.containsKey(key)) {
            return new BytesCapsule(this.delegationCache.get(key).getValue());
        }
        BytesCapsule bytesCapsule = this.parent != null ? this.parent.getDelegation(key) : this.getDelegationStore().get(key.getData());
        if (bytesCapsule != null) {
            this.delegationCache.put(key, Value.create(bytesCapsule.getData()));
        }
        return bytesCapsule;
    }

    @Override
    public DelegatedResourceAccountIndexCapsule getDelegatedResourceAccountIndex(byte[] key) {
        Key cacheKey = new Key(key);
        if (this.delegatedResourceAccountIndexCache.containsKey(cacheKey)) {
            return new DelegatedResourceAccountIndexCapsule(this.delegatedResourceAccountIndexCache.get(cacheKey).getValue());
        }
        DelegatedResourceAccountIndexCapsule delegatedResourceAccountIndexCapsule = this.parent != null ? this.parent.getDelegatedResourceAccountIndex(key) : this.getDelegatedResourceAccountIndexStore().get(key);
        if (delegatedResourceAccountIndexCapsule != null) {
            this.delegatedResourceAccountIndexCache.put(cacheKey, Value.create(delegatedResourceAccountIndexCapsule));
        }
        return delegatedResourceAccountIndexCapsule;
    }

    @Override
    public void deleteContract(byte[] address) {
        this.getCodeStore().delete(address);
        this.getAccountStore().delete(address);
        this.getContractStore().delete(address);
    }

    @Override
    public void createContract(byte[] address, ContractCapsule contractCapsule) {
        this.contractCache.put(Key.create(address), Value.create(contractCapsule, 2));
    }

    @Override
    public ContractCapsule getContract(byte[] address) {
        Key key = Key.create(address);
        if (this.contractCache.containsKey(key)) {
            return new ContractCapsule(this.contractCache.get(key).getValue());
        }
        ContractCapsule contractCapsule = this.parent != null ? this.parent.getContract(address) : this.getContractStore().get(address);
        if (contractCapsule != null) {
            this.contractCache.put(key, Value.create(contractCapsule));
        }
        return contractCapsule;
    }

    @Override
    public ContractStateCapsule getContractState(byte[] address) {
        Key key = Key.create(address);
        if (this.contractStateCache.containsKey(key)) {
            return new ContractStateCapsule(this.contractStateCache.get(key).getValue());
        }
        ContractStateCapsule contractStateCapsule = this.parent != null ? this.parent.getContractState(address) : this.getContractStateStore().get(address);
        if (contractStateCapsule != null) {
            this.contractStateCache.put(key, Value.create(contractStateCapsule));
        }
        return contractStateCapsule;
    }

    @Override
    public void updateContract(byte[] address, ContractCapsule contractCapsule) {
        this.contractCache.put(Key.create(address), Value.create(contractCapsule, 1));
    }

    @Override
    public void updateContractState(byte[] address, ContractStateCapsule contractStateCapsule) {
        this.contractStateCache.put(Key.create(address), Value.create(contractStateCapsule, 1));
    }

    @Override
    public void updateAccount(byte[] address, AccountCapsule accountCapsule) {
        this.accountCache.put(Key.create(address), Value.create(accountCapsule, 1));
    }

    @Override
    public void updateDynamicProperty(byte[] word, BytesCapsule bytesCapsule) {
        this.dynamicPropertiesCache.put(Key.create(word), Value.create(bytesCapsule.getData(), 1));
    }

    @Override
    public void updateDelegatedResource(byte[] word, DelegatedResourceCapsule delegatedResourceCapsule) {
        this.delegatedResourceCache.put(Key.create(word), Value.create(delegatedResourceCapsule, 1));
    }

    @Override
    public void updateVotes(byte[] word, VotesCapsule votesCapsule) {
        this.votesCache.put(Key.create(word), Value.create(votesCapsule, 1));
    }

    @Override
    public void updateBeginCycle(byte[] word, long cycle) {
        this.updateDelegation(word, new BytesCapsule(ByteArray.fromLong((long)cycle)));
    }

    @Override
    public void updateEndCycle(byte[] word, long cycle) {
        BytesCapsule bytesCapsule = new BytesCapsule(ByteArray.fromLong((long)cycle));
        byte[] key = ("end-" + Hex.toHexString((byte[])word)).getBytes();
        this.updateDelegation(key, bytesCapsule);
    }

    @Override
    public void updateAccountVote(byte[] word, long cycle, AccountCapsule accountCapsule) {
        BytesCapsule bytesCapsule = new BytesCapsule(accountCapsule.getData());
        byte[] key = (cycle + "-" + Hex.toHexString((byte[])word) + "-account-vote").getBytes();
        this.updateDelegation(key, bytesCapsule);
    }

    @Override
    public void updateDelegation(byte[] word, BytesCapsule bytesCapsule) {
        this.delegationCache.put(Key.create(word), Value.create(bytesCapsule.getData(), 1));
    }

    @Override
    public void updateDelegatedResourceAccountIndex(byte[] word, DelegatedResourceAccountIndexCapsule delegatedResourceAccountIndexCapsule) {
        this.delegatedResourceAccountIndexCache.put(Key.create(word), Value.create(delegatedResourceAccountIndexCapsule, 1));
    }

    @Override
    public void saveCode(byte[] address, byte[] code2) {
        this.codeCache.put(Key.create(address), Value.create(code2, 2));
        if (VMConfig.allowTvmConstantinople()) {
            ContractCapsule contract = this.getContract(address);
            byte[] codeHash = Hash.sha3((byte[])code2);
            contract.setCodeHash(codeHash);
            this.updateContract(address, contract);
        }
    }

    @Override
    public byte[] getCode(byte[] address) {
        Key key = Key.create(address);
        if (this.codeCache.containsKey(key)) {
            return this.codeCache.get(key).getValue();
        }
        Object code2 = this.parent != null ? this.parent.getCode(address) : (Object)(null == this.getCodeStore().get(address) ? null : this.getCodeStore().get(address).getData());
        if (code2 != null) {
            this.codeCache.put(key, Value.create(code2));
        }
        return code2;
    }

    @Override
    public void putStorageValue(byte[] address, DataWord key, DataWord value) {
        Storage storage = this.getStorageInternal(address);
        if (storage != null) {
            storage.put(key, value);
        }
    }

    @Override
    public DataWord getStorageValue(byte[] address, DataWord key) {
        Storage storage = this.getStorageInternal(address);
        return storage == null ? null : storage.getValue(key);
    }

    private Storage getStorageInternal(byte[] address) {
        Storage storage;
        if (this.getAccount(address = TransactionTrace.convertToTronAddress((byte[])address)) == null) {
            return null;
        }
        Key addressKey = Key.create(address);
        if (this.storageCache.containsKey(addressKey)) {
            storage = this.storageCache.get(addressKey);
        } else {
            storage = this.getStorage(address);
            this.storageCache.put(addressKey, storage);
        }
        return storage;
    }

    @Override
    public Storage getStorage(byte[] address) {
        Storage storage;
        Key key = Key.create(address);
        if (this.storageCache.containsKey(key)) {
            return this.storageCache.get(key);
        }
        if (this.parent != null) {
            Storage parentStorage = this.parent.getStorage(address);
            storage = StorageUtils.getEnergyLimitHardFork() ? new Storage(parentStorage) : parentStorage;
        } else {
            storage = new Storage(address, this.getStorageRowStore());
        }
        ContractCapsule contract = this.getContract(address);
        if (contract != null) {
            storage.setContractVersion(contract.getContractVersion());
            if (!ByteUtil.isNullOrZeroArray((byte[])contract.getTrxHash())) {
                storage.generateAddrHash(contract.getTrxHash());
            }
        }
        return storage;
    }

    @Override
    public long getBalance(byte[] address) {
        AccountCapsule accountCapsule = this.getAccount(address);
        return accountCapsule == null ? 0L : accountCapsule.getBalance();
    }

    @Override
    public long addBalance(byte[] address, long value) {
        AccountCapsule accountCapsule = this.getAccount(address);
        if (accountCapsule == null) {
            accountCapsule = this.createAccount(address, Protocol.AccountType.Normal);
        }
        long balance = accountCapsule.getBalance();
        if (value == 0L) {
            return balance;
        }
        if (value < 0L && balance < -value) {
            throw new RuntimeException(StringUtil.createReadableString((byte[])accountCapsule.createDbKey()) + " insufficient balance");
        }
        accountCapsule.setBalance(Math.addExact(balance, value));
        Key key = Key.create(address);
        this.accountCache.put(key, Value.create(accountCapsule, this.accountCache.get(key).getType().addType(1)));
        return accountCapsule.getBalance();
    }

    @Override
    public void setParent(Repository repository) {
        this.parent = repository;
    }

    @Override
    public void commit() {
        Repository repository = null;
        if (this.parent != null) {
            repository = this.parent;
        }
        this.commitAccountCache(repository);
        this.commitCodeCache(repository);
        this.commitContractCache(repository);
        this.commitContractStateCache(repository);
        this.commitStorageCache(repository);
        this.commitDynamicCache(repository);
        this.commitDelegatedResourceCache(repository);
        this.commitVotesCache(repository);
        this.commitDelegationCache(repository);
        this.commitDelegatedResourceAccountIndexCache(repository);
    }

    @Override
    public void putAccount(Key key, Value value) {
        this.accountCache.put(key, value);
    }

    @Override
    public void putCode(Key key, Value value) {
        this.codeCache.put(key, value);
    }

    @Override
    public void putContract(Key key, Value value) {
        this.contractCache.put(key, value);
    }

    @Override
    public void putContractState(Key key, Value value) {
        this.contractStateCache.put(key, value);
    }

    @Override
    public void putStorage(Key key, Storage cache) {
        this.storageCache.put(key, cache);
    }

    @Override
    public void putAccountValue(byte[] address, AccountCapsule accountCapsule) {
        this.accountCache.put(new Key(address), Value.create(accountCapsule, 2));
    }

    @Override
    public void putDynamicProperty(Key key, Value value) {
        this.dynamicPropertiesCache.put(key, value);
    }

    @Override
    public void putDelegatedResource(Key key, Value value) {
        this.delegatedResourceCache.put(key, value);
    }

    @Override
    public void putVotes(Key key, Value value) {
        this.votesCache.put(key, value);
    }

    @Override
    public void putDelegation(Key key, Value value) {
        this.delegationCache.put(key, value);
    }

    @Override
    public void putDelegatedResourceAccountIndex(Key key, Value value) {
        this.delegatedResourceAccountIndexCache.put(key, value);
    }

    @Override
    public long addTokenBalance(byte[] address, byte[] tokenId, long value) {
        byte[] tokenIdWithoutLeadingZero = ByteUtil.stripLeadingZeroes((byte[])tokenId);
        AccountCapsule accountCapsule = this.getAccount(address);
        if (accountCapsule == null) {
            accountCapsule = this.createAccount(address, Protocol.AccountType.Normal);
        }
        long balance = accountCapsule.getAssetV2(new String(tokenIdWithoutLeadingZero));
        if (value == 0L) {
            return balance;
        }
        if (value < 0L && balance < -value) {
            throw new RuntimeException(StringUtil.createReadableString((byte[])accountCapsule.createDbKey()) + " insufficient balance");
        }
        if (value >= 0L) {
            accountCapsule.addAssetAmountV2(tokenIdWithoutLeadingZero, value, this.getDynamicPropertiesStore(), this.getAssetIssueStore());
        } else {
            accountCapsule.reduceAssetAmountV2(tokenIdWithoutLeadingZero, -value, this.getDynamicPropertiesStore(), this.getAssetIssueStore());
        }
        Key key = Key.create(address);
        this.accountCache.put(key, Value.create(accountCapsule, this.accountCache.get(key).getType().addType(1)));
        return accountCapsule.getAssetV2(new String(tokenIdWithoutLeadingZero));
    }

    @Override
    public long getTokenBalance(byte[] address, byte[] tokenId) {
        AccountCapsule accountCapsule = this.getAccount(address);
        if (accountCapsule == null) {
            return 0L;
        }
        String tokenStr = new String(ByteUtil.stripLeadingZeroes((byte[])tokenId));
        return accountCapsule.getAssetV2(tokenStr);
    }

    @Override
    public byte[] getBlackHoleAddress() {
        return this.getAccountStore().getBlackholeAddress();
    }

    @Override
    public BlockCapsule getBlockByNum(long num) {
        try {
            BlockCapsule.BlockId hash = this.getBlockIdByNum(num);
            BlockCapsule block = this.khaosDb.getBlock((Sha256Hash)hash);
            if (block == null) {
                block = (BlockCapsule)this.blockStore.get(hash.getBytes());
            }
            return block;
        }
        catch (StoreException e) {
            throw new Program.IllegalOperationException("cannot find block num", new Object[0]);
        }
    }

    private long recover(long lastUsage, long lastTime, long now, long personalWindowSize) {
        return this.increase(lastUsage, 0L, lastTime, now, personalWindowSize);
    }

    private long increase(long lastUsage, long usage, long lastTime, long now, long windowSize) {
        long averageLastUsage = this.divideCeil(lastUsage * 1000000L, windowSize);
        long averageUsage = this.divideCeil(usage * 1000000L, windowSize);
        if (lastTime != now) {
            assert (now > lastTime);
            if (lastTime + windowSize > now) {
                long delta = now - lastTime;
                double decay = (double)(windowSize - delta) / (double)windowSize;
                averageLastUsage = Math.round((double)averageLastUsage * decay);
            } else {
                averageLastUsage = 0L;
            }
        }
        return this.getUsage(averageLastUsage += averageUsage, windowSize);
    }

    private long divideCeil(long numerator, long denominator) {
        return numerator / denominator + (long)(numerator % denominator > 0L ? 1 : 0);
    }

    private long getUsage(long usage, long windowSize) {
        return usage * windowSize / 1000000L;
    }

    @Override
    public long calculateGlobalEnergyLimit(AccountCapsule accountCapsule) {
        long frozeBalance = accountCapsule.getAllFrozenBalanceForEnergy();
        if (frozeBalance < 1000000L) {
            return 0L;
        }
        long energyWeight = frozeBalance / 1000000L;
        long totalEnergyLimit = this.getDynamicPropertiesStore().getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.getDynamicPropertiesStore().getTotalEnergyWeight();
        assert (totalEnergyWeight > 0L);
        return (long)((double)energyWeight * ((double)totalEnergyLimit / (double)totalEnergyWeight));
    }

    @Override
    public long getHeadSlot() {
        return this.getSlotByTimestampMs(this.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp());
    }

    @Override
    public long getSlotByTimestampMs(long timestamp) {
        return (timestamp - Long.parseLong(CommonParameter.getInstance().getGenesisBlock().getTimestamp())) / 3000L;
    }

    private void commitAccountCache(Repository deposit) {
        this.accountCache.forEach((key, value) -> {
            if (value.getType().isCreate() || value.getType().isDirty()) {
                if (deposit != null) {
                    deposit.putAccount((Key)key, (Value)value);
                } else {
                    this.getAccountStore().put(key.getData(), new AccountCapsule((Protocol.Account)value.getValue()));
                }
            }
        });
    }

    private void commitCodeCache(Repository deposit) {
        this.codeCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putCode((Key)key, (Value)value);
                } else {
                    this.getCodeStore().put(key.getData(), (ProtoCapsule)new CodeCapsule((byte[])value.getValue()));
                }
            }
        });
    }

    private void commitContractCache(Repository deposit) {
        this.contractCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putContract((Key)key, (Value)value);
                } else {
                    ContractCapsule contractCapsule = new ContractCapsule((SmartContractOuterClass.SmartContract)value.getValue());
                    if (!this.abiStore.has(key.getData())) {
                        this.abiStore.put(key.getData(), (ProtoCapsule)new AbiCapsule(contractCapsule));
                    }
                    this.getContractStore().put(key.getData(), contractCapsule);
                }
            }
        });
    }

    private void commitContractStateCache(Repository deposit) {
        this.contractStateCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putContractState((Key)key, (Value)value);
                } else {
                    ContractStateCapsule contractStateCapsule = new ContractStateCapsule((SmartContractOuterClass.ContractState)value.getValue());
                    this.getContractStateStore().put(key.getData(), contractStateCapsule);
                }
            }
        });
    }

    private void commitStorageCache(Repository deposit) {
        this.storageCache.forEach((address, storage) -> {
            if (deposit != null) {
                deposit.putStorage((Key)address, (Storage)storage);
            } else {
                storage.commit();
            }
        });
    }

    private void commitDynamicCache(Repository deposit) {
        this.dynamicPropertiesCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putDynamicProperty((Key)key, (Value)value);
                } else {
                    this.getDynamicPropertiesStore().put(key.getData(), (ProtoCapsule)new BytesCapsule((byte[])value.getValue()));
                }
            }
        });
    }

    private void commitDelegatedResourceCache(Repository deposit) {
        this.delegatedResourceCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putDelegatedResource((Key)key, (Value)value);
                } else {
                    this.getDelegatedResourceStore().put(key.getData(), (ProtoCapsule)new DelegatedResourceCapsule((Protocol.DelegatedResource)value.getValue()));
                }
            }
        });
    }

    private void commitVotesCache(Repository deposit) {
        this.votesCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putVotes((Key)key, (Value)value);
                } else {
                    this.getVotesStore().put(key.getData(), (ProtoCapsule)new VotesCapsule((Protocol.Votes)value.getValue()));
                }
            }
        });
    }

    private void commitDelegationCache(Repository deposit) {
        this.delegationCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putDelegation((Key)key, (Value)value);
                } else {
                    this.getDelegationStore().put(key.getData(), (ProtoCapsule)new BytesCapsule((byte[])value.getValue()));
                }
            }
        });
    }

    private void commitDelegatedResourceAccountIndexCache(Repository deposit) {
        this.delegatedResourceAccountIndexCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putDelegatedResourceAccountIndex((Key)key, (Value)value);
                } else if (ByteUtil.isNullOrZeroArray((byte[])((Protocol.DelegatedResourceAccountIndex)value.getValue()).toByteArray())) {
                    this.getDelegatedResourceAccountIndexStore().delete(key.getData());
                } else {
                    this.getDelegatedResourceAccountIndexStore().put(key.getData(), (ProtoCapsule)new DelegatedResourceAccountIndexCapsule((Protocol.DelegatedResourceAccountIndex)value.getValue()));
                }
            }
        });
    }

    private BlockCapsule.BlockId getBlockIdByNum(long num) throws ItemNotFoundException {
        return this.blockIndexStore.get(Long.valueOf(num));
    }

    @Override
    public AccountCapsule createNormalAccount(byte[] address) {
        boolean withDefaultPermission = this.getDynamicPropertiesStore().getAllowMultiSign() == 1L;
        Key key = new Key(address);
        AccountCapsule account = new AccountCapsule(ByteString.copyFrom((byte[])address), Protocol.AccountType.Normal, this.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp(), withDefaultPermission, this.getDynamicPropertiesStore());
        this.accountCache.put(key, Value.create(account, 2));
        return account;
    }

    @Override
    public void addTotalNetWeight(long amount) {
        long totalNetWeight = this.getTotalNetWeight();
        this.saveTotalNetWeight(totalNetWeight += amount);
    }

    @Override
    public void addTotalEnergyWeight(long amount) {
        long totalEnergyWeight = this.getTotalEnergyWeight();
        this.saveTotalEnergyWeight(totalEnergyWeight += amount);
    }

    @Override
    public void addTotalTronPowerWeight(long amount) {
        long totalTronPowerWeight = this.getTotalTronPowerWeight();
        this.saveTotalTronPowerWeight(totalTronPowerWeight += amount);
    }

    @Override
    public void saveTotalNetWeight(long totalNetWeight) {
        this.updateDynamicProperty(TOTAL_NET_WEIGHT, new BytesCapsule(ByteArray.fromLong((long)totalNetWeight)));
    }

    @Override
    public void saveTotalEnergyWeight(long totalEnergyWeight) {
        this.updateDynamicProperty(TOTAL_ENERGY_WEIGHT, new BytesCapsule(ByteArray.fromLong((long)totalEnergyWeight)));
    }

    @Override
    public void saveTotalTronPowerWeight(long totalTronPowerWeight) {
        this.updateDynamicProperty(TOTAL_TRON_POWER_WEIGHT, new BytesCapsule(ByteArray.fromLong((long)totalTronPowerWeight)));
    }

    @Override
    public long getTotalNetWeight() {
        return Optional.ofNullable(this.getDynamicProperty(TOTAL_NET_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_WEIGHT"));
    }

    @Override
    public long getTotalEnergyWeight() {
        return Optional.ofNullable(this.getDynamicProperty(TOTAL_ENERGY_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_WEIGHT"));
    }

    @Override
    public long getTotalTronPowerWeight() {
        return Optional.ofNullable(this.getDynamicProperty(TOTAL_TRON_POWER_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_TRON_POWER_WEIGHT"));
    }

    @Override
    public DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.dynamicPropertiesStore;
    }

    public AccountStore getAccountStore() {
        return this.accountStore;
    }

    @Override
    public AssetIssueStore getAssetIssueStore() {
        return this.assetIssueStore;
    }

    @Override
    public AssetIssueV2Store getAssetIssueV2Store() {
        return this.assetIssueV2Store;
    }

    public AbiStore getAbiStore() {
        return this.abiStore;
    }

    public CodeStore getCodeStore() {
        return this.codeStore;
    }

    public ContractStore getContractStore() {
        return this.contractStore;
    }

    public ContractStateStore getContractStateStore() {
        return this.contractStateStore;
    }

    public StorageRowStore getStorageRowStore() {
        return this.storageRowStore;
    }

    public BlockStore getBlockStore() {
        return this.blockStore;
    }

    public KhaosDatabase getKhaosDb() {
        return this.khaosDb;
    }

    public BlockIndexStore getBlockIndexStore() {
        return this.blockIndexStore;
    }

    public WitnessStore getWitnessStore() {
        return this.witnessStore;
    }

    public DelegatedResourceStore getDelegatedResourceStore() {
        return this.delegatedResourceStore;
    }

    public VotesStore getVotesStore() {
        return this.votesStore;
    }

    @Override
    public DelegationStore getDelegationStore() {
        return this.delegationStore;
    }

    public DelegatedResourceAccountIndexStore getDelegatedResourceAccountIndexStore() {
        return this.delegatedResourceAccountIndexStore;
    }
}

