/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.repository;

import org.apache.commons.lang3.tuple.Pair;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ContractStateCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.program.Storage;
import org.tron.core.vm.repository.Key;
import org.tron.core.vm.repository.Value;
import org.tron.protos.Protocol;

public interface Repository {
    public AssetIssueCapsule getAssetIssue(byte[] var1);

    public AssetIssueV2Store getAssetIssueV2Store();

    public AssetIssueStore getAssetIssueStore();

    public DynamicPropertiesStore getDynamicPropertiesStore();

    public DelegationStore getDelegationStore();

    public AccountCapsule createAccount(byte[] var1, Protocol.AccountType var2);

    public AccountCapsule createAccount(byte[] var1, String var2, Protocol.AccountType var3);

    public AccountCapsule getAccount(byte[] var1);

    public BytesCapsule getDynamicProperty(byte[] var1);

    public DelegatedResourceCapsule getDelegatedResource(byte[] var1);

    public VotesCapsule getVotes(byte[] var1);

    public long getBeginCycle(byte[] var1);

    public long getEndCycle(byte[] var1);

    public AccountCapsule getAccountVote(long var1, byte[] var3);

    public BytesCapsule getDelegation(Key var1);

    public DelegatedResourceAccountIndexCapsule getDelegatedResourceAccountIndex(byte[] var1);

    public void deleteContract(byte[] var1);

    public void createContract(byte[] var1, ContractCapsule var2);

    public ContractCapsule getContract(byte[] var1);

    public ContractStateCapsule getContractState(byte[] var1);

    public void updateContract(byte[] var1, ContractCapsule var2);

    public void updateContractState(byte[] var1, ContractStateCapsule var2);

    public void updateAccount(byte[] var1, AccountCapsule var2);

    public void updateDynamicProperty(byte[] var1, BytesCapsule var2);

    public void updateDelegatedResource(byte[] var1, DelegatedResourceCapsule var2);

    public void updateVotes(byte[] var1, VotesCapsule var2);

    public void updateBeginCycle(byte[] var1, long var2);

    public void updateEndCycle(byte[] var1, long var2);

    public void updateAccountVote(byte[] var1, long var2, AccountCapsule var4);

    public void updateDelegation(byte[] var1, BytesCapsule var2);

    public void updateDelegatedResourceAccountIndex(byte[] var1, DelegatedResourceAccountIndexCapsule var2);

    public void saveCode(byte[] var1, byte[] var2);

    public byte[] getCode(byte[] var1);

    public void putStorageValue(byte[] var1, DataWord var2, DataWord var3);

    public DataWord getStorageValue(byte[] var1, DataWord var2);

    public Storage getStorage(byte[] var1);

    public long getBalance(byte[] var1);

    public long addBalance(byte[] var1, long var2);

    public Repository newRepositoryChild();

    public void setParent(Repository var1);

    public void commit();

    public void putAccount(Key var1, Value var2);

    public void putCode(Key var1, Value var2);

    public void putContract(Key var1, Value var2);

    public void putContractState(Key var1, Value var2);

    public void putStorage(Key var1, Storage var2);

    public void putAccountValue(byte[] var1, AccountCapsule var2);

    public void putDynamicProperty(Key var1, Value var2);

    public void putDelegatedResource(Key var1, Value var2);

    public void putVotes(Key var1, Value var2);

    public void putDelegation(Key var1, Value var2);

    public void putDelegatedResourceAccountIndex(Key var1, Value var2);

    public long addTokenBalance(byte[] var1, byte[] var2, long var3);

    public long getTokenBalance(byte[] var1, byte[] var2);

    public long getAccountLeftEnergyFromFreeze(AccountCapsule var1);

    public long getAccountEnergyUsage(AccountCapsule var1);

    public Pair<Long, Long> getAccountEnergyUsageBalanceAndRestoreSeconds(AccountCapsule var1);

    public Pair<Long, Long> getAccountNetUsageBalanceAndRestoreSeconds(AccountCapsule var1);

    public long calculateGlobalEnergyLimit(AccountCapsule var1);

    public byte[] getBlackHoleAddress();

    public BlockCapsule getBlockByNum(long var1);

    public AccountCapsule createNormalAccount(byte[] var1);

    public WitnessCapsule getWitness(byte[] var1);

    public void addTotalNetWeight(long var1);

    public void addTotalEnergyWeight(long var1);

    public void addTotalTronPowerWeight(long var1);

    public void saveTotalNetWeight(long var1);

    public void saveTotalEnergyWeight(long var1);

    public void saveTotalTronPowerWeight(long var1);

    public long getTotalNetWeight();

    public long getTotalEnergyWeight();

    public long getTotalTronPowerWeight();

    public long getHeadSlot();

    public long getSlotByTimestampMs(long var1);
}

