/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program;

import java.util.Objects;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.vm.program.listener.ProgramListener;
import org.tron.core.vm.program.listener.ProgramListenerAware;

public class Stack
extends java.util.Stack<DataWord>
implements ProgramListenerAware {
    private static final long serialVersionUID = 1L;
    private transient ProgramListener programListener;

    @Override
    public void setProgramListener(ProgramListener listener) {
        this.programListener = listener;
    }

    @Override
    public synchronized DataWord pop() {
        if (this.programListener != null) {
            this.programListener.onStackPop();
        }
        return (DataWord)super.pop();
    }

    @Override
    public DataWord push(DataWord item) {
        if (this.programListener != null) {
            this.programListener.onStackPush(item);
        }
        return super.push(item);
    }

    public void swap(int from, int to) {
        if (this.isAccessible(from) && this.isAccessible(to) && from != to) {
            if (this.programListener != null) {
                this.programListener.onStackSwap(from, to);
            }
            DataWord tmp = (DataWord)this.get(from);
            this.set(from, this.set(to, tmp));
        }
    }

    private boolean isAccessible(int from) {
        return from >= 0 && from < this.size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Stack dataWords = (Stack)o;
        return Objects.equals(this.programListener, dataWords.programListener);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.programListener);
    }
}

