/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.UnfreezeBalanceV2Actuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.nativecontract.param.UnfreezeBalanceV2Param;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.utils.VoteRewardUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.Common;

public class UnfreezeBalanceV2Processor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(UnfreezeBalanceV2Param param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        int unfreezingCount = accountCapsule.getUnfreezingV2Count(now);
        if (UnfreezeBalanceV2Actuator.getUNFREEZE_MAX_TIMES() <= unfreezingCount) {
            throw new ContractValidateException("Invalid unfreeze operation, unfreezing times is over limit");
        }
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                if (this.checkExistFrozenBalance(accountCapsule, Common.ResourceCode.BANDWIDTH)) break;
                throw new ContractValidateException("no frozenBalance(BANDWIDTH)");
            }
            case ENERGY: {
                if (this.checkExistFrozenBalance(accountCapsule, Common.ResourceCode.ENERGY)) break;
                throw new ContractValidateException("no frozenBalance(ENERGY)");
            }
            case TRON_POWER: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    if (this.checkExistFrozenBalance(accountCapsule, Common.ResourceCode.TRON_POWER)) break;
                    throw new ContractValidateException("no frozenBalance(TRON_POWER)");
                }
                throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
            default: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY\u3001TRON_POWER]");
                }
                throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
        if (!this.checkUnfreezeBalance(accountCapsule, param.getUnfreezeBalance(), param.getResourceType())) {
            throw new ContractValidateException("Invalid unfreeze_balance, [" + param.getUnfreezeBalance() + "] is error");
        }
    }

    private boolean checkUnfreezeBalance(AccountCapsule accountCapsule, long unfreezeBalance, Common.ResourceCode freezeType) {
        if (unfreezeBalance <= 0L) {
            return false;
        }
        long frozenBalance = 0L;
        List freezeV2List = accountCapsule.getFrozenV2List();
        for (Protocol.Account.FreezeV2 freezeV2 : freezeV2List) {
            if (!freezeV2.getType().equals((Object)freezeType)) continue;
            frozenBalance = freezeV2.getAmount();
            break;
        }
        return unfreezeBalance <= frozenBalance;
    }

    private boolean checkExistFrozenBalance(AccountCapsule accountCapsule, Common.ResourceCode freezeType) {
        List frozenV2List = accountCapsule.getFrozenV2List();
        for (Protocol.Account.FreezeV2 frozenV2 : frozenV2List) {
            if (!frozenV2.getType().equals((Object)freezeType) || frozenV2.getAmount() <= 0L) continue;
            return true;
        }
        return false;
    }

    public long execute(UnfreezeBalanceV2Param param, Repository repo) {
        byte[] ownerAddress = param.getOwnerAddress();
        long unfreezeBalance = param.getUnfreezeBalance();
        VoteRewardUtil.withdrawReward(ownerAddress, repo);
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        long now = repo.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        long unfreezeExpireBalance = this.unfreezeExpire(accountCapsule, now);
        if (repo.getDynamicPropertiesStore().supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        long expireTime = this.calcUnfreezeExpireTime(now, repo);
        accountCapsule.addUnfrozenV2List(param.getResourceType(), unfreezeBalance, expireTime);
        this.updateTotalResourceWeight(accountCapsule, param.getResourceType(), unfreezeBalance, repo);
        this.updateVote(accountCapsule, param.getResourceType(), ownerAddress, repo);
        if (repo.getDynamicPropertiesStore().supportAllowNewResourceModel() && !accountCapsule.oldTronPowerIsInvalid()) {
            accountCapsule.invalidateOldTronPower();
        }
        repo.updateAccount(accountCapsule.createDbKey(), accountCapsule);
        return unfreezeExpireBalance;
    }

    private long unfreezeExpire(AccountCapsule accountCapsule, long now) {
        long unfreezeBalance = 0L;
        ArrayList unFrozenV2List = Lists.newArrayList();
        unFrozenV2List.addAll(accountCapsule.getUnfrozenV2List());
        Iterator iterator = unFrozenV2List.iterator();
        while (iterator.hasNext()) {
            Protocol.Account.UnFreezeV2 next = (Protocol.Account.UnFreezeV2)iterator.next();
            if (next.getUnfreezeExpireTime() > now) continue;
            unfreezeBalance += next.getUnfreezeAmount();
            iterator.remove();
        }
        accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(accountCapsule.getBalance() + unfreezeBalance).clearUnfrozenV2().addAllUnfrozenV2((Iterable)unFrozenV2List).build());
        return unfreezeBalance;
    }

    private long calcUnfreezeExpireTime(long now, Repository repo) {
        long unfreezeDelayDays = repo.getDynamicPropertiesStore().getUnfreezeDelayDays();
        return now + unfreezeDelayDays * 86400000L;
    }

    public void updateTotalResourceWeight(AccountCapsule accountCapsule, Common.ResourceCode freezeType, long unfreezeBalance, Repository repo) {
        switch (freezeType) {
            case BANDWIDTH: {
                long oldNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                accountCapsule.addFrozenBalanceForBandwidthV2(-unfreezeBalance);
                long newNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                repo.addTotalNetWeight(newNetWeight - oldNetWeight);
                break;
            }
            case ENERGY: {
                long oldEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                accountCapsule.addFrozenBalanceForEnergyV2(-unfreezeBalance);
                long newEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                repo.addTotalEnergyWeight(newEnergyWeight - oldEnergyWeight);
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                accountCapsule.addFrozenForTronPowerV2(-unfreezeBalance);
                long newTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                repo.addTotalTronPowerWeight(newTPWeight - oldTPWeight);
                break;
            }
        }
    }

    private void updateVote(AccountCapsule accountCapsule, Common.ResourceCode freezeType, byte[] ownerAddress, Repository repo) {
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        if (!VMConfig.allowTvmVote() || accountCapsule.getVotesList().isEmpty()) {
            return;
        }
        if (dynamicStore.supportAllowNewResourceModel()) {
            if (accountCapsule.oldTronPowerIsInvalid()) {
                switch (freezeType) {
                    case BANDWIDTH: 
                    case ENERGY: {
                        return;
                    }
                }
            } else {
                VotesCapsule votesCapsule = repo.getVotes(ownerAddress);
                if (votesCapsule == null) {
                    votesCapsule = new VotesCapsule(ByteString.copyFrom((byte[])ownerAddress), accountCapsule.getVotesList());
                }
                accountCapsule.clearVotes();
                votesCapsule.clearNewVotes();
                repo.updateVotes(ownerAddress, votesCapsule);
                return;
            }
        }
        long totalVote = 0L;
        for (Protocol.Vote vote : accountCapsule.getVotesList()) {
            totalVote += vote.getVoteCount();
        }
        if (totalVote == 0L) {
            return;
        }
        long ownedTronPower = dynamicStore.supportAllowNewResourceModel() ? accountCapsule.getAllTronPower() : accountCapsule.getTronPower();
        if (ownedTronPower >= totalVote * 1000000L) {
            return;
        }
        VotesCapsule votesCapsule = repo.getVotes(ownerAddress);
        if (votesCapsule == null) {
            votesCapsule = new VotesCapsule(ByteString.copyFrom((byte[])ownerAddress), accountCapsule.getVotesList());
        }
        ArrayList<Protocol.Vote> votesToAdd = new ArrayList<Protocol.Vote>();
        for (Protocol.Vote vote : accountCapsule.getVotesList()) {
            long newVoteCount = (long)((double)vote.getVoteCount() / (double)totalVote * (double)ownedTronPower / 1000000.0);
            if (newVoteCount <= 0L) continue;
            votesToAdd.add(Protocol.Vote.newBuilder().setVoteAddress(vote.getVoteAddress()).setVoteCount(newVoteCount).build());
        }
        votesCapsule.clearNewVotes();
        votesCapsule.addAllNewVotes(votesToAdd);
        repo.updateVotes(ownerAddress, votesCapsule);
        accountCapsule.clearVotes();
        accountCapsule.addAllVotes(votesToAdd);
    }
}

