/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Op {
    private static final Logger logger;
    public static final int STOP = 0;
    public static final int ADD = 1;
    public static final int MUL = 2;
    public static final int SUB = 3;
    public static final int DIV = 4;
    public static final int SDIV = 5;
    public static final int MOD = 6;
    public static final int SMOD = 7;
    public static final int ADDMOD = 8;
    public static final int MULMOD = 9;
    public static final int EXP = 10;
    public static final int SIGNEXTEND = 11;
    public static final int LT = 16;
    public static final int GT = 17;
    public static final int SLT = 18;
    public static final int SGT = 19;
    public static final int EQ = 20;
    public static final int ISZERO = 21;
    public static final int AND = 22;
    public static final int OR = 23;
    public static final int XOR = 24;
    public static final int NOT = 25;
    public static final int BYTE = 26;
    public static final int SHL = 27;
    public static final int SHR = 28;
    public static final int SAR = 29;
    public static final int SHA3 = 32;
    public static final int ADDRESS = 48;
    public static final int BALANCE = 49;
    public static final int ORIGIN = 50;
    public static final int CALLER = 51;
    public static final int CALLVALUE = 52;
    public static final int CALLDATALOAD = 53;
    public static final int CALLDATASIZE = 54;
    public static final int CALLDATACOPY = 55;
    public static final int CODESIZE = 56;
    public static final int CODECOPY = 57;
    public static final int RETURNDATASIZE = 61;
    public static final int RETURNDATACOPY = 62;
    public static final int GASPRICE = 58;
    public static final int EXTCODESIZE = 59;
    public static final int EXTCODECOPY = 60;
    public static final int EXTCODEHASH = 63;
    public static final int BLOCKHASH = 64;
    public static final int COINBASE = 65;
    public static final int TIMESTAMP = 66;
    public static final int NUMBER = 67;
    public static final int DIFFICULTY = 68;
    public static final int GASLIMIT = 69;
    public static final int CHAINID = 70;
    public static final int SELFBALANCE = 71;
    public static final int BASEFEE = 72;
    public static final int POP = 80;
    public static final int MLOAD = 81;
    public static final int MSTORE = 82;
    public static final int MSTORE8 = 83;
    public static final int SLOAD = 84;
    public static final int SSTORE = 85;
    public static final int JUMP = 86;
    public static final int JUMPI = 87;
    public static final int PC = 88;
    public static final int MSIZE = 89;
    public static final int GAS = 90;
    public static final int JUMPDEST = 91;
    public static final int PUSH0 = 95;
    public static final int PUSH1 = 96;
    public static final int PUSH2 = 97;
    public static final int PUSH3 = 98;
    public static final int PUSH4 = 99;
    public static final int PUSH5 = 100;
    public static final int PUSH6 = 101;
    public static final int PUSH7 = 102;
    public static final int PUSH8 = 103;
    public static final int PUSH9 = 104;
    public static final int PUSH10 = 105;
    public static final int PUSH11 = 106;
    public static final int PUSH12 = 107;
    public static final int PUSH13 = 108;
    public static final int PUSH14 = 109;
    public static final int PUSH15 = 110;
    public static final int PUSH16 = 111;
    public static final int PUSH17 = 112;
    public static final int PUSH18 = 113;
    public static final int PUSH19 = 114;
    public static final int PUSH20 = 115;
    public static final int PUSH21 = 116;
    public static final int PUSH22 = 117;
    public static final int PUSH23 = 118;
    public static final int PUSH24 = 119;
    public static final int PUSH25 = 120;
    public static final int PUSH26 = 121;
    public static final int PUSH27 = 122;
    public static final int PUSH28 = 123;
    public static final int PUSH29 = 124;
    public static final int PUSH30 = 125;
    public static final int PUSH31 = 126;
    public static final int PUSH32 = 127;
    public static final int DUP1 = 128;
    public static final int DUP2 = 129;
    public static final int DUP3 = 130;
    public static final int DUP4 = 131;
    public static final int DUP5 = 132;
    public static final int DUP6 = 133;
    public static final int DUP7 = 134;
    public static final int DUP8 = 135;
    public static final int DUP9 = 136;
    public static final int DUP10 = 137;
    public static final int DUP11 = 138;
    public static final int DUP12 = 139;
    public static final int DUP13 = 140;
    public static final int DUP14 = 141;
    public static final int DUP15 = 142;
    public static final int DUP16 = 143;
    public static final int SWAP1 = 144;
    public static final int SWAP2 = 145;
    public static final int SWAP3 = 146;
    public static final int SWAP4 = 147;
    public static final int SWAP5 = 148;
    public static final int SWAP6 = 149;
    public static final int SWAP7 = 150;
    public static final int SWAP8 = 151;
    public static final int SWAP9 = 152;
    public static final int SWAP10 = 153;
    public static final int SWAP11 = 154;
    public static final int SWAP12 = 155;
    public static final int SWAP13 = 156;
    public static final int SWAP14 = 157;
    public static final int SWAP15 = 158;
    public static final int SWAP16 = 159;
    public static final int LOG0 = 160;
    public static final int LOG1 = 161;
    public static final int LOG2 = 162;
    public static final int LOG3 = 163;
    public static final int LOG4 = 164;
    public static final int CALLTOKEN = 208;
    public static final int TOKENBALANCE = 209;
    public static final int CALLTOKENVALUE = 210;
    public static final int CALLTOKENID = 211;
    public static final int ISCONTRACT = 212;
    public static final int FREEZE = 213;
    public static final int UNFREEZE = 214;
    public static final int FREEZEEXPIRETIME = 215;
    public static final int VOTEWITNESS = 216;
    public static final int WITHDRAWREWARD = 217;
    public static final int FREEZEBALANCEV2 = 218;
    public static final int UNFREEZEBALANCEV2 = 219;
    public static final int CANCELALLUNFREEZEV2 = 220;
    public static final int WITHDRAWEXPIREUNFREEZE = 221;
    public static final int DELEGATERESOURCE = 222;
    public static final int UNDELEGATERESOURCE = 223;
    public static final int CREATE = 240;
    public static final int CALL = 241;
    public static final int CALLCODE = 242;
    public static final int DELEGATECALL = 244;
    public static final int STATICCALL = 250;
    public static final int RETURN = 243;
    public static final int CREATE2 = 245;
    public static final int REVERT = 253;
    public static final int SUICIDE = 255;
    private static final String[] OpName;
    private static final Map<String, Byte> stringToByteMap;

    public static String getNameOf(int opCode) {
        return OpName[opCode];
    }

    public static String getNameOf(byte opCode) {
        return OpName[opCode & 0xFF];
    }

    public static byte getOpOf(String opCode) {
        return stringToByteMap.get(opCode);
    }

    static {
        Field[] fields;
        logger = LoggerFactory.getLogger((String)"VM");
        OpName = new String[256];
        stringToByteMap = new HashMap<String, Byte>();
        for (Field field : fields = Op.class.getDeclaredFields()) {
            try {
                if (field.getType() != Integer.TYPE) continue;
                int op = field.getInt(Op.class);
                Op.OpName[op] = field.getName();
                stringToByteMap.put(field.getName(), (byte)op);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

