/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.utils;

import org.tron.common.utils.ForkController;
import org.tron.core.config.Parameter;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.DynamicPropertiesStore;

public class ProposalUtil {
    protected static final long LONG_VALUE = 100000000000000000L;
    protected static final String BAD_PARAM_ID = "Bad chain parameter id";
    private static final String LONG_VALUE_ERROR = "Bad chain parameter value, valid range is [0,100000000000000000]";
    private static final String PRE_VALUE_NOT_ONE_ERROR = "This value[";
    private static final String VALUE_NOT_ONE_ERROR = "] is only allowed to be 1";
    private static final long MAX_SUPPLY = 100000000000L;
    private static final String MAX_SUPPLY_ERROR = "Bad chain parameter value, valid range is [0, 100_000_000_000L]";

    public static void validator(DynamicPropertiesStore dynamicPropertiesStore, ForkController forkController, long code2, long value) throws ContractValidateException {
        ProposalType proposalType = ProposalType.getEnum(code2);
        switch (proposalType) {
            case MAINTENANCE_TIME_INTERVAL: {
                if (value < 81000L || value > 86400000L) {
                    throw new ContractValidateException("Bad chain parameter value, valid range is [3 * 27 * 1000,24 * 3600 * 1000]");
                }
                return;
            }
            case ACCOUNT_UPGRADE_COST: 
            case CREATE_ACCOUNT_FEE: 
            case TRANSACTION_FEE: 
            case ASSET_ISSUE_FEE: 
            case WITNESS_PAY_PER_BLOCK: 
            case WITNESS_STANDBY_ALLOWANCE: 
            case CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT: 
            case CREATE_NEW_ACCOUNT_BANDWIDTH_RATE: {
                if (value >= 0L && value <= 100000000000000000L) break;
                throw new ContractValidateException(LONG_VALUE_ERROR);
            }
            case ALLOW_CREATION_OF_CONTRACTS: {
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_CREATION_OF_CONTRACTS] is only allowed to be 1");
            }
            case REMOVE_THE_POWER_OF_THE_GR: {
                if (dynamicPropertiesStore.getRemoveThePowerOfTheGr() == -1L) {
                    throw new ContractValidateException("This proposal has been executed before and is only allowed to be executed once");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[REMOVE_THE_POWER_OF_THE_GR] is only allowed to be 1");
            }
            case ENERGY_FEE: 
            case EXCHANGE_CREATE_FEE: {
                break;
            }
            case MAX_CPU_TIME_OF_ONE_TX: {
                if (dynamicPropertiesStore.getAllowHigherLimitForMaxCpuTimeOfOneTx() == 1L) {
                    if (value >= 10L && value <= 400L) break;
                    throw new ContractValidateException("Bad chain parameter value, valid range is [10,400]");
                }
                if (value >= 10L && value <= 100L) break;
                throw new ContractValidateException("Bad chain parameter value, valid range is [10,100]");
            }
            case ALLOW_UPDATE_ACCOUNT_NAME: {
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_UPDATE_ACCOUNT_NAME] is only allowed to be 1");
            }
            case ALLOW_SAME_TOKEN_NAME: {
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_SAME_TOKEN_NAME] is only allowed to be 1");
            }
            case ALLOW_DELEGATE_RESOURCE: {
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_DELEGATE_RESOURCE] is only allowed to be 1");
            }
            case TOTAL_ENERGY_LIMIT: {
                if (!forkController.pass(5)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_2_2)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value >= 0L && value <= 100000000000000000L) break;
                throw new ContractValidateException(LONG_VALUE_ERROR);
            }
            case ALLOW_TVM_TRANSFER_TRC10: {
                if (value != 1L) {
                    throw new ContractValidateException("This value[ALLOW_TVM_TRANSFER_TRC10] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getAllowSameTokenName() != 0L) break;
                throw new ContractValidateException("[ALLOW_SAME_TOKEN_NAME] proposal must be approved before [ALLOW_TVM_TRANSFER_TRC10] can be proposed");
            }
            case TOTAL_CURRENT_ENERGY_LIMIT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_2_2)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value >= 0L && value <= 100000000000000000L) break;
                throw new ContractValidateException(LONG_VALUE_ERROR);
            }
            case ALLOW_MULTI_SIGN: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_5)) {
                    throw new ContractValidateException("Bad chain parameter id: ALLOW_MULTI_SIGN");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_MULTI_SIGN] is only allowed to be 1");
            }
            case ALLOW_ADAPTIVE_ENERGY: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_5)) {
                    throw new ContractValidateException("Bad chain parameter id: ALLOW_ADAPTIVE_ENERGY");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_ADAPTIVE_ENERGY] is only allowed to be 1");
            }
            case UPDATE_ACCOUNT_PERMISSION_FEE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_5)) {
                    throw new ContractValidateException("Bad chain parameter id: UPDATE_ACCOUNT_PERMISSION_FEE");
                }
                if (value >= 0L && value <= 100000000000L) break;
                throw new ContractValidateException(MAX_SUPPLY_ERROR);
            }
            case MULTI_SIGN_FEE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_5)) {
                    throw new ContractValidateException("Bad chain parameter id: MULTI_SIGN_FEE");
                }
                if (value >= 0L && value <= 100000000000L) break;
                throw new ContractValidateException(MAX_SUPPLY_ERROR);
            }
            case ALLOW_PROTO_FILTER_NUM: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value == 1L || value == 0L) break;
                throw new ContractValidateException("This value[ALLOW_PROTO_FILTER_NUM] is only allowed to be 1 or 0");
            }
            case ALLOW_ACCOUNT_STATE_ROOT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value == 1L || value == 0L) break;
                throw new ContractValidateException("This value[ALLOW_ACCOUNT_STATE_ROOT] is only allowed to be 1 or 0");
            }
            case ALLOW_TVM_CONSTANTINOPLE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value != 1L) {
                    throw new ContractValidateException("This value[ALLOW_TVM_CONSTANTINOPLE] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getAllowTvmTransferTrc10() != 0L) break;
                throw new ContractValidateException("[ALLOW_TVM_TRANSFER_TRC10] proposal must be approved before [ALLOW_TVM_CONSTANTINOPLE] can be proposed");
            }
            case ALLOW_TVM_SOLIDITY_059: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value != 1L) {
                    throw new ContractValidateException("This value[ALLOW_TVM_SOLIDITY_059] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getAllowCreationOfContracts() != 0L) break;
                throw new ContractValidateException("[ALLOW_CREATION_OF_CONTRACTS] proposal must be approved before [ALLOW_TVM_SOLIDITY_059] can be proposed");
            }
            case ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value >= 1L && value <= 1000L) break;
                throw new ContractValidateException("Bad chain parameter value, valid range is [1,1_000]");
            }
            case ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value >= 1L && value <= 10000L) break;
                throw new ContractValidateException("Bad chain parameter value, valid range is [1,10_000]");
            }
            case ALLOW_CHANGE_DELEGATION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value == 1L || value == 0L) break;
                throw new ContractValidateException("This value[ALLOW_CHANGE_DELEGATION] is only allowed to be 1 or 0");
            }
            case WITNESS_127_PAY_PER_BLOCK: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value >= 0L && value <= 100000000000000000L) break;
                throw new ContractValidateException(LONG_VALUE_ERROR);
            }
            case FORBID_TRANSFER_TO_CONTRACT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_6)) {
                    throw new ContractValidateException(BAD_PARAM_ID);
                }
                if (value != 1L) {
                    throw new ContractValidateException("This value[FORBID_TRANSFER_TO_CONTRACT] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getAllowCreationOfContracts() != 0L) break;
                throw new ContractValidateException("[ALLOW_CREATION_OF_CONTRACTS] proposal must be approved before [FORBID_TRANSFER_TO_CONTRACT] can be proposed");
            }
            case ALLOW_PBFT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_PBFT]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_PBFT] is only allowed to be 1");
            }
            case ALLOW_TVM_ISTANBUL: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TVM_ISTANBUL]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_TVM_ISTANBUL] is only allowed to be 1");
            }
            case ALLOW_SHIELDED_TRC20_TRANSACTION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_0_1)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_SHIELDED_TRC20_TRANSACTION]");
                }
                if (value == 1L || value == 0L) break;
                throw new ContractValidateException("This value[ALLOW_SHIELDED_TRC20_TRANSACTION] is only allowed to be 1 or 0");
            }
            case ALLOW_MARKET_TRANSACTION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_MARKET_TRANSACTION]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_MARKET_TRANSACTION] is only allowed to be 1");
            }
            case MARKET_SELL_FEE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1)) {
                    throw new ContractValidateException("Bad chain parameter id [MARKET_SELL_FEE]");
                }
                if (!dynamicPropertiesStore.supportAllowMarketTransaction()) {
                    throw new ContractValidateException("Market Transaction is not activated, can not set Market Sell Fee");
                }
                if (value >= 0L && value <= 10000000000L) break;
                throw new ContractValidateException("Bad MARKET_SELL_FEE parameter value, valid range is [0,10_000_000_000L]");
            }
            case MARKET_CANCEL_FEE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1)) {
                    throw new ContractValidateException("Bad chain parameter id [MARKET_CANCEL_FEE]");
                }
                if (!dynamicPropertiesStore.supportAllowMarketTransaction()) {
                    throw new ContractValidateException("Market Transaction is not activated, can not set Market Cancel Fee");
                }
                if (value >= 0L && value <= 10000000000L) break;
                throw new ContractValidateException("Bad MARKET_CANCEL_FEE parameter value, valid range is [0,10_000_000_000L]");
            }
            case MAX_FEE_LIMIT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1_2)) {
                    throw new ContractValidateException("Bad chain parameter id [MAX_FEE_LIMIT]");
                }
                if (value < 0L) {
                    throw new ContractValidateException("Bad MAX_FEE_LIMIT parameter value, value must not be negative");
                }
                if (value <= 10000000000L) break;
                if (dynamicPropertiesStore.getAllowTvmLondon() == 0L) {
                    throw new ContractValidateException("Bad MAX_FEE_LIMIT parameter value, valid range is [0,10_000_000_000L]");
                }
                if (value <= 100000000000000000L) break;
                throw new ContractValidateException(LONG_VALUE_ERROR);
            }
            case ALLOW_TRANSACTION_FEE_POOL: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1_2)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TRANSACTION_FEE_POOL]");
                }
                if (value == 1L || value == 0L) break;
                throw new ContractValidateException("This value[ALLOW_TRANSACTION_FEE_POOL] is only allowed to be 1 or 0");
            }
            case ALLOW_BLACKHOLE_OPTIMIZATION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_1_2)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_REMOVE_BLACKHOLE]");
                }
                if (value == 1L || value == 0L) break;
                throw new ContractValidateException("This value[ALLOW_REMOVE_BLACKHOLE] is only allowed to be 1 or 0");
            }
            case ALLOW_NEW_RESOURCE_MODEL: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_2)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_NEW_RESOURCE_MODEL]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_NEW_RESOURCE_MODEL] is only allowed to be 1");
            }
            case ALLOW_TVM_FREEZE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_2)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TVM_FREEZE]");
                }
                if (value != 1L) {
                    throw new ContractValidateException("This value[ALLOW_TVM_FREEZE] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getAllowDelegateResource() == 0L) {
                    throw new ContractValidateException("[ALLOW_DELEGATE_RESOURCE] proposal must be approved before [ALLOW_TVM_FREEZE] can be proposed");
                }
                if (dynamicPropertiesStore.getAllowMultiSign() == 0L) {
                    throw new ContractValidateException("[ALLOW_MULTI_SIGN] proposal must be approved before [ALLOW_TVM_FREEZE] can be proposed");
                }
                if (dynamicPropertiesStore.getAllowTvmConstantinople() == 0L) {
                    throw new ContractValidateException("[ALLOW_TVM_CONSTANTINOPLE] proposal must be approved before [ALLOW_TVM_FREEZE] can be proposed");
                }
                if (dynamicPropertiesStore.getAllowTvmSolidity059() != 0L) break;
                throw new ContractValidateException("[ALLOW_TVM_SOLIDITY_059] proposal must be approved before [ALLOW_TVM_FREEZE] can be proposed");
            }
            case ALLOW_TVM_VOTE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_3)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TVM_VOTE]");
                }
                if (value != 1L) {
                    throw new ContractValidateException("This value[ALLOW_TVM_VOTE] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getChangeDelegation() != 0L) break;
                throw new ContractValidateException("[ALLOW_CHANGE_DELEGATION] proposal must be approved before [ALLOW_TVM_VOTE] can be proposed");
            }
            case FREE_NET_LIMIT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_3)) {
                    throw new ContractValidateException("Bad chain parameter id [FREE_NET_LIMIT]");
                }
                if (value >= 0L && value <= 100000L) break;
                throw new ContractValidateException("Bad chain parameter value, valid range is [0,100_000]");
            }
            case TOTAL_NET_LIMIT: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_3)) {
                    throw new ContractValidateException("Bad chain parameter id [TOTAL_NET_LIMIT]");
                }
                if (value >= 0L && value <= 1000000000000L) break;
                throw new ContractValidateException("Bad chain parameter value, valid range is [0, 1_000_000_000_000L]");
            }
            case ALLOW_ACCOUNT_ASSET_OPTIMIZATION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_3)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_ACCOUNT_ASSET_OPTIMIZATION]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_ACCOUNT_ASSET_OPTIMIZATION] is only allowed to be 1");
            }
            case ALLOW_TVM_LONDON: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_4)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TVM_LONDON]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_TVM_LONDON] is only allowed to be 1");
            }
            case ALLOW_TVM_COMPATIBLE_EVM: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_4)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TVM_COMPATIBLE_EVM]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_TVM_COMPATIBLE_EVM] is only allowed to be 1");
            }
            case ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_5)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX] is only allowed to be 1");
            }
            case ALLOW_ASSET_OPTIMIZATION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_5)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_ASSET_OPTIMIZATION]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_ASSET_OPTIMIZATION] is only allowed to be 1");
            }
            case ALLOW_NEW_REWARD: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_6)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_NEW_REWARD]");
                }
                if (dynamicPropertiesStore.allowNewReward()) {
                    throw new ContractValidateException("New reward has been valid.");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_NEW_REWARD] is only allowed to be 1");
            }
            case MEMO_FEE: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_6)) {
                    throw new ContractValidateException("Bad chain parameter id [MEMO_FEE]");
                }
                if (value >= 0L && value <= 1000000000L) break;
                throw new ContractValidateException("This value[MEMO_FEE] is only allowed to be in the range 0-1000_000_000");
            }
            case ALLOW_DELEGATE_OPTIMIZATION: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_6)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_DELEGATE_OPTIMIZATION]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_DELEGATE_OPTIMIZATION] is only allowed to be 1");
            }
            case UNFREEZE_DELAY_DAYS: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7)) {
                    throw new ContractValidateException("Bad chain parameter id [UNFREEZE_DELAY_DAYS]");
                }
                if (value >= 1L && value <= 365L) break;
                throw new ContractValidateException("This value[UNFREEZE_DELAY_DAYS] is only allowed to be in the range 1-365");
            }
            case ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID] is only allowed to be 1");
            }
            case ALLOW_DYNAMIC_ENERGY: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_DYNAMIC_ENERGY]");
                }
                if (value < 0L || value > 1L) {
                    throw new ContractValidateException("This value[ALLOW_DYNAMIC_ENERGY] is only allowed to be in the range 0-1");
                }
                if (value != 1L || dynamicPropertiesStore.getChangeDelegation() != 0L) break;
                throw new ContractValidateException("[ALLOW_CHANGE_DELEGATION] proposal must be approved before [ALLOW_DYNAMIC_ENERGY] can be opened");
            }
            case DYNAMIC_ENERGY_THRESHOLD: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7)) {
                    throw new ContractValidateException("Bad chain parameter id [DYNAMIC_ENERGY_THRESHOLD]");
                }
                if (value >= 0L && value <= 100000000000000000L) break;
                throw new ContractValidateException(LONG_VALUE_ERROR);
            }
            case DYNAMIC_ENERGY_INCREASE_FACTOR: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7)) {
                    throw new ContractValidateException("Bad chain parameter id [DYNAMIC_ENERGY_INCREASE_FACTOR]");
                }
                if (value >= 0L && value <= 10000L) break;
                throw new ContractValidateException("This value[DYNAMIC_ENERGY_INCREASE_FACTOR] is only allowed to be in the range 0-10000");
            }
            case DYNAMIC_ENERGY_MAX_FACTOR: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7)) {
                    throw new ContractValidateException("Bad chain parameter id [DYNAMIC_ENERGY_MAX_FACTOR]");
                }
                if (value >= 0L && value <= 100000L) break;
                throw new ContractValidateException("This value[DYNAMIC_ENERGY_MAX_FACTOR] is only allowed to be in the range 0-100000");
            }
            case ALLOW_TVM_SHANGHAI: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7_2)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_TVM_SHANGHAI]");
                }
                if (value == 1L) break;
                throw new ContractValidateException("This value[ALLOW_TVM_SHANGHAI] is only allowed to be 1");
            }
            case ALLOW_CANCEL_ALL_UNFREEZE_V2: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7_2)) {
                    throw new ContractValidateException("Bad chain parameter id [ALLOW_CANCEL_ALL_UNFREEZE_V2]");
                }
                if (value != 1L) {
                    throw new ContractValidateException("This value[ALLOW_CANCEL_ALL_UNFREEZE_V2] is only allowed to be 1");
                }
                if (dynamicPropertiesStore.getUnfreezeDelayDays() != 0L) break;
                throw new ContractValidateException("[UNFREEZE_DELAY_DAYS] proposal must be approved before [ALLOW_CANCEL_ALL_UNFREEZE_V2] can be proposed");
            }
            case MAX_DELEGATE_LOCK_PERIOD: {
                if (!forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_4_7_2)) {
                    throw new ContractValidateException("Bad chain parameter id [MAX_DELEGATE_LOCK_PERIOD]");
                }
                long maxDelegateLockPeriod = dynamicPropertiesStore.getMaxDelegateLockPeriod();
                if (value <= maxDelegateLockPeriod || value > 10512000L) {
                    throw new ContractValidateException("This value[MAX_DELEGATE_LOCK_PERIOD] is only allowed to be greater than " + maxDelegateLockPeriod + " and less than or equal to 10512000 !");
                }
                if (dynamicPropertiesStore.getUnfreezeDelayDays() != 0L) break;
                throw new ContractValidateException("[UNFREEZE_DELAY_DAYS] proposal must be approved before [MAX_DELEGATE_LOCK_PERIOD] can be proposed");
            }
        }
    }

    public static enum ProposalType {
        MAINTENANCE_TIME_INTERVAL(0L),
        ACCOUNT_UPGRADE_COST(1L),
        CREATE_ACCOUNT_FEE(2L),
        TRANSACTION_FEE(3L),
        ASSET_ISSUE_FEE(4L),
        WITNESS_PAY_PER_BLOCK(5L),
        WITNESS_STANDBY_ALLOWANCE(6L),
        CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT(7L),
        CREATE_NEW_ACCOUNT_BANDWIDTH_RATE(8L),
        ALLOW_CREATION_OF_CONTRACTS(9L),
        REMOVE_THE_POWER_OF_THE_GR(10L),
        ENERGY_FEE(11L),
        EXCHANGE_CREATE_FEE(12L),
        MAX_CPU_TIME_OF_ONE_TX(13L),
        ALLOW_UPDATE_ACCOUNT_NAME(14L),
        ALLOW_SAME_TOKEN_NAME(15L),
        ALLOW_DELEGATE_RESOURCE(16L),
        TOTAL_ENERGY_LIMIT(17L),
        ALLOW_TVM_TRANSFER_TRC10(18L),
        TOTAL_CURRENT_ENERGY_LIMIT(19L),
        ALLOW_MULTI_SIGN(20L),
        ALLOW_ADAPTIVE_ENERGY(21L),
        UPDATE_ACCOUNT_PERMISSION_FEE(22L),
        MULTI_SIGN_FEE(23L),
        ALLOW_PROTO_FILTER_NUM(24L),
        ALLOW_ACCOUNT_STATE_ROOT(25L),
        ALLOW_TVM_CONSTANTINOPLE(26L),
        ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER(29L),
        ALLOW_CHANGE_DELEGATION(30L),
        WITNESS_127_PAY_PER_BLOCK(31L),
        ALLOW_TVM_SOLIDITY_059(32L),
        ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO(33L),
        FORBID_TRANSFER_TO_CONTRACT(35L),
        ALLOW_SHIELDED_TRC20_TRANSACTION(39L),
        ALLOW_PBFT(40L),
        ALLOW_TVM_ISTANBUL(41L),
        ALLOW_MARKET_TRANSACTION(44L),
        MARKET_SELL_FEE(45L),
        MARKET_CANCEL_FEE(46L),
        MAX_FEE_LIMIT(47L),
        ALLOW_TRANSACTION_FEE_POOL(48L),
        ALLOW_BLACKHOLE_OPTIMIZATION(49L),
        ALLOW_NEW_RESOURCE_MODEL(51L),
        ALLOW_TVM_FREEZE(52L),
        ALLOW_ACCOUNT_ASSET_OPTIMIZATION(53L),
        ALLOW_TVM_VOTE(59L),
        ALLOW_TVM_COMPATIBLE_EVM(60L),
        FREE_NET_LIMIT(61L),
        TOTAL_NET_LIMIT(62L),
        ALLOW_TVM_LONDON(63L),
        ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX(65L),
        ALLOW_ASSET_OPTIMIZATION(66L),
        ALLOW_NEW_REWARD(67L),
        MEMO_FEE(68L),
        ALLOW_DELEGATE_OPTIMIZATION(69L),
        UNFREEZE_DELAY_DAYS(70L),
        ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID(71L),
        ALLOW_DYNAMIC_ENERGY(72L),
        DYNAMIC_ENERGY_THRESHOLD(73L),
        DYNAMIC_ENERGY_INCREASE_FACTOR(74L),
        DYNAMIC_ENERGY_MAX_FACTOR(75L),
        ALLOW_TVM_SHANGHAI(76L),
        ALLOW_CANCEL_ALL_UNFREEZE_V2(77L),
        MAX_DELEGATE_LOCK_PERIOD(78L);

        private long code;

        private ProposalType(long code2) {
            this.code = code2;
        }

        public static boolean contain(long code2) {
            for (ProposalType parameters : ProposalType.values()) {
                if (parameters.code != code2) continue;
                return true;
            }
            return false;
        }

        public static ProposalType getEnum(long code2) throws ContractValidateException {
            for (ProposalType parameters : ProposalType.values()) {
                if (parameters.code != code2) continue;
                return parameters;
            }
            throw new ContractValidateException("Does not support code : " + code2);
        }

        public static ProposalType getEnumOrNull(long code2) {
            for (ProposalType parameters : ProposalType.values()) {
                if (parameters.code != code2) continue;
                return parameters;
            }
            return null;
        }

        public long getCode() {
            return this.code;
        }
    }
}

