/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class UpdateAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public UpdateAssetActuator() {
        super(Protocol.Transaction.Contract.ContractType.UpdateAssetContract, AssetIssueContractOuterClass.UpdateAssetContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AssetIssueV2Store assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        try {
            AssetIssueContractOuterClass.UpdateAssetContract updateAssetContract = (AssetIssueContractOuterClass.UpdateAssetContract)this.any.unpack(AssetIssueContractOuterClass.UpdateAssetContract.class);
            long newLimit = updateAssetContract.getNewLimit();
            long newPublicLimit = updateAssetContract.getNewPublicLimit();
            byte[] ownerAddress = updateAssetContract.getOwnerAddress().toByteArray();
            ByteString newUrl = updateAssetContract.getUrl();
            ByteString newDescription = updateAssetContract.getDescription();
            AccountCapsule accountCapsule = accountStore.get(ownerAddress);
            AssetIssueV2Store assetIssueStoreV2 = assetIssueV2Store;
            AssetIssueCapsule assetIssueCapsuleV2 = assetIssueStoreV2.get(accountCapsule.getAssetIssuedID().toByteArray());
            assetIssueCapsuleV2.setFreeAssetNetLimit(newLimit);
            assetIssueCapsuleV2.setPublicFreeAssetNetLimit(newPublicLimit);
            assetIssueCapsuleV2.setUrl(newUrl);
            assetIssueCapsuleV2.setDescription(newDescription);
            if (dynamicStore.getAllowSameTokenName() == 0L) {
                AssetIssueCapsule assetIssueCapsule = assetIssueStore.get(accountCapsule.getAssetIssuedName().toByteArray());
                assetIssueCapsule.setFreeAssetNetLimit(newLimit);
                assetIssueCapsule.setPublicFreeAssetNetLimit(newPublicLimit);
                assetIssueCapsule.setUrl(newUrl);
                assetIssueCapsule.setDescription(newDescription);
                assetIssueStore.put(assetIssueCapsule.createDbKey(), (ProtoCapsule)assetIssueCapsule);
                assetIssueStoreV2.put(assetIssueCapsuleV2.createDbV2Key(), (ProtoCapsule)assetIssueCapsuleV2);
            } else {
                assetIssueV2Store.put(assetIssueCapsuleV2.createDbV2Key(), (ProtoCapsule)assetIssueCapsuleV2);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AssetIssueContractOuterClass.UpdateAssetContract updateAssetContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AssetIssueV2Store assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        if (!this.any.is(AssetIssueContractOuterClass.UpdateAssetContract.class)) {
            throw new ContractValidateException("contract type error, expected type [UpdateAssetContract],real type[" + this.any.getClass() + "]");
        }
        try {
            updateAssetContract = (AssetIssueContractOuterClass.UpdateAssetContract)this.any.unpack(AssetIssueContractOuterClass.UpdateAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        long newLimit = updateAssetContract.getNewLimit();
        long newPublicLimit = updateAssetContract.getNewPublicLimit();
        byte[] ownerAddress = updateAssetContract.getOwnerAddress().toByteArray();
        ByteString newUrl = updateAssetContract.getUrl();
        ByteString newDescription = updateAssetContract.getDescription();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule account = accountStore.get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account does not exist");
        }
        if (dynamicStore.getAllowSameTokenName() == 0L) {
            if (account.getAssetIssuedName().isEmpty()) {
                throw new ContractValidateException("Account has not issued any asset");
            }
            if (assetIssueStore.get(account.getAssetIssuedName().toByteArray()) == null) {
                throw new ContractValidateException("Asset is not existed in AssetIssueStore");
            }
        } else {
            if (account.getAssetIssuedID().isEmpty()) {
                throw new ContractValidateException("Account has not issued any asset");
            }
            if (assetIssueV2Store.get(account.getAssetIssuedID().toByteArray()) == null) {
                throw new ContractValidateException("Asset is not existed in AssetIssueV2Store");
            }
        }
        if (!TransactionUtil.validUrl(newUrl.toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        if (!TransactionUtil.validAssetDescription(newDescription.toByteArray())) {
            throw new ContractValidateException("Invalid description");
        }
        if (newLimit < 0L || newLimit >= dynamicStore.getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid FreeAssetNetLimit");
        }
        if (newPublicLimit < 0L || newPublicLimit >= dynamicStore.getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid PublicFreeAssetNetLimit");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AccountContract.AccountUpdateContract)this.any.unpack(AccountContract.AccountUpdateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

