/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ProposalStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ProposalContract;

public class ProposalDeleteActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ProposalDeleteActuator() {
        super(Protocol.Transaction.Contract.ContractType.ProposalDeleteContract, ProposalContract.ProposalDeleteContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        ProposalStore proposalStore = this.chainBaseManager.getProposalStore();
        try {
            ProposalContract.ProposalDeleteContract proposalDeleteContract = (ProposalContract.ProposalDeleteContract)this.any.unpack(ProposalContract.ProposalDeleteContract.class);
            ProposalCapsule proposalCapsule = proposalStore.get(ByteArray.fromLong((long)proposalDeleteContract.getProposalId()));
            proposalCapsule.setState(Protocol.Proposal.State.CANCELED);
            proposalStore.put(proposalCapsule.createDbKey(), (ProtoCapsule)proposalCapsule);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ItemNotFoundException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        ProposalCapsule proposalCapsule;
        ProposalContract.ProposalDeleteContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        ProposalStore proposalStore = this.chainBaseManager.getProposalStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(ProposalContract.ProposalDeleteContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ProposalDeleteContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (ProposalContract.ProposalDeleteContract)this.any.unpack(ProposalContract.ProposalDeleteContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!accountStore.has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long latestProposalNum = dynamicStore.getLatestProposalNum();
        if (contract.getProposalId() > latestProposalNum) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        try {
            proposalCapsule = proposalStore.get(ByteArray.fromLong((long)contract.getProposalId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        if (!proposalCapsule.getProposalAddress().equals((Object)contract.getOwnerAddress())) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] is not proposed by " + readableOwnerAddress);
        }
        if (now >= proposalCapsule.getExpirationTime()) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] expired");
        }
        if (proposalCapsule.getState() == Protocol.Proposal.State.CANCELED) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] canceled");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((ProposalContract.ProposalDeleteContract)this.any.unpack(ProposalContract.ProposalDeleteContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

