/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class FreezeBalanceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public FreezeBalanceActuator() {
        super(Protocol.Transaction.Contract.ContractType.FreezeBalanceContract, BalanceContract.FreezeBalanceContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.FreezeBalanceContract freezeBalanceContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            freezeBalanceContract = (BalanceContract.FreezeBalanceContract)this.any.unpack(BalanceContract.FreezeBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = accountStore.get(freezeBalanceContract.getOwnerAddress().toByteArray());
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        long duration = freezeBalanceContract.getFrozenDuration() * 86400000L;
        long newBalance = accountCapsule.getBalance() - freezeBalanceContract.getFrozenBalance();
        long frozenBalance = freezeBalanceContract.getFrozenBalance();
        long expireTime = now + duration;
        byte[] ownerAddress = freezeBalanceContract.getOwnerAddress().toByteArray();
        byte[] receiverAddress = freezeBalanceContract.getReceiverAddress().toByteArray();
        switch (freezeBalanceContract.getResource()) {
            case BANDWIDTH: {
                long increment;
                if (!ArrayUtils.isEmpty((byte[])receiverAddress) && dynamicStore.supportDR()) {
                    increment = this.delegateResource(ownerAddress, receiverAddress, true, frozenBalance, expireTime);
                    accountCapsule.addDelegatedFrozenBalanceForBandwidth(frozenBalance);
                } else {
                    long oldNetWeight = accountCapsule.getFrozenBalance() / 1000000L;
                    long newFrozenBalanceForBandwidth = frozenBalance + accountCapsule.getFrozenBalance();
                    accountCapsule.setFrozenForBandwidth(newFrozenBalanceForBandwidth, expireTime);
                    long newNetWeight = accountCapsule.getFrozenBalance() / 1000000L;
                    increment = newNetWeight - oldNetWeight;
                }
                this.addTotalWeight(Common.ResourceCode.BANDWIDTH, dynamicStore, frozenBalance, increment);
                break;
            }
            case ENERGY: {
                long increment;
                if (!ArrayUtils.isEmpty((byte[])receiverAddress) && dynamicStore.supportDR()) {
                    increment = this.delegateResource(ownerAddress, receiverAddress, false, frozenBalance, expireTime);
                    accountCapsule.addDelegatedFrozenBalanceForEnergy(frozenBalance);
                } else {
                    long oldEnergyWeight = accountCapsule.getEnergyFrozenBalance() / 1000000L;
                    long newFrozenBalanceForEnergy = frozenBalance + accountCapsule.getEnergyFrozenBalance();
                    accountCapsule.setFrozenForEnergy(newFrozenBalanceForEnergy, expireTime);
                    long newEnergyWeight = accountCapsule.getEnergyFrozenBalance() / 1000000L;
                    increment = newEnergyWeight - oldEnergyWeight;
                }
                this.addTotalWeight(Common.ResourceCode.ENERGY, dynamicStore, frozenBalance, increment);
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenBalance() / 1000000L;
                long newFrozenBalanceForTronPower = frozenBalance + accountCapsule.getTronPowerFrozenBalance();
                accountCapsule.setFrozenForTronPower(newFrozenBalanceForTronPower, expireTime);
                long newTPWeight = accountCapsule.getTronPowerFrozenBalance() / 1000000L;
                long increment = newTPWeight - oldTPWeight;
                this.addTotalWeight(Common.ResourceCode.TRON_POWER, dynamicStore, frozenBalance, increment);
                break;
            }
            default: {
                logger.debug("Resource Code Error.");
            }
        }
        accountCapsule.setBalance(newBalance);
        accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    private void addTotalWeight(Common.ResourceCode resourceCode, DynamicPropertiesStore dynamicStore, long frozenBalance, long increment) {
        long weight = dynamicStore.allowNewReward() ? increment : frozenBalance / 1000000L;
        switch (resourceCode) {
            case BANDWIDTH: {
                dynamicStore.addTotalNetWeight(weight);
                break;
            }
            case ENERGY: {
                dynamicStore.addTotalEnergyWeight(weight);
                break;
            }
            case TRON_POWER: {
                dynamicStore.addTotalTronPowerWeight(weight);
                break;
            }
            default: {
                logger.debug("Resource Code Error.");
            }
        }
    }

    public boolean validate() throws ContractValidateException {
        byte[] receiverAddress;
        boolean needCheckFrozeTime;
        BalanceContract.FreezeBalanceContract freezeBalanceContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(BalanceContract.FreezeBalanceContract.class)) {
            throw new ContractValidateException("contract type error,expected type [FreezeBalanceContract],real type[" + this.any.getClass() + "]");
        }
        try {
            freezeBalanceContract = (BalanceContract.FreezeBalanceContract)this.any.unpack(BalanceContract.FreezeBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = freezeBalanceContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long frozenBalance = freezeBalanceContract.getFrozenBalance();
        if (frozenBalance <= 0L) {
            throw new ContractValidateException("frozenBalance must be positive");
        }
        if (frozenBalance < 1000000L) {
            throw new ContractValidateException("frozenBalance must be more than 1TRX");
        }
        int frozenCount = accountCapsule.getFrozenCount();
        if (frozenCount != 0 && frozenCount != 1) {
            throw new ContractValidateException("frozenCount must be 0 or 1");
        }
        if (frozenBalance > accountCapsule.getBalance()) {
            throw new ContractValidateException("frozenBalance must be less than accountBalance");
        }
        long frozenDuration = freezeBalanceContract.getFrozenDuration();
        long minFrozenTime = dynamicStore.getMinFrozenTime();
        long maxFrozenTime = dynamicStore.getMaxFrozenTime();
        boolean bl = needCheckFrozeTime = CommonParameter.getInstance().getCheckFrozenTime() == 1;
        if (needCheckFrozeTime && (frozenDuration < minFrozenTime || frozenDuration > maxFrozenTime)) {
            throw new ContractValidateException("frozenDuration must be less than " + maxFrozenTime + " days and more than " + minFrozenTime + " days");
        }
        switch (freezeBalanceContract.getResource()) {
            case BANDWIDTH: 
            case ENERGY: {
                break;
            }
            case TRON_POWER: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    receiverAddress = freezeBalanceContract.getReceiverAddress().toByteArray();
                    if (ArrayUtils.isEmpty((byte[])receiverAddress)) break;
                    throw new ContractValidateException("TRON_POWER is not allowed to delegate to other accounts.");
                }
                throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
            default: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY\u3001TRON_POWER]");
                }
                throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
        receiverAddress = freezeBalanceContract.getReceiverAddress().toByteArray();
        if (!ArrayUtils.isEmpty((byte[])receiverAddress) && dynamicStore.supportDR()) {
            if (Arrays.equals(receiverAddress, ownerAddress)) {
                throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
            }
            if (!DecodeUtil.addressValid((byte[])receiverAddress)) {
                throw new ContractValidateException("Invalid receiverAddress");
            }
            AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
            if (receiverCapsule == null) {
                String readableOwnerAddress = StringUtil.createReadableString((byte[])receiverAddress);
                throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
            }
            if (dynamicStore.getAllowTvmConstantinople() == 1L && receiverCapsule.getType() == Protocol.AccountType.Contract) {
                throw new ContractValidateException("Do not allow delegate resources to contract addresses");
            }
        }
        if (dynamicStore.supportUnfreezeDelay()) {
            throw new ContractValidateException("freeze v2 is open, old freeze is closed");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.FreezeBalanceContract)this.any.unpack(BalanceContract.FreezeBalanceContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }

    private long delegateResource(byte[] ownerAddress, byte[] receiverAddress, boolean isBandwidth, long balance, long expireTime) {
        long newWeight;
        long oldWeight;
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicPropertiesStore = this.chainBaseManager.getDynamicPropertiesStore();
        DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
        DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore = this.chainBaseManager.getDelegatedResourceAccountIndexStore();
        byte[] key = DelegatedResourceCapsule.createDbKey((byte[])ownerAddress, (byte[])receiverAddress);
        DelegatedResourceCapsule delegatedResourceCapsule = delegatedResourceStore.get(key);
        if (delegatedResourceCapsule != null) {
            if (isBandwidth) {
                delegatedResourceCapsule.addFrozenBalanceForBandwidth(balance, expireTime);
            } else {
                delegatedResourceCapsule.addFrozenBalanceForEnergy(balance, expireTime);
            }
        } else {
            delegatedResourceCapsule = new DelegatedResourceCapsule(ByteString.copyFrom((byte[])ownerAddress), ByteString.copyFrom((byte[])receiverAddress));
            if (isBandwidth) {
                delegatedResourceCapsule.setFrozenBalanceForBandwidth(balance, expireTime);
            } else {
                delegatedResourceCapsule.setFrozenBalanceForEnergy(balance, expireTime);
            }
        }
        delegatedResourceStore.put(key, (ProtoCapsule)delegatedResourceCapsule);
        if (!dynamicPropertiesStore.supportAllowDelegateOptimization()) {
            List fromAccountsList;
            List toAccountsList;
            DelegatedResourceAccountIndexCapsule ownerIndexCapsule = delegatedResourceAccountIndexStore.get(ownerAddress);
            if (ownerIndexCapsule == null) {
                ownerIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])ownerAddress));
            }
            if (!(toAccountsList = ownerIndexCapsule.getToAccountsList()).contains(ByteString.copyFrom((byte[])receiverAddress))) {
                ownerIndexCapsule.addToAccount(ByteString.copyFrom((byte[])receiverAddress));
            }
            delegatedResourceAccountIndexStore.put(ownerAddress, (ProtoCapsule)ownerIndexCapsule);
            DelegatedResourceAccountIndexCapsule receiverIndexCapsule = delegatedResourceAccountIndexStore.get(receiverAddress);
            if (receiverIndexCapsule == null) {
                receiverIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])receiverAddress));
            }
            if (!(fromAccountsList = receiverIndexCapsule.getFromAccountsList()).contains(ByteString.copyFrom((byte[])ownerAddress))) {
                receiverIndexCapsule.addFromAccount(ByteString.copyFrom((byte[])ownerAddress));
            }
            delegatedResourceAccountIndexStore.put(receiverAddress, (ProtoCapsule)receiverIndexCapsule);
        } else {
            delegatedResourceAccountIndexStore.convert(ownerAddress);
            delegatedResourceAccountIndexStore.convert(receiverAddress);
            delegatedResourceAccountIndexStore.delegate(ownerAddress, receiverAddress, dynamicPropertiesStore.getLatestBlockHeaderTimestamp());
        }
        AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
        if (isBandwidth) {
            oldWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() / 1000000L;
            receiverCapsule.addAcquiredDelegatedFrozenBalanceForBandwidth(balance);
            newWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() / 1000000L;
        } else {
            oldWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() / 1000000L;
            receiverCapsule.addAcquiredDelegatedFrozenBalanceForEnergy(balance);
            newWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() / 1000000L;
        }
        accountStore.put(receiverCapsule.createDbKey(), receiverCapsule);
        return newWeight - oldWeight;
    }
}

