/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.config.Parameter;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ExchangeContract;

public class ExchangeTransactionActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ExchangeTransactionActuator() {
        super(Protocol.Transaction.Contract.ContractType.ExchangeTransactionContract, ExchangeContract.ExchangeTransactionContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        ExchangeStore exchangeStore = this.chainBaseManager.getExchangeStore();
        ExchangeV2Store exchangeV2Store = this.chainBaseManager.getExchangeV2Store();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        try {
            ExchangeContract.ExchangeTransactionContract exchangeTransactionContract = (ExchangeContract.ExchangeTransactionContract)this.any.unpack(ExchangeContract.ExchangeTransactionContract.class);
            AccountCapsule accountCapsule = accountStore.get(exchangeTransactionContract.getOwnerAddress().toByteArray());
            ExchangeCapsule exchangeCapsule = Commons.getExchangeStoreFinal((DynamicPropertiesStore)dynamicStore, (ExchangeStore)exchangeStore, (ExchangeV2Store)exchangeV2Store).get(ByteArray.fromLong((long)exchangeTransactionContract.getExchangeId()));
            byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
            byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
            byte[] tokenID = exchangeTransactionContract.getTokenId().toByteArray();
            long tokenQuant = exchangeTransactionContract.getQuant();
            long anotherTokenQuant = exchangeCapsule.transaction(tokenID, tokenQuant);
            byte[] anotherTokenID = Arrays.equals(tokenID, firstTokenID) ? secondTokenID : firstTokenID;
            long newBalance = accountCapsule.getBalance() - this.calcFee();
            accountCapsule.setBalance(newBalance);
            if (Arrays.equals(tokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                accountCapsule.setBalance(newBalance - tokenQuant);
            } else {
                accountCapsule.reduceAssetAmountV2(tokenID, tokenQuant, dynamicStore, assetIssueStore);
            }
            if (Arrays.equals(anotherTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                accountCapsule.setBalance(newBalance + anotherTokenQuant);
            } else {
                accountCapsule.addAssetAmountV2(anotherTokenID, anotherTokenQuant, dynamicStore, assetIssueStore);
            }
            accountStore.put(accountCapsule.createDbKey(), accountCapsule);
            Commons.putExchangeCapsule((ExchangeCapsule)exchangeCapsule, (DynamicPropertiesStore)dynamicStore, (ExchangeStore)exchangeStore, (ExchangeV2Store)exchangeV2Store, (AssetIssueStore)assetIssueStore);
            ret.setExchangeReceivedAmount(anotherTokenQuant);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ItemNotFoundException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        long anotherTokenQuant;
        long tokenBalance;
        ExchangeCapsule exchangeCapsule;
        ExchangeContract.ExchangeTransactionContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        ExchangeStore exchangeStore = this.chainBaseManager.getExchangeStore();
        ExchangeV2Store exchangeV2Store = this.chainBaseManager.getExchangeV2Store();
        if (!this.any.is(ExchangeContract.ExchangeTransactionContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeTransactionContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (ExchangeContract.ExchangeTransactionContract)this.any.unpack(ExchangeContract.ExchangeTransactionContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!accountStore.has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange transaction fee!");
        }
        try {
            exchangeCapsule = Commons.getExchangeStoreFinal((DynamicPropertiesStore)dynamicStore, (ExchangeStore)exchangeStore, (ExchangeV2Store)exchangeV2Store).get(ByteArray.fromLong((long)contract.getExchangeId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Exchange[" + contract.getExchangeId() + "] not exists");
        }
        byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
        byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
        long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
        long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
        byte[] tokenID = contract.getTokenId().toByteArray();
        long tokenQuant = contract.getQuant();
        long tokenExpected = contract.getExpected();
        if (dynamicStore.getAllowSameTokenName() == 1L && !Arrays.equals(tokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES) && !TransactionUtil.isNumber((byte[])tokenID)) {
            throw new ContractValidateException("token id is not a valid number");
        }
        if (!Arrays.equals(tokenID, firstTokenID) && !Arrays.equals(tokenID, secondTokenID)) {
            throw new ContractValidateException("token is not in exchange");
        }
        if (tokenQuant <= 0L) {
            throw new ContractValidateException("token quant must greater than zero");
        }
        if (tokenExpected <= 0L) {
            throw new ContractValidateException("token expected must greater than zero");
        }
        if (firstTokenBalance == 0L || secondTokenBalance == 0L) {
            throw new ContractValidateException("Token balance in exchange is equal with 0,the exchange has been closed");
        }
        long balanceLimit = dynamicStore.getExchangeBalanceLimit();
        long l = tokenBalance = Arrays.equals(tokenID, firstTokenID) ? firstTokenBalance : secondTokenBalance;
        if ((tokenBalance += tokenQuant) > balanceLimit) {
            throw new ContractValidateException("token balance must less than " + balanceLimit);
        }
        if (Arrays.equals(tokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
            if (accountCapsule.getBalance() < tokenQuant + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(tokenID, tokenQuant, dynamicStore)) {
            throw new ContractValidateException("token balance is not enough");
        }
        if ((anotherTokenQuant = exchangeCapsule.transaction(tokenID, tokenQuant)) < tokenExpected) {
            throw new ContractValidateException("token required must greater than expected");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((ExchangeContract.ExchangeTransactionContract)this.any.unpack(ExchangeContract.ExchangeTransactionContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

