/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class DelegateResourceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public DelegateResourceActuator() {
        super(Protocol.Transaction.Contract.ContractType.DelegateResourceContract, BalanceContract.DelegateResourceContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        byte[] ownerAddress;
        BalanceContract.DelegateResourceContract delegateResourceContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        try {
            delegateResourceContract = (BalanceContract.DelegateResourceContract)this.any.unpack(BalanceContract.DelegateResourceContract.class);
            ownerAddress = this.getOwnerAddress().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule ownerCapsule = accountStore.get(delegateResourceContract.getOwnerAddress().toByteArray());
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        long delegateBalance = delegateResourceContract.getBalance();
        boolean lock = delegateResourceContract.getLock();
        long lockPeriod = this.getLockPeriod(dynamicStore, delegateResourceContract);
        byte[] receiverAddress = delegateResourceContract.getReceiverAddress().toByteArray();
        switch (delegateResourceContract.getResource()) {
            case BANDWIDTH: {
                this.delegateResource(ownerAddress, receiverAddress, true, delegateBalance, lock, lockPeriod);
                ownerCapsule.addDelegatedFrozenV2BalanceForBandwidth(delegateBalance);
                ownerCapsule.addFrozenBalanceForBandwidthV2(-delegateBalance);
                break;
            }
            case ENERGY: {
                this.delegateResource(ownerAddress, receiverAddress, false, delegateBalance, lock, lockPeriod);
                ownerCapsule.addDelegatedFrozenV2BalanceForEnergy(delegateBalance);
                ownerCapsule.addFrozenBalanceForEnergyV2(-delegateBalance);
                break;
            }
            default: {
                logger.debug("Resource Code Error.");
            }
        }
        accountStore.put(ownerCapsule.createDbKey(), ownerCapsule);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        byte[] receiverAddress;
        byte[] ownerAddress;
        BalanceContract.DelegateResourceContract delegateResourceContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
        if (!this.any.is(BalanceContract.DelegateResourceContract.class)) {
            throw new ContractValidateException("contract type error,expected type [DelegateResourceContract],real type[" + this.any.getClass() + "]");
        }
        if (!dynamicStore.supportDR()) {
            throw new ContractValidateException("No support for resource delegate");
        }
        if (!dynamicStore.supportUnfreezeDelay()) {
            throw new ContractValidateException("Not support Delegate resource transaction, need to be opened by the committee");
        }
        try {
            delegateResourceContract = (BalanceContract.DelegateResourceContract)this.any.unpack(BalanceContract.DelegateResourceContract.class);
            ownerAddress = this.getOwnerAddress().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerCapsule = accountStore.get(ownerAddress);
        if (ownerCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long delegateBalance = delegateResourceContract.getBalance();
        if (delegateBalance < 1000000L) {
            throw new ContractValidateException("delegateBalance must be more than 1TRX");
        }
        switch (delegateResourceContract.getResource()) {
            case BANDWIDTH: {
                BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
                processor.updateUsageForDelegated(ownerCapsule);
                long accountNetUsage = ownerCapsule.getNetUsage();
                if (null != this.getTx() && this.getTx().isTransactionCreate()) {
                    accountNetUsage += TransactionUtil.estimateConsumeBandWidthSize(ownerCapsule, this.chainBaseManager);
                }
                long netUsage = (long)((double)(accountNetUsage * 1000000L) * ((double)dynamicStore.getTotalNetWeight() / (double)dynamicStore.getTotalNetLimit()));
                long remainNetUsage = netUsage - ownerCapsule.getFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
                remainNetUsage = Math.max(0L, remainNetUsage);
                if (ownerCapsule.getFrozenV2BalanceForBandwidth() - remainNetUsage >= delegateBalance) break;
                throw new ContractValidateException("delegateBalance must be less than available FreezeBandwidthV2 balance");
            }
            case ENERGY: {
                BandwidthProcessor processor = new EnergyProcessor(dynamicStore, accountStore);
                processor.updateUsage(ownerCapsule);
                long energyUsage = (long)((double)(ownerCapsule.getEnergyUsage() * 1000000L) * ((double)dynamicStore.getTotalEnergyWeight() / (double)dynamicStore.getTotalEnergyCurrentLimit()));
                long remainEnergyUsage = energyUsage - ownerCapsule.getEnergyFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForEnergy();
                remainEnergyUsage = Math.max(0L, remainEnergyUsage);
                if (ownerCapsule.getFrozenV2BalanceForEnergy() - remainEnergyUsage >= delegateBalance) break;
                throw new ContractValidateException("delegateBalance must be less than available FreezeEnergyV2 balance");
            }
            default: {
                throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
        if (ArrayUtils.isEmpty((byte[])(receiverAddress = delegateResourceContract.getReceiverAddress().toByteArray())) || !DecodeUtil.addressValid((byte[])receiverAddress)) {
            throw new ContractValidateException("Invalid receiverAddress");
        }
        if (Arrays.equals(receiverAddress, ownerAddress)) {
            throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
        }
        AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
        if (receiverCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])receiverAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        boolean lock = delegateResourceContract.getLock();
        if (lock && dynamicStore.supportMaxDelegateLockPeriod()) {
            long lockPeriod = this.getLockPeriod(dynamicStore, delegateResourceContract);
            long maxDelegateLockPeriod = dynamicStore.getMaxDelegateLockPeriod();
            if (lockPeriod < 0L || lockPeriod > maxDelegateLockPeriod) {
                throw new ContractValidateException("The lock period of delegate resource cannot be less than 0 and cannot exceed " + maxDelegateLockPeriod + "!");
            }
            byte[] key = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)true);
            DelegatedResourceCapsule delegatedResourceCapsule = delegatedResourceStore.get(key);
            long now = dynamicStore.getLatestBlockHeaderTimestamp();
            if (delegatedResourceCapsule != null) {
                switch (delegateResourceContract.getResource()) {
                    case BANDWIDTH: {
                        this.validRemainTime(Common.ResourceCode.BANDWIDTH, lockPeriod, delegatedResourceCapsule.getExpireTimeForBandwidth(), now);
                        break;
                    }
                    case ENERGY: {
                        this.validRemainTime(Common.ResourceCode.ENERGY, lockPeriod, delegatedResourceCapsule.getExpireTimeForEnergy(), now);
                        break;
                    }
                    default: {
                        throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
                    }
                }
            }
        }
        if (receiverCapsule.getType() == Protocol.AccountType.Contract) {
            throw new ContractValidateException("Do not allow delegate resources to contract addresses");
        }
        return true;
    }

    private long getLockPeriod(DynamicPropertiesStore dynamicStore, BalanceContract.DelegateResourceContract delegateResourceContract) {
        long lockPeriod = delegateResourceContract.getLockPeriod();
        if (dynamicStore.supportMaxDelegateLockPeriod()) {
            return lockPeriod == 0L ? 86400L : lockPeriod;
        }
        return 0L;
    }

    private void validRemainTime(Common.ResourceCode resourceCode, long lockPeriod, long expireTime, long now) throws ContractValidateException {
        long remainTime = expireTime - now;
        if (lockPeriod * 3L * 1000L < remainTime) {
            throw new ContractValidateException("The lock period for " + resourceCode.name() + " this time cannot be less than the remaining time[" + remainTime + "ms] of the last lock period for " + resourceCode.name() + "!");
        }
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.DelegateResourceContract)this.any.unpack(BalanceContract.DelegateResourceContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }

    private void delegateResource(byte[] ownerAddress, byte[] receiverAddress, boolean isBandwidth, long balance, boolean lock, long lockPeriod) {
        byte[] key;
        DelegatedResourceCapsule delegatedResourceCapsule;
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicPropertiesStore = this.chainBaseManager.getDynamicPropertiesStore();
        DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
        DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore = this.chainBaseManager.getDelegatedResourceAccountIndexStore();
        long now = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        delegatedResourceStore.unLockExpireResource(ownerAddress, receiverAddress, now);
        long expireTime = 0L;
        if (lock) {
            expireTime = dynamicPropertiesStore.supportMaxDelegateLockPeriod() ? now + lockPeriod * 3L * 1000L : now + 259200000L;
        }
        if ((delegatedResourceCapsule = delegatedResourceStore.get(key = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)lock))) == null) {
            delegatedResourceCapsule = new DelegatedResourceCapsule(ByteString.copyFrom((byte[])ownerAddress), ByteString.copyFrom((byte[])receiverAddress));
        }
        if (isBandwidth) {
            delegatedResourceCapsule.addFrozenBalanceForBandwidth(balance, expireTime);
        } else {
            delegatedResourceCapsule.addFrozenBalanceForEnergy(balance, expireTime);
        }
        delegatedResourceStore.put(key, (ProtoCapsule)delegatedResourceCapsule);
        delegatedResourceAccountIndexStore.delegateV2(ownerAddress, receiverAddress, dynamicPropertiesStore.getLatestBlockHeaderTimestamp());
        AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
        if (isBandwidth) {
            receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForBandwidth(balance);
        } else {
            receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForEnergy(balance);
        }
        accountStore.put(receiverCapsule.createDbKey(), receiverCapsule);
    }
}

