/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.witness;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.db.Manager;
import org.tron.protos.Protocol;

public class ProposalController {
    private static final Logger logger = LoggerFactory.getLogger(ProposalController.class);
    private Manager manager;

    public static ProposalController createInstance(Manager manager) {
        ProposalController instance = new ProposalController();
        instance.setManager(manager);
        return instance;
    }

    public void processProposals() {
        long latestProposalNum = this.manager.getDynamicPropertiesStore().getLatestProposalNum();
        if (latestProposalNum == 0L) {
            logger.info("latestProposalNum is 0,return");
            return;
        }
        long proposalNum = latestProposalNum;
        ProposalCapsule proposalCapsule = null;
        while (proposalNum > 0L) {
            try {
                proposalCapsule = this.manager.getProposalStore().get(ProposalCapsule.calculateDbKey(proposalNum));
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                continue;
            }
            if (proposalCapsule.hasProcessed()) {
                logger.info("Proposal has processed\uff0cid:[{}],skip it and before it", (Object)proposalCapsule.getID());
                break;
            }
            if (proposalCapsule.hasCanceled()) {
                logger.info("Proposal has canceled\uff0cid:[{}],skip it", (Object)proposalCapsule.getID());
                --proposalNum;
                continue;
            }
            long currentTime = this.manager.getDynamicPropertiesStore().getNextMaintenanceTime();
            if (proposalCapsule.hasExpired(currentTime)) {
                this.processProposal(proposalCapsule);
                --proposalNum;
                continue;
            }
            --proposalNum;
            logger.info("Proposal has not expired\uff0cid:[{}],skip it", (Object)proposalCapsule.getID());
        }
        logger.info("Processing proposals done, oldest proposal[{}]", (Object)proposalNum);
    }

    public void processProposal(ProposalCapsule proposalCapsule) {
        List<ByteString> activeWitnesses = this.manager.getWitnessScheduleStore().getActiveWitnesses();
        if (proposalCapsule.hasMostApprovals(activeWitnesses)) {
            logger.info("Processing proposal,id:{},it has received most approvals, begin to set dynamic parameter:{}, and set proposal state as APPROVED", (Object)proposalCapsule.getID(), proposalCapsule.getParameters());
            this.setDynamicParameters(proposalCapsule);
            proposalCapsule.setState(Protocol.Proposal.State.APPROVED);
            this.manager.getProposalStore().put(proposalCapsule.createDbKey(), proposalCapsule);
        } else {
            logger.info("Processing proposal,id:{}, it has not received enough approvals, set proposal state as DISAPPROVED", (Object)proposalCapsule.getID());
            proposalCapsule.setState(Protocol.Proposal.State.DISAPPROVED);
            this.manager.getProposalStore().put(proposalCapsule.createDbKey(), proposalCapsule);
        }
    }

    public void setDynamicParameters(ProposalCapsule proposalCapsule) {
        Map<Long, Long> map = proposalCapsule.getInstance().getParametersMap();
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            switch (entry.getKey().intValue()) {
                case 0: {
                    this.manager.getDynamicPropertiesStore().saveMaintenanceTimeInterval(entry.getValue());
                    break;
                }
                case 1: {
                    this.manager.getDynamicPropertiesStore().saveAccountUpgradeCost(entry.getValue());
                    break;
                }
                case 2: {
                    this.manager.getDynamicPropertiesStore().saveCreateAccountFee(entry.getValue());
                    break;
                }
                case 3: {
                    this.manager.getDynamicPropertiesStore().saveTransactionFee(entry.getValue());
                    break;
                }
                case 4: {
                    this.manager.getDynamicPropertiesStore().saveAssetIssueFee(entry.getValue());
                    break;
                }
                case 5: {
                    this.manager.getDynamicPropertiesStore().saveWitnessPayPerBlock(entry.getValue());
                    break;
                }
                case 6: {
                    this.manager.getDynamicPropertiesStore().saveWitnessStandbyAllowance(entry.getValue());
                    break;
                }
                case 7: {
                    this.manager.getDynamicPropertiesStore().saveCreateNewAccountFeeInSystemContract(entry.getValue());
                    break;
                }
                case 8: {
                    this.manager.getDynamicPropertiesStore().saveCreateNewAccountBandwidthRate(entry.getValue());
                    break;
                }
                case 9: {
                    this.manager.getDynamicPropertiesStore().saveAllowCreationOfContracts(entry.getValue());
                    break;
                }
                case 10: {
                    if (this.manager.getDynamicPropertiesStore().getRemoveThePowerOfTheGr() != 0L) break;
                    this.manager.getDynamicPropertiesStore().saveRemoveThePowerOfTheGr(entry.getValue());
                    break;
                }
                case 11: {
                    this.manager.getDynamicPropertiesStore().saveEnergyFee(entry.getValue());
                    break;
                }
                case 12: {
                    this.manager.getDynamicPropertiesStore().saveExchangeCreateFee(entry.getValue());
                    break;
                }
                case 13: {
                    this.manager.getDynamicPropertiesStore().saveMaxCpuTimeOfOneTx(entry.getValue());
                    break;
                }
                case 14: {
                    this.manager.getDynamicPropertiesStore().saveAllowUpdateAccountName(entry.getValue());
                    break;
                }
                case 15: {
                    this.manager.getDynamicPropertiesStore().saveAllowSameTokenName(entry.getValue());
                    break;
                }
                case 16: {
                    this.manager.getDynamicPropertiesStore().saveAllowDelegateResource(entry.getValue());
                    break;
                }
                case 17: {
                    this.manager.getDynamicPropertiesStore().saveTotalEnergyLimit(entry.getValue());
                    break;
                }
                case 18: {
                    this.manager.getDynamicPropertiesStore().saveAllowTvmTransferTrc10(entry.getValue());
                    break;
                }
            }
        }
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Manager getManager() {
        return this.manager;
    }
}

