/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnSolidity;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.tron.api.GrpcAPI;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.AccountIdIndexStore;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.exception.StoreException;
import org.tron.core.services.interfaceOnSolidity.RpcApiServiceOnSolidity;
import org.tron.protos.Protocol;

@Component
public class WalletOnSolidity {
    private static final Logger logger = LoggerFactory.getLogger(WalletOnSolidity.class);
    @Autowired
    private Manager dbManager;

    public Protocol.Account getAccount(Protocol.Account account) {
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountCapsule accountCapsule = accountStore.getOnSolidity(account.getAddress().toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        RpcApiServiceOnSolidity.updateNetUsage(accountCapsule);
        RpcApiServiceOnSolidity.updateEnergyUsage(accountCapsule);
        long genesisTimeStamp = this.dbManager.getGenesisBlock().getTimeStamp();
        accountCapsule.setLatestConsumeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTime());
        accountCapsule.setLatestConsumeFreeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeFreeTime());
        accountCapsule.setLatestConsumeTimeForEnergy(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTimeForEnergy());
        return accountCapsule.getInstance();
    }

    public Protocol.Account getAccountById(Protocol.Account account) {
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountIdIndexStore accountIdIndexStore = this.dbManager.getAccountIdIndexStore();
        byte[] address = accountIdIndexStore.getOnSolidity(account.getAccountId());
        if (address == null) {
            return null;
        }
        AccountCapsule accountCapsule = accountStore.getOnSolidity(address);
        if (accountCapsule == null) {
            return null;
        }
        RpcApiServiceOnSolidity.updateNetUsage(accountCapsule);
        RpcApiServiceOnSolidity.updateEnergyUsage(accountCapsule);
        return accountCapsule.getInstance();
    }

    public Protocol.Block getNowBlock() {
        List<BlockCapsule> blockList = this.dbManager.getBlockStore().getBlockByLatestNumOnSolidity(1L);
        if (CollectionUtils.isEmpty(blockList)) {
            return null;
        }
        return blockList.get(0).getInstance();
    }

    public Protocol.Block getBlockByNum(long blockNum) {
        try {
            return this.dbManager.getBlockById(this.dbManager.getBlockIndexStore().getOnSolidity(blockNum)).getInstance();
        }
        catch (StoreException e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public GrpcAPI.WitnessList getWitnessList() {
        GrpcAPI.WitnessList.Builder builder = GrpcAPI.WitnessList.newBuilder();
        List<WitnessCapsule> witnessCapsuleList = this.dbManager.getWitnessStore().getAllWitnessesOnSolidity();
        witnessCapsuleList.forEach(witnessCapsule -> builder.addWitnesses(witnessCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueList() {
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        this.dbManager.getAssetIssueStoreFinal().getAllAssetIssuesOnSolidity().forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueList(long offset, long limit) {
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        List<AssetIssueCapsule> assetIssueList = this.dbManager.getAssetIssueStoreFinal().getAssetIssuesPaginatedOnSolidity(offset, limit);
        if (CollectionUtils.isEmpty(assetIssueList)) {
            return null;
        }
        assetIssueList.forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        return builder.build();
    }

    public Protocol.Transaction getTransactionById(ByteString transactionId) {
        if (Objects.isNull(transactionId)) {
            return null;
        }
        TransactionCapsule transactionCapsule = null;
        try {
            transactionCapsule = (TransactionCapsule)this.dbManager.getTransactionStore().getOnSolidity(transactionId.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (transactionCapsule != null) {
            return transactionCapsule.getInstance();
        }
        return null;
    }

    public Protocol.TransactionInfo getTransactionInfoById(ByteString transactionId) {
        if (Objects.isNull(transactionId)) {
            return null;
        }
        TransactionInfoCapsule transactionInfoCapsule = null;
        try {
            transactionInfoCapsule = (TransactionInfoCapsule)this.dbManager.getTransactionHistoryStore().getOnSolidity(transactionId.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (transactionInfoCapsule != null) {
            return transactionInfoCapsule.getInstance();
        }
        return null;
    }

    public GrpcAPI.DelegatedResourceList getDelegatedResource(ByteString fromAddress, ByteString toAddress) {
        GrpcAPI.DelegatedResourceList.Builder builder = GrpcAPI.DelegatedResourceList.newBuilder();
        byte[] dbKey = DelegatedResourceCapsule.createDbKey(fromAddress.toByteArray(), toAddress.toByteArray());
        DelegatedResourceCapsule delegatedResourceCapsule = null;
        try {
            delegatedResourceCapsule = (DelegatedResourceCapsule)this.dbManager.getDelegatedResourceStore().getOnSolidity(dbKey);
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (delegatedResourceCapsule != null) {
            builder.addDelegatedResource(delegatedResourceCapsule.getInstance());
        }
        return builder.build();
    }

    public Protocol.DelegatedResourceAccountIndex getDelegatedResourceAccountIndex(ByteString address) {
        DelegatedResourceAccountIndexCapsule accountIndexCapsule = null;
        try {
            accountIndexCapsule = (DelegatedResourceAccountIndexCapsule)this.dbManager.getDelegatedResourceAccountIndexStore().getOnSolidity(address.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (accountIndexCapsule != null) {
            return accountIndexCapsule.getInstance();
        }
        return null;
    }
}

