/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http.solidity;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.WalletSolidity;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;

@Component
public class GetTransactionsToThisServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetTransactionsToThisServlet.class);
    @Autowired
    private WalletSolidity walletSolidity;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String input = req.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            GrpcAPI.AccountPaginated.Builder builder = GrpcAPI.AccountPaginated.newBuilder();
            JsonFormat.merge(input, (Message.Builder)builder);
            GrpcAPI.AccountPaginated accountPaginated = builder.build();
            ByteString toAddress = accountPaginated.getAccount().getAddress();
            long offset = accountPaginated.getOffset();
            long limit = accountPaginated.getLimit();
            if (toAddress != null && offset >= 0L && limit >= 0L) {
                GrpcAPI.TransactionList list = this.walletSolidity.getTransactionsToThis(toAddress, offset, limit);
                resp.getWriter().println(Util.printTransactionList(list));
            } else {
                resp.getWriter().print("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                resp.getWriter().println(e.getMessage());
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
    }
}

