/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;

@Component
public class GetBlockByLatestNumServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetBlockByLatestNumServlet.class);
    @Autowired
    private Wallet wallet;
    private static final long BLOCK_LIMIT_NUM = 100L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            GrpcAPI.BlockList reply;
            long getNum = Long.parseLong(request.getParameter("num"));
            if (getNum > 0L && getNum < 100L && (reply = this.wallet.getBlockByLatestNum(getNum)) != null) {
                response.getWriter().println(Util.printBlockList(reply));
                return;
            }
            response.getWriter().println("{}");
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            GrpcAPI.BlockList reply;
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            GrpcAPI.NumberMessage.Builder build = GrpcAPI.NumberMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build);
            long getNum = build.getNum();
            if (getNum > 0L && getNum < 100L && (reply = this.wallet.getBlockByLatestNum(getNum)) != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
                return;
            }
            response.getWriter().println("{}");
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

