/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

@Component
public class DeployContractServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(DeployContractServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String name;
            byte[] byteCode;
            String contract = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Contract.CreateSmartContract.Builder build = Contract.CreateSmartContract.newBuilder();
            JSONObject jsonObject = JSONObject.parseObject((String)contract);
            byte[] ownerAddress = ByteArray.fromHexString(jsonObject.getString("owner_address"));
            build.setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress));
            build.setCallTokenValue(jsonObject.getLongValue("call_token_value")).setTokenId(jsonObject.getLongValue("token_id"));
            String abi = jsonObject.getString("abi");
            StringBuffer abiSB = new StringBuffer("{");
            abiSB.append("\"entrys\":");
            abiSB.append(abi);
            abiSB.append("}");
            Protocol.SmartContract.ABI.Builder abiBuilder = Protocol.SmartContract.ABI.newBuilder();
            JsonFormat.merge(abiSB.toString(), (Message.Builder)abiBuilder);
            long feeLimit = jsonObject.getLongValue("fee_limit");
            Protocol.SmartContract.Builder smartBuilder = Protocol.SmartContract.newBuilder();
            smartBuilder.setAbi(abiBuilder).setCallValue(jsonObject.getLongValue("call_value")).setConsumeUserResourcePercent(jsonObject.getLongValue("consume_user_resource_percent")).setOriginEnergyLimit(jsonObject.getLongValue("origin_energy_limit"));
            if (!ArrayUtils.isEmpty((byte[])ownerAddress)) {
                smartBuilder.setOriginAddress(ByteString.copyFrom((byte[])ownerAddress));
            }
            String jsonByteCode = jsonObject.getString("bytecode");
            if (jsonObject.containsKey((Object)"parameter")) {
                jsonByteCode = jsonByteCode + jsonObject.getString("parameter");
            }
            if (!ArrayUtils.isEmpty((byte[])(byteCode = ByteArray.fromHexString(jsonByteCode)))) {
                smartBuilder.setBytecode(ByteString.copyFrom((byte[])byteCode));
            }
            if (!Strings.isNullOrEmpty((String)(name = jsonObject.getString("name")))) {
                smartBuilder.setName(name);
            }
            build.setNewContract(smartBuilder);
            Protocol.Transaction tx = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.CreateSmartContract).getInstance();
            Protocol.Transaction.Builder txBuilder = tx.toBuilder();
            Protocol.Transaction.raw.Builder rawBuilder = tx.getRawData().toBuilder();
            rawBuilder.setFeeLimit(feeLimit);
            txBuilder.setRawData(rawBuilder);
            response.getWriter().println(Util.printTransaction(txBuilder.build()));
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

